/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public final class DOMStringMap
extends SimpleScriptable {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public DOMStringMap() {
    }

    public DOMStringMap(Node node) {
        this.setDomNode(node.getDomNodeOrDie(), false);
        this.setParentScope(node.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @Override
    public Object get(String name, Scriptable start) {
        String value;
        HtmlElement e = (HtmlElement)this.getDomNodeOrNull();
        if (e != null && (value = e.getAttribute("data-" + DOMStringMap.decamelize(name))) != DomElement.ATTRIBUTE_NOT_DEFINED) {
            return value;
        }
        return NOT_FOUND;
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (!(ScriptableObject.getTopLevelScope(this) instanceof Window) || this.getWindow().getWebWindow() == null) {
            super.put(name, start, value);
        } else {
            HtmlElement e = (HtmlElement)this.getDomNodeOrNull();
            if (e != null) {
                e.setAttribute("data-" + DOMStringMap.decamelize(name), Context.toString(value));
            }
        }
    }

    public static String decamelize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (Character.isUpperCase(ch)) {
                buffer.append('-').append(Character.toLowerCase(ch));
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

