/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.util.Map;
import java.util.function.Consumer;
import net.sourceforge.htmlunit.corejs.javascript.BaseFunction;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ES6Iterator;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.SymbolKey;
import net.sourceforge.htmlunit.corejs.javascript.SymbolScriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

public class Iterator
extends SimpleScriptable {
    private final java.util.Iterator<?> iterator_;

    public Iterator(String className, java.util.Iterator<?> iterator) {
        this.setClassName(className);
        this.iterator_ = iterator;
    }

    @Override
    public void setParentScope(Scriptable scope) {
        super.setParentScope(scope);
        try {
            FunctionObject functionObject = new FunctionObject("next", this.getClass().getDeclaredMethod("next", new Class[0]), scope);
            this.defineProperty("next", (Object)functionObject, 2);
        }
        catch (Exception e) {
            Context.throwAsScriptRuntimeEx(e);
        }
    }

    public SimpleScriptable next() {
        boolean done;
        Object value;
        SimpleScriptable object = new SimpleScriptable();
        object.setParentScope(this.getParentScope());
        if (this.iterator_ != null && this.iterator_.hasNext()) {
            Object next = this.iterator_.next();
            if (next instanceof Map.Entry) {
                final Map.Entry entry = (Map.Entry)next;
                NativeArray array = new NativeArray(new Object[]{entry.getKey(), entry.getValue()}){

                    @Override
                    public Object getDefaultValue(Class<?> hint) {
                        return Context.toString(entry.getKey()) + ',' + Context.toString(entry.getValue());
                    }
                };
                value = array;
            } else {
                value = next;
            }
            done = false;
        } else {
            value = Undefined.instance;
            done = true;
        }
        object.defineProperty("done", (Object)done, 0);
        object.defineProperty("value", value, 0);
        return object;
    }

    public static boolean iterate(Context context, Scriptable thisObj, Scriptable scriptable, Consumer<Object> processor) {
        if (scriptable instanceof ES6Iterator) {
            ScriptableObject next = (ScriptableObject)ScriptableObject.callMethod(scriptable, "next", null);
            boolean done = (Boolean)next.get("done");
            Object value = next.get("value");
            while (!done) {
                processor.accept(value);
                next = (ScriptableObject)ScriptableObject.callMethod(scriptable, "next", null);
                done = (Boolean)next.get("done");
                value = next.get("value");
            }
            return true;
        }
        if (!(scriptable instanceof SymbolScriptable)) {
            return false;
        }
        Object iterator = ((SymbolScriptable)((Object)scriptable)).get(SymbolKey.ITERATOR, scriptable);
        if (iterator == Scriptable.NOT_FOUND) {
            return false;
        }
        Object obj = ((BaseFunction)iterator).call(context, thisObj.getParentScope(), scriptable, new Object[0]);
        if (obj instanceof Iterator) {
            Iterator it = (Iterator)obj;
            SimpleScriptable next = it.next();
            boolean done = (Boolean)next.get("done");
            Object value = next.get("value");
            while (!done) {
                processor.accept(value);
                next = it.next();
                done = (Boolean)next.get("done");
                value = next.get("value");
            }
            return true;
        }
        if (obj instanceof Scriptable) {
            Scriptable scriptableIterator = (Scriptable)obj;
            Object nextFunct = scriptableIterator.get("next", (Scriptable)obj);
            if (!(nextFunct instanceof BaseFunction)) {
                throw ScriptRuntime.typeError("undefined is not a function");
            }
            Object nextObj = ((BaseFunction)nextFunct).call(context, thisObj.getParentScope(), scriptableIterator, new Object[0]);
            ScriptableObject next = (ScriptableObject)nextObj;
            boolean done = (Boolean)next.get("done");
            Object value = next.get("value");
            while (!done) {
                processor.accept(value);
                next = (ScriptableObject)((BaseFunction)nextFunct).call(context, thisObj.getParentScope(), scriptableIterator, new Object[0]);
                done = (Boolean)next.get("done");
                value = next.get("value");
            }
            return true;
        }
        return false;
    }
}

