/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.arrays;

import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBufferViewBase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class Int32Array
extends ArrayBufferViewBase {
    @JsxConstant
    public static final int BYTES_PER_ELEMENT = 4;

    @Override
    @JsxConstructor
    public void constructor(Object object, Object byteOffset, Object length) {
        super.constructor(object, byteOffset, length);
    }

    @Override
    protected byte[] toByteArray(Number number) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        if (number == null || Double.isInfinite(number.doubleValue())) {
            buff.putInt(0);
            return buff.array();
        }
        buff.putInt(number.intValue());
        return buff.array();
    }

    @Override
    protected Object fromArray(byte[] array, int offset) {
        if (offset < 0 || offset >= array.length) {
            return Scriptable.NOT_FOUND;
        }
        ByteBuffer buff = ByteBuffer.wrap(array);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        return buff.getInt(offset);
    }

    @Override
    protected int getBytesPerElement() {
        return 4;
    }
}

