/*
 * Decompiled with CFR 0.152.
 */
package hidden.jth.org.apache.http.protocol;

import hidden.jth.org.apache.http.HttpEntity;
import hidden.jth.org.apache.http.HttpEntityEnclosingRequest;
import hidden.jth.org.apache.http.HttpException;
import hidden.jth.org.apache.http.HttpRequest;
import hidden.jth.org.apache.http.HttpRequestInterceptor;
import hidden.jth.org.apache.http.HttpVersion;
import hidden.jth.org.apache.http.ProtocolVersion;
import hidden.jth.org.apache.http.annotation.Contract;
import hidden.jth.org.apache.http.annotation.ThreadingBehavior;
import hidden.jth.org.apache.http.protocol.HttpContext;
import hidden.jth.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

