/*
 * Decompiled with CFR 0.152.
 */
package hidden.jth.org.apache.http.impl.pool;

import hidden.jth.org.apache.http.HttpClientConnection;
import hidden.jth.org.apache.http.HttpHost;
import hidden.jth.org.apache.http.annotation.Contract;
import hidden.jth.org.apache.http.annotation.ThreadingBehavior;
import hidden.jth.org.apache.http.pool.PoolEntry;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicPoolEntry
extends PoolEntry<HttpHost, HttpClientConnection> {
    public BasicPoolEntry(String id, HttpHost route, HttpClientConnection conn) {
        super(id, route, conn);
    }

    @Override
    public void close() {
        try {
            HttpClientConnection connection = (HttpClientConnection)this.getConnection();
            try {
                int socketTimeout = connection.getSocketTimeout();
                if (socketTimeout <= 0 || socketTimeout > 1000) {
                    connection.setSocketTimeout(1000);
                }
                connection.close();
            }
            catch (IOException ex) {
                connection.shutdown();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return !((HttpClientConnection)this.getConnection()).isOpen();
    }
}

