/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.Page;
import org.htmlunit.StringWebResponse;
import org.htmlunit.WebAssert;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.WebWindowImpl;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.util.UrlUtils;

public class TopLevelWindow
extends WebWindowImpl {
    private static final Log LOG = LogFactory.getLog(TopLevelWindow.class);
    private WebWindow opener_;

    protected TopLevelWindow(String name, WebClient webClient) {
        super(webClient);
        WebAssert.notNull("name", name);
        this.setName(name);
        this.performRegistration();
    }

    @Override
    public WebWindow getParentWindow() {
        return this;
    }

    @Override
    public WebWindow getTopWindow() {
        return this;
    }

    @Override
    protected boolean isJavaScriptInitializationNeeded(Page page) {
        return this.getScriptableObject() == null || page.getUrl() == UrlUtils.URL_ABOUT_BLANK || !(page.getWebResponse() instanceof StringWebResponse);
    }

    public String toString() {
        return "TopLevelWindow[name=\"" + this.getName() + "\"]";
    }

    public void setOpener(WebWindow opener) {
        this.opener_ = opener;
    }

    public WebWindow getOpener() {
        return this.opener_;
    }

    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean ignoreOnbeforeunloadAccepted) {
        Page page = this.getEnclosedPage();
        boolean rejected = false;
        try {
            if (page != null && page.isHtmlPage()) {
                boolean accepted;
                HtmlPage htmlPage = (HtmlPage)page;
                boolean bl = accepted = ignoreOnbeforeunloadAccepted || htmlPage.isOnbeforeunloadAccepted();
                if (!accepted) {
                    LOG.debug((Object)"The registered OnbeforeunloadHandler rejected the window close event.");
                    rejected = true;
                }
            }
        }
        finally {
            if (!rejected) {
                try {
                    this.setClosed();
                }
                finally {
                    if (page != null) {
                        page.cleanUp();
                    }
                    try {
                        this.getJobManager().shutdown();
                    }
                    finally {
                        try {
                            this.destroyChildren();
                        }
                        finally {
                            this.getWebClient().deregisterWebWindow(this);
                        }
                    }
                }
            }
        }
    }
}

