/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import hidden.jth.org.apache.http.NoHttpResponseException;
import hidden.jth.org.apache.http.client.CredentialsProvider;
import hidden.jth.org.apache.http.cookie.MalformedCookieException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.AjaxController;
import org.htmlunit.AlertHandler;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.Cache;
import org.htmlunit.ClipboardHandler;
import org.htmlunit.ConfirmHandler;
import org.htmlunit.CookieManager;
import org.htmlunit.DefaultCredentialsProvider;
import org.htmlunit.DefaultCssErrorHandler;
import org.htmlunit.DefaultPageCreator;
import org.htmlunit.DialogWindow;
import org.htmlunit.DownloadedContent;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.FailingHttpStatusCodeException;
import org.htmlunit.FrameContentHandler;
import org.htmlunit.HttpMethod;
import org.htmlunit.HttpWebConnection;
import org.htmlunit.IncorrectnessListener;
import org.htmlunit.IncorrectnessListenerImpl;
import org.htmlunit.NiceRefreshHandler;
import org.htmlunit.OnbeforeunloadHandler;
import org.htmlunit.Page;
import org.htmlunit.PageCreator;
import org.htmlunit.PrintHandler;
import org.htmlunit.PromptHandler;
import org.htmlunit.ProxyConfig;
import org.htmlunit.RefreshHandler;
import org.htmlunit.ScriptPreProcessor;
import org.htmlunit.ScriptResult;
import org.htmlunit.StatusHandler;
import org.htmlunit.StorageHolder;
import org.htmlunit.StringWebResponse;
import org.htmlunit.TopLevelWindow;
import org.htmlunit.WebAssert;
import org.htmlunit.WebClientOptions;
import org.htmlunit.WebConnection;
import org.htmlunit.WebConsole;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebResponseData;
import org.htmlunit.WebResponseFromCache;
import org.htmlunit.WebWindow;
import org.htmlunit.WebWindowEvent;
import org.htmlunit.WebWindowListener;
import org.htmlunit.WebWindowNotFoundException;
import org.htmlunit.attachment.Attachment;
import org.htmlunit.attachment.AttachmentHandler;
import org.htmlunit.csp.Policy;
import org.htmlunit.csp.url.URI;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.cssparser.parser.CSSErrorHandler;
import org.htmlunit.cssparser.parser.javacc.CSS3Parser;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlInlineFrame;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.XHtmlPage;
import org.htmlunit.html.parser.HTMLParser;
import org.htmlunit.html.parser.HTMLParserListener;
import org.htmlunit.http.HttpUtils;
import org.htmlunit.httpclient.HttpClientConverter;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.DefaultJavaScriptErrorListener;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.JavaScriptErrorListener;
import org.htmlunit.javascript.background.JavaScriptJobManager;
import org.htmlunit.javascript.host.BroadcastChannel;
import org.htmlunit.javascript.host.Location;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.file.Blob;
import org.htmlunit.javascript.host.file.File;
import org.htmlunit.javascript.host.html.HTMLIFrameElement;
import org.htmlunit.protocol.data.DataURLConnection;
import org.htmlunit.util.Cookie;
import org.htmlunit.util.HeaderUtils;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.StringUtils;
import org.htmlunit.util.UrlUtils;
import org.htmlunit.websocket.JettyWebSocketAdapter;
import org.htmlunit.websocket.WebSocketAdapter;
import org.htmlunit.websocket.WebSocketAdapterFactory;
import org.htmlunit.websocket.WebSocketListener;
import org.htmlunit.webstart.WebStartHandler;

public class WebClient
implements Serializable,
AutoCloseable {
    private static final Log LOG = LogFactory.getLog(WebClient.class);
    private static final int ALLOWED_REDIRECTIONS_SAME_URL = 20;
    private static final WebResponseData RESPONSE_DATA_NO_HTTP_RESPONSE = new WebResponseData(0, "No HTTP Response", Collections.emptyList());
    private static final String[] DISCARDING_304_RESPONSE_HEADER_NAMES = new String[]{"connection", "proxy-connection", "keep-alive", "www-authenticate", "proxy-authenticate", "proxy-authorization", "te", "trailer", "transfer-encoding", "upgrade", "content-location", "content-md5", "etag", "content-encoding", "content-range", "content-type", "content-length", "x-frame-options", "x-xss-protection"};
    private static final String[] DISCARDING_304_HEADER_PREFIXES = new String[]{"x-content-", "x-webkit-"};
    private transient WebConnection webConnection_;
    private CredentialsProvider credentialsProvider_ = new DefaultCredentialsProvider();
    private CookieManager cookieManager_ = new CookieManager();
    private WebSocketAdapterFactory webSocketAdapterFactory_;
    private transient AbstractJavaScriptEngine<?> scriptEngine_;
    private transient List<LoadJob> loadQueue_;
    private final Map<String, String> requestHeaders_ = Collections.synchronizedMap(new HashMap(89));
    private IncorrectnessListener incorrectnessListener_ = new IncorrectnessListenerImpl();
    private WebConsole webConsole_;
    private transient ExecutorService executor_;
    private AlertHandler alertHandler_;
    private ConfirmHandler confirmHandler_;
    private PromptHandler promptHandler_;
    private StatusHandler statusHandler_;
    private AttachmentHandler attachmentHandler_;
    private ClipboardHandler clipboardHandler_;
    private PrintHandler printHandler_;
    private WebStartHandler webStartHandler_;
    private FrameContentHandler frameContentHandler_;
    private AjaxController ajaxController_ = new AjaxController();
    private final BrowserVersion browserVersion_;
    private PageCreator pageCreator_ = new DefaultPageCreator();
    private CurrentWindowTracker currentWindowTracker_;
    private final Set<WebWindowListener> webWindowListeners_ = new HashSet<WebWindowListener>(5);
    private final List<TopLevelWindow> topLevelWindows_ = Collections.synchronizedList(new ArrayList());
    private final List<WebWindow> windows_ = Collections.synchronizedList(new ArrayList());
    private transient List<WeakReference<JavaScriptJobManager>> jobManagers_ = Collections.synchronizedList(new ArrayList());
    private WebWindow currentWindow_;
    private HTMLParserListener htmlParserListener_;
    private CSSErrorHandler cssErrorHandler_ = new DefaultCssErrorHandler();
    private OnbeforeunloadHandler onbeforeunloadHandler_;
    private Cache cache_ = new Cache();
    private transient CSS3ParserPool css3ParserPool_ = new CSS3ParserPool();
    public static final String TARGET_BLANK = "_blank";
    public static final String TARGET_SELF = "_self";
    private static final String TARGET_PARENT = "_parent";
    private static final String TARGET_TOP = "_top";
    private ScriptPreProcessor scriptPreProcessor_;
    private RefreshHandler refreshHandler_ = new NiceRefreshHandler(2);
    private JavaScriptErrorListener javaScriptErrorListener_ = new DefaultJavaScriptErrorListener();
    private final WebClientOptions options_ = new WebClientOptions();
    private final boolean javaScriptEngineEnabled_;
    private final StorageHolder storageHolder_ = new StorageHolder();
    private transient Set<BroadcastChannel> broadcastChannel_ = new HashSet<BroadcastChannel>();

    public WebClient() {
        this(BrowserVersion.getDefault());
    }

    public WebClient(BrowserVersion browserVersion) {
        this(browserVersion, null, -1);
    }

    public WebClient(BrowserVersion browserVersion, String proxyHost, int proxyPort) {
        this(browserVersion, true, proxyHost, proxyPort, null);
    }

    public WebClient(BrowserVersion browserVersion, String proxyHost, int proxyPort, String proxyScheme) {
        this(browserVersion, true, proxyHost, proxyPort, proxyScheme);
    }

    public WebClient(BrowserVersion browserVersion, boolean javaScriptEngineEnabled, String proxyHost, int proxyPort) {
        this(browserVersion, javaScriptEngineEnabled, proxyHost, proxyPort, null);
    }

    public WebClient(BrowserVersion browserVersion, boolean javaScriptEngineEnabled, String proxyHost, int proxyPort, String proxyScheme) {
        WebAssert.notNull("browserVersion", browserVersion);
        this.browserVersion_ = browserVersion;
        this.javaScriptEngineEnabled_ = javaScriptEngineEnabled;
        if (proxyHost == null) {
            this.getOptions().setProxyConfig(new ProxyConfig());
        } else {
            this.getOptions().setProxyConfig(new ProxyConfig(proxyHost, proxyPort, proxyScheme));
        }
        this.webConnection_ = new HttpWebConnection(this);
        if (this.javaScriptEngineEnabled_) {
            this.scriptEngine_ = new JavaScriptEngine(this);
        }
        this.loadQueue_ = new ArrayList<LoadJob>();
        this.webSocketAdapterFactory_ = new JettyWebSocketAdapter.JettyWebSocketAdapterFactory();
        this.currentWindowTracker_ = new CurrentWindowTracker(this, true);
        this.currentWindow_ = new TopLevelWindow("", this);
    }

    public WebConnection getWebConnection() {
        return this.webConnection_;
    }

    public void setWebConnection(WebConnection webConnection) {
        WebAssert.notNull("webConnection", webConnection);
        this.webConnection_ = webConnection;
    }

    public <P extends Page> P getPage(WebWindow webWindow, WebRequest webRequest) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(webWindow, webRequest, true);
    }

    <P extends Page> P getPage(WebWindow webWindow, WebRequest webRequest, boolean addToHistory) throws IOException, FailingHttpStatusCodeException {
        WebResponse webResponse;
        String protocol;
        Page page = webWindow.getEnclosedPage();
        if (page != null) {
            HtmlPage htmlPage;
            URL prev = page.getUrl();
            URL current = webRequest.getUrl();
            if (UrlUtils.sameFile(current, prev) && current.getRef() != null && !Objects.equals(current.getRef(), prev.getRef())) {
                Window window;
                page.getWebResponse().getWebRequest().setUrl(current);
                if (addToHistory) {
                    webWindow.getHistory().addPage(page);
                }
                if (page instanceof HtmlPage) {
                    ((HtmlPage)page).clearComputedStyles();
                }
                if ((window = (Window)webWindow.getScriptableObject()) != null) {
                    window.getLocation().setHash(current.getRef());
                }
                return (P)page;
            }
            if (page.isHtmlPage() && !(htmlPage = (HtmlPage)page).isOnbeforeunloadAccepted()) {
                LOG.debug((Object)"The registered OnbeforeunloadHandler rejected to load a new page.");
                return (P)page;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get page for window named '" + webWindow.getName() + "', using " + webRequest));
        }
        if ("javascript".equals(protocol = webRequest.getUrl().getProtocol())) {
            webResponse = this.makeWebResponseForJavaScriptUrl(webWindow, webRequest.getUrl(), webRequest.getCharset());
            if (webWindow.getEnclosedPage() != null && webWindow.getEnclosedPage().getWebResponse() == webResponse) {
                return (P)webWindow.getEnclosedPage();
            }
        } else {
            try {
                webResponse = this.loadWebResponse(webRequest);
            }
            catch (NoHttpResponseException e) {
                webResponse = new WebResponse(RESPONSE_DATA_NO_HTTP_RESPONSE, webRequest, 0L);
            }
        }
        this.printContentIfNecessary(webResponse);
        this.loadWebResponseInto(webResponse, webWindow);
        if (this.scriptEngine_ != null) {
            this.scriptEngine_.registerWindowAndMaybeStartEventLoop(webWindow);
        }
        this.throwFailingHttpStatusCodeExceptionIfNecessary(webResponse);
        return (P)webWindow.getEnclosedPage();
    }

    public <P extends Page> P getPage(String url) throws IOException, FailingHttpStatusCodeException, MalformedURLException {
        return this.getPage(UrlUtils.toUrlUnsafe(url));
    }

    public <P extends Page> P getPage(URL url) throws IOException, FailingHttpStatusCodeException {
        WebRequest request = new WebRequest(url, this.getBrowserVersion().getHtmlAcceptHeader(), this.getBrowserVersion().getAcceptEncodingHeader());
        request.setCharset(StandardCharsets.UTF_8);
        return this.getPage(this.getCurrentWindow().getTopWindow(), request);
    }

    public <P extends Page> P getPage(WebRequest request) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow().getTopWindow(), request);
    }

    public Page loadWebResponseInto(WebResponse webResponse, WebWindow webWindow) throws IOException, FailingHttpStatusCodeException {
        return this.loadWebResponseInto(webResponse, webWindow, null);
    }

    public Page loadWebResponseInto(WebResponse webResponse, WebWindow webWindow, String forceAttachmentWithFilename) throws IOException, FailingHttpStatusCodeException {
        WebAssert.notNull("webResponse", webResponse);
        WebAssert.notNull("webWindow", webWindow);
        if (webResponse.getStatusCode() == 204) {
            return webWindow.getEnclosedPage();
        }
        if (this.webStartHandler_ != null && "application/x-java-jnlp-file".equals(webResponse.getContentType())) {
            this.webStartHandler_.handleJnlpResponse(webResponse);
            return webWindow.getEnclosedPage();
        }
        if (this.attachmentHandler_ != null && (forceAttachmentWithFilename != null || this.attachmentHandler_.isAttachment(webResponse))) {
            if (StringUtils.isEmptyOrNull(forceAttachmentWithFilename)) {
                String disp = webResponse.getResponseHeaderValue("Content-Disposition");
                forceAttachmentWithFilename = Attachment.getSuggestedFilename(disp);
            }
            if (this.attachmentHandler_.handleAttachment(webResponse, StringUtils.isEmptyOrNull(forceAttachmentWithFilename) ? null : forceAttachmentWithFilename)) {
                return webWindow.getEnclosedPage();
            }
            WebWindow w = this.openWindow(null, null, webWindow);
            Page page = this.pageCreator_.createPage(webResponse, w);
            this.attachmentHandler_.handleAttachment(page, StringUtils.isEmptyOrNull(forceAttachmentWithFilename) ? null : forceAttachmentWithFilename);
            return page;
        }
        Page oldPage = webWindow.getEnclosedPage();
        if (oldPage != null) {
            oldPage.cleanUp();
        }
        Page newPage = null;
        FrameWindow.PageDenied pageDenied = FrameWindow.PageDenied.NONE;
        if (this.windows_.contains(webWindow)) {
            if (webWindow instanceof FrameWindow) {
                String xFrameOptions;
                String contentSecurityPolicy = webResponse.getResponseHeaderValue("Content-Security-Policy");
                if (StringUtils.isNotBlank(contentSecurityPolicy)) {
                    URL origin = UrlUtils.getUrlWithoutPathRefQuery(((FrameWindow)webWindow).getEnclosingPage().getUrl());
                    URL source = UrlUtils.getUrlWithoutPathRefQuery(webResponse.getWebRequest().getUrl());
                    Policy policy = Policy.parseSerializedCSP(contentSecurityPolicy, Policy.PolicyErrorConsumer.ignored);
                    if (!policy.allowsFrameAncestor(Optional.of(URI.parseURI(source.toExternalForm()).orElse(null)), Optional.of(URI.parseURI(origin.toExternalForm()).orElse(null)))) {
                        pageDenied = FrameWindow.PageDenied.BY_CONTENT_SECURIRY_POLICY;
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Load denied by Content-Security-Policy: '" + contentSecurityPolicy + "' - " + webResponse.getWebRequest().getUrl() + "' does not permit framing."));
                        }
                    }
                }
                if (pageDenied == FrameWindow.PageDenied.NONE && "DENY".equalsIgnoreCase(xFrameOptions = webResponse.getResponseHeaderValue("X-Frame-Options"))) {
                    pageDenied = FrameWindow.PageDenied.BY_X_FRAME_OPTIONS;
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Load denied by X-Frame-Options: DENY; - '" + webResponse.getWebRequest().getUrl() + "' does not permit framing."));
                    }
                }
            }
            if (pageDenied == FrameWindow.PageDenied.NONE) {
                newPage = this.pageCreator_.createPage(webResponse, webWindow);
            } else {
                try {
                    WebResponse aboutBlank = this.loadWebResponse(WebRequest.newAboutBlankRequest());
                    newPage = this.pageCreator_.createPage(aboutBlank, webWindow);
                    ((FrameWindow)webWindow).setPageDenied(pageDenied);
                }
                catch (IOException aboutBlank) {
                    // empty catch block
                }
            }
            if (this.windows_.contains(webWindow)) {
                this.fireWindowContentChanged(new WebWindowEvent(webWindow, 3, oldPage, newPage));
                if (webWindow.getEnclosedPage() == newPage) {
                    FrameWindow fw;
                    BaseFrameElement frame;
                    newPage.initialize();
                    if (this.isJavaScriptEnabled() && webWindow instanceof FrameWindow && !newPage.isHtmlPage() && (frame = (fw = (FrameWindow)webWindow).getFrameElement()).hasEventHandlers("onload")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Executing onload handler for " + frame));
                        }
                        Event event = new Event(frame, "load");
                        ((Node)frame.getScriptableObject()).executeEventLocally(event);
                    }
                }
            }
        }
        return newPage;
    }

    public void printContentIfNecessary(WebResponse webResponse) {
        if (this.getOptions().isPrintContentOnFailingStatusCode() && !webResponse.isSuccess() && LOG.isInfoEnabled()) {
            String contentType = webResponse.getContentType();
            LOG.info((Object)("statusCode=[" + webResponse.getStatusCode() + "] contentType=[" + contentType + "]"));
            LOG.info((Object)webResponse.getContentAsString());
        }
    }

    public void throwFailingHttpStatusCodeExceptionIfNecessary(WebResponse webResponse) {
        if (this.getOptions().isThrowExceptionOnFailingStatusCode() && !webResponse.isSuccessOrUseProxyOrNotModified()) {
            throw new FailingHttpStatusCodeException(webResponse);
        }
    }

    public void addRequestHeader(String name, String value) {
        if ("cookie".equalsIgnoreCase(name)) {
            throw new IllegalArgumentException("Do not add 'Cookie' header, use .getCookieManager() instead");
        }
        this.requestHeaders_.put(name, value);
    }

    public void removeRequestHeader(String name) {
        this.requestHeaders_.remove(name);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        WebAssert.notNull("credentialsProvider", credentialsProvider);
        this.credentialsProvider_ = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider_;
    }

    public AbstractJavaScriptEngine<?> getJavaScriptEngine() {
        return this.scriptEngine_;
    }

    public void setJavaScriptEngine(AbstractJavaScriptEngine<?> engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Can't set JavaScriptEngine to null");
        }
        this.scriptEngine_ = engine;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager_;
    }

    public void setCookieManager(CookieManager cookieManager) {
        WebAssert.notNull("cookieManager", cookieManager);
        this.cookieManager_ = cookieManager;
    }

    public void setAlertHandler(AlertHandler alertHandler) {
        this.alertHandler_ = alertHandler;
    }

    public AlertHandler getAlertHandler() {
        return this.alertHandler_;
    }

    public void setConfirmHandler(ConfirmHandler handler) {
        this.confirmHandler_ = handler;
    }

    public ConfirmHandler getConfirmHandler() {
        return this.confirmHandler_;
    }

    public void setPromptHandler(PromptHandler handler) {
        this.promptHandler_ = handler;
    }

    public PromptHandler getPromptHandler() {
        return this.promptHandler_;
    }

    public void setStatusHandler(StatusHandler statusHandler) {
        this.statusHandler_ = statusHandler;
    }

    public StatusHandler getStatusHandler() {
        return this.statusHandler_;
    }

    public synchronized Executor getExecutor() {
        if (this.executor_ == null) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
            threadPoolExecutor.setThreadFactory(new ThreadNamingFactory(threadPoolExecutor.getThreadFactory()));
            this.executor_ = threadPoolExecutor;
        }
        return this.executor_;
    }

    public synchronized void setExecutor(ExecutorService executor) {
        if (this.executor_ != null) {
            throw new IllegalStateException("Can't change the executor after first use.");
        }
        this.executor_ = executor;
    }

    public void setJavaScriptErrorListener(JavaScriptErrorListener javaScriptErrorListener) {
        this.javaScriptErrorListener_ = javaScriptErrorListener == null ? new DefaultJavaScriptErrorListener() : javaScriptErrorListener;
    }

    public JavaScriptErrorListener getJavaScriptErrorListener() {
        return this.javaScriptErrorListener_;
    }

    public BrowserVersion getBrowserVersion() {
        return this.browserVersion_;
    }

    public WebWindow getCurrentWindow() {
        return this.currentWindow_;
    }

    public void setCurrentWindow(WebWindow window) {
        HtmlPage enclosedHtmlPage;
        HtmlElement activeElement;
        Page enclosedPage;
        boolean isIFrame;
        DomElement focusedElement;
        Page enclosedPage2;
        WebAssert.notNull("window", window);
        if (this.currentWindow_ == window) {
            return;
        }
        if (this.currentWindow_ != null && !this.currentWindow_.isClosed() && (enclosedPage2 = this.currentWindow_.getEnclosedPage()) != null && enclosedPage2.isHtmlPage() && (focusedElement = ((HtmlPage)enclosedPage2).getFocusedElement()) != null) {
            focusedElement.fireEvent("blur");
        }
        this.currentWindow_ = window;
        boolean bl = isIFrame = this.currentWindow_ instanceof FrameWindow && ((FrameWindow)this.currentWindow_).getFrameElement() instanceof HtmlInlineFrame;
        if (!isIFrame && (enclosedPage = this.currentWindow_.getEnclosedPage()) != null && enclosedPage.isHtmlPage() && (activeElement = (enclosedHtmlPage = (HtmlPage)enclosedPage).getActiveElement()) != null) {
            enclosedHtmlPage.setFocusedElement(activeElement, true);
        }
    }

    public void addWebWindowListener(WebWindowListener listener) {
        WebAssert.notNull("listener", listener);
        this.webWindowListeners_.add(listener);
    }

    public void removeWebWindowListener(WebWindowListener listener) {
        WebAssert.notNull("listener", listener);
        this.webWindowListeners_.remove(listener);
    }

    private void fireWindowContentChanged(WebWindowEvent event) {
        if (this.currentWindowTracker_ != null) {
            this.currentWindowTracker_.webWindowContentChanged(event);
        }
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowContentChanged(event);
        }
    }

    private void fireWindowOpened(WebWindowEvent event) {
        if (this.currentWindowTracker_ != null) {
            this.currentWindowTracker_.webWindowOpened(event);
        }
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowOpened(event);
        }
    }

    private void fireWindowClosed(WebWindowEvent event) {
        if (this.currentWindowTracker_ != null) {
            this.currentWindowTracker_.webWindowClosed(event);
        }
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowClosed(event);
        }
        if (this.currentWindowTracker_ != null) {
            this.currentWindowTracker_.afterWebWindowClosedListenersProcessed(event);
        }
    }

    public WebWindow openWindow(URL url, String windowName) {
        WebAssert.notNull("windowName", windowName);
        return this.openWindow(url, windowName, this.getCurrentWindow());
    }

    public WebWindow openWindow(URL url, String windowName, WebWindow opener) {
        WebWindow window = this.openTargetWindow(opener, windowName, TARGET_BLANK);
        if (url == null) {
            this.initializeEmptyWindow(window, window.getEnclosedPage());
        } else {
            try {
                WebRequest request = new WebRequest(url, this.getBrowserVersion().getHtmlAcceptHeader(), this.getBrowserVersion().getAcceptEncodingHeader());
                request.setCharset(StandardCharsets.UTF_8);
                Page openerPage = opener.getEnclosedPage();
                if (openerPage != null && openerPage.getUrl() != null) {
                    request.setRefererHeader(openerPage.getUrl());
                }
                this.getPage(window, request);
            }
            catch (IOException e) {
                LOG.error((Object)"Error loading content into window", (Throwable)e);
            }
        }
        return window;
    }

    public WebWindow openTargetWindow(WebWindow opener, String windowName, String defaultName) {
        WebWindow webWindow;
        WebAssert.notNull("opener", opener);
        WebAssert.notNull("defaultName", defaultName);
        String windowToOpen = windowName;
        if (windowToOpen == null || windowToOpen.isEmpty()) {
            windowToOpen = defaultName;
        }
        if ((webWindow = this.resolveWindow(opener, windowToOpen)) == null) {
            if (TARGET_BLANK.equals(windowToOpen)) {
                windowToOpen = "";
            }
            webWindow = new TopLevelWindow(windowToOpen, this);
        }
        if (webWindow instanceof TopLevelWindow && webWindow != opener.getTopWindow()) {
            ((TopLevelWindow)webWindow).setOpener(opener);
        }
        return webWindow;
    }

    private WebWindow resolveWindow(WebWindow opener, String name) {
        if (name == null || name.isEmpty() || TARGET_SELF.equals(name)) {
            return opener;
        }
        if (TARGET_PARENT.equals(name)) {
            return opener.getParentWindow();
        }
        if (TARGET_TOP.equals(name)) {
            return opener.getTopWindow();
        }
        if (TARGET_BLANK.equals(name)) {
            return null;
        }
        WebWindow window = opener;
        while (true) {
            Page page;
            if ((page = window.getEnclosedPage()) != null && page.isHtmlPage()) {
                try {
                    FrameWindow frame = ((HtmlPage)page).getFrameByName(name);
                    Object scriptable = frame.getFrameElement().getScriptableObject();
                    if (scriptable instanceof HTMLIFrameElement) {
                        ((HTMLIFrameElement)scriptable).onRefresh();
                    }
                    return frame;
                }
                catch (ElementNotFoundException elementNotFoundException) {
                    // empty catch block
                }
            }
            if (window == window.getParentWindow()) break;
            window = window.getParentWindow();
        }
        try {
            return this.getWebWindowByName(name);
        }
        catch (WebWindowNotFoundException webWindowNotFoundException) {
            return null;
        }
    }

    public DialogWindow openDialogWindow(URL url, WebWindow opener, Object dialogArguments) throws IOException {
        WebAssert.notNull("url", url);
        WebAssert.notNull("opener", opener);
        DialogWindow window = new DialogWindow(this, dialogArguments);
        HtmlPage openerPage = (HtmlPage)opener.getEnclosedPage();
        WebRequest request = new WebRequest(url, this.getBrowserVersion().getHtmlAcceptHeader(), this.getBrowserVersion().getAcceptEncodingHeader());
        request.setCharset(StandardCharsets.UTF_8);
        if (openerPage != null) {
            request.setRefererHeader(openerPage.getUrl());
        }
        this.getPage(window, request);
        return window;
    }

    public void setPageCreator(PageCreator pageCreator) {
        WebAssert.notNull("pageCreator", pageCreator);
        this.pageCreator_ = pageCreator;
    }

    public PageCreator getPageCreator() {
        return this.pageCreator_;
    }

    public WebWindow getWebWindowByName(String name) throws WebWindowNotFoundException {
        WebAssert.notNull("name", name);
        for (WebWindow webWindow : this.windows_) {
            if (!name.equals(webWindow.getName())) continue;
            return webWindow;
        }
        throw new WebWindowNotFoundException(name);
    }

    public void initialize(WebWindow webWindow, Page page) {
        WebAssert.notNull("webWindow", webWindow);
        if (this.isJavaScriptEngineEnabled()) {
            this.scriptEngine_.initialize(webWindow, page);
        }
    }

    public void initializeEmptyWindow(WebWindow webWindow, Page page) {
        WebAssert.notNull("webWindow", webWindow);
        if (this.isJavaScriptEngineEnabled()) {
            this.initialize(webWindow, page);
            ((Window)webWindow.getScriptableObject()).initialize();
        }
    }

    public void registerWebWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        if (this.windows_.add(webWindow)) {
            this.fireWindowOpened(new WebWindowEvent(webWindow, 1, webWindow.getEnclosedPage(), null));
        }
        this.jobManagers_.add(new WeakReference<JavaScriptJobManager>(webWindow.getJobManager()));
    }

    public void deregisterWebWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        if (this.windows_.remove(webWindow)) {
            this.fireWindowClosed(new WebWindowEvent(webWindow, 2, webWindow.getEnclosedPage(), null));
        }
    }

    public static URL expandUrl(URL baseUrl, String relativeUrl) throws MalformedURLException {
        String newUrl = UrlUtils.resolveUrl(baseUrl, relativeUrl);
        return UrlUtils.toUrlUnsafe(newUrl);
    }

    private WebResponse makeWebResponseForDataUrl(WebRequest webRequest) throws IOException {
        URL url = webRequest.getUrl();
        DataURLConnection connection = new DataURLConnection(url);
        ArrayList<NameValuePair> responseHeaders = new ArrayList<NameValuePair>();
        responseHeaders.add(new NameValuePair("content-type", connection.getMediaType() + ";charset=" + connection.getCharset()));
        if (HttpMethod.HEAD.equals((Object)webRequest.getHttpMethod())) {
            WebResponseData data = new WebResponseData(200, "OK", responseHeaders);
            return new WebResponse(data, url, webRequest.getHttpMethod(), 0L);
        }
        try (InputStream is = connection.getInputStream();){
            DownloadedContent downloadedContent = HttpWebConnection.downloadContent(is, this.getOptions().getMaxInMemory(), this.getOptions().getTempFileDirectory());
            WebResponseData data = new WebResponseData(downloadedContent, 200, "OK", responseHeaders);
            WebResponse webResponse = new WebResponse(data, url, webRequest.getHttpMethod(), 0L);
            return webResponse;
        }
    }

    private static WebResponse makeWebResponseForAboutUrl(WebRequest webRequest) throws MalformedURLException {
        URL url = webRequest.getUrl();
        String urlString = url.toExternalForm();
        if ("about:blank".equalsIgnoreCase(urlString)) {
            return new StringWebResponse("", UrlUtils.URL_ABOUT_BLANK);
        }
        String urlWithoutQuery = StringUtils.substringBefore(urlString, "?");
        if (!"blank".equalsIgnoreCase(hidden.jth.org.apache.commons.lang3.StringUtils.substringAfter(urlWithoutQuery, "about:"))) {
            throw new MalformedURLException(url + " is not supported, only about:blank is supported at the moment.");
        }
        return new StringWebResponse("", url);
    }

    private WebResponse makeWebResponseForFileUrl(WebRequest webRequest) throws IOException {
        WebResponse fromCache;
        URL cleanUrl = webRequest.getUrl();
        if (cleanUrl.getQuery() != null) {
            cleanUrl = UrlUtils.getUrlWithNewQuery(cleanUrl, null);
        }
        if (cleanUrl.getRef() != null) {
            cleanUrl = UrlUtils.getUrlWithNewRef(cleanUrl, null);
        }
        if ((fromCache = this.getCache().getCachedResponse(webRequest)) != null) {
            return new WebResponseFromCache(fromCache, webRequest);
        }
        String fileUrl = cleanUrl.toExternalForm();
        java.io.File file = new java.io.File((fileUrl = URLDecoder.decode(fileUrl, StandardCharsets.UTF_8.name())).substring(5));
        if (!file.exists()) {
            ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
            compiledHeaders.add(new NameValuePair("Content-Type", "text/html"));
            WebResponseData responseData = new WebResponseData(StringUtils.toByteArray("File: " + file.getAbsolutePath(), StandardCharsets.UTF_8), 404, "Not Found", compiledHeaders);
            return new WebResponse(responseData, webRequest, 0L);
        }
        String contentType = this.guessContentType(file);
        DownloadedContent.OnFile content = new DownloadedContent.OnFile(file, false);
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
        compiledHeaders.add(new NameValuePair("Content-Type", contentType));
        compiledHeaders.add(new NameValuePair("Last-Modified", HttpUtils.formatDate(new Date(file.lastModified()))));
        WebResponseData responseData = new WebResponseData(content, 200, "OK", compiledHeaders);
        WebResponse webResponse = new WebResponse(responseData, webRequest, 0L);
        this.getCache().cacheIfPossible(webRequest, webResponse, null);
        return webResponse;
    }

    private WebResponse makeWebResponseForBlobUrl(WebRequest webRequest) {
        File file;
        String fileName;
        Window window = (Window)this.getCurrentWindow().getScriptableObject();
        Blob fileOrBlob = window.getDocument().resolveBlobUrl(webRequest.getUrl().toString());
        if (fileOrBlob == null) {
            throw JavaScriptEngine.typeError("Cannot load data from " + webRequest.getUrl());
        }
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        String type = fileOrBlob.getType();
        if (!StringUtils.isEmptyOrNull(type)) {
            headers.add(new NameValuePair("Content-Type", fileOrBlob.getType()));
        }
        if (fileOrBlob instanceof File && !StringUtils.isEmptyOrNull(fileName = (file = (File)fileOrBlob).getName())) {
            headers.add(new NameValuePair("Content-Disposition", "inline; filename=\"" + fileName + "\""));
        }
        DownloadedContent.InMemory content = new DownloadedContent.InMemory(fileOrBlob.getBytes());
        WebResponseData responseData = new WebResponseData(content, 200, "OK", headers);
        return new WebResponse(responseData, webRequest, 0L);
    }

    public String guessContentType(java.io.File file) {
        String fileName = file.getName();
        String fileNameLC = fileName.toLowerCase(Locale.ROOT);
        if (fileNameLC.endsWith(".xhtml")) {
            return "application/xhtml+xml";
        }
        if (fileNameLC.endsWith(".js")) {
            return "text/javascript";
        }
        if (fileNameLC.endsWith(".css")) {
            return "text/css";
        }
        String contentType = null;
        if (!fileNameLC.endsWith(".php")) {
            contentType = URLConnection.guessContentTypeFromName(fileName);
        }
        if (contentType == null) {
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                contentType = URLConnection.guessContentTypeFromStream(inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    private WebResponse makeWebResponseForJavaScriptUrl(WebWindow webWindow, URL url, Charset charset) throws FailingHttpStatusCodeException, IOException {
        ScriptResult r;
        HtmlPage page = null;
        if (webWindow instanceof FrameWindow) {
            FrameWindow frameWindow = (FrameWindow)webWindow;
            page = (HtmlPage)frameWindow.getEnclosedPage();
        } else {
            Page currentPage = webWindow.getEnclosedPage();
            if (currentPage instanceof HtmlPage) {
                page = (HtmlPage)currentPage;
            }
        }
        if (page == null) {
            page = (HtmlPage)this.getPage(webWindow, WebRequest.newAboutBlankRequest());
        }
        if ((r = page.executeJavaScript(url.toExternalForm(), "JavaScript URL", 1)).getJavaScriptResult() == null || ScriptResult.isUndefined(r)) {
            return webWindow.getEnclosedPage().getWebResponse();
        }
        String contentString = r.getJavaScriptResult().toString();
        StringWebResponse response = new StringWebResponse(contentString, charset, url);
        response.setFromJavascript(true);
        return response;
    }

    public WebResponse loadWebResponse(WebRequest webRequest) throws IOException {
        String protocol;
        switch (protocol = webRequest.getUrl().getProtocol()) {
            case "about": {
                return WebClient.makeWebResponseForAboutUrl(webRequest);
            }
            case "file": {
                return this.makeWebResponseForFileUrl(webRequest);
            }
            case "data": {
                return this.makeWebResponseForDataUrl(webRequest);
            }
            case "blob": {
                return this.makeWebResponseForBlobUrl(webRequest);
            }
            case "http": 
            case "https": {
                return this.loadWebResponseFromWebConnection(webRequest, 20);
            }
        }
        throw new IOException("Unsupported protocol '" + protocol + "'");
    }

    private WebResponse loadWebResponseFromWebConnection(WebRequest webRequest, int allowedRedirects) throws IOException {
        URL url = webRequest.getUrl();
        HttpMethod method = webRequest.getHttpMethod();
        List<NameValuePair> parameters = webRequest.getRequestParameters();
        WebAssert.notNull("url", url);
        WebAssert.notNull("method", (Object)method);
        WebAssert.notNull("parameters", parameters);
        url = UrlUtils.encodeUrl(url, webRequest.getCharset());
        webRequest.setUrl(url);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Load response for " + (Object)((Object)method) + " " + url.toExternalForm()));
        }
        if (webRequest.getProxyHost() == null) {
            ProxyConfig proxyConfig = this.getOptions().getProxyConfig();
            if (proxyConfig.getProxyAutoConfigUrl() != null) {
                if (!UrlUtils.sameFile(new URL(proxyConfig.getProxyAutoConfigUrl()), url)) {
                    int colonIndex;
                    String value;
                    String content = proxyConfig.getProxyAutoConfigContent();
                    if (content == null) {
                        content = this.getPage(proxyConfig.getProxyAutoConfigUrl()).getWebResponse().getContentAsString();
                        proxyConfig.setProxyAutoConfigContent(content);
                    }
                    String allValue = JavaScriptEngine.evaluateProxyAutoConfig(this.getBrowserVersion(), content, url);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Proxy Auto-Config: value '" + allValue + "' for URL " + url));
                    }
                    if ((value = allValue.split(";")[0].trim()).startsWith("PROXY")) {
                        value = value.substring(6);
                        colonIndex = value.indexOf(58);
                        webRequest.setSocksProxy(false);
                        webRequest.setProxyHost(value.substring(0, colonIndex));
                        webRequest.setProxyPort(Integer.parseInt(value.substring(colonIndex + 1)));
                    } else if (value.startsWith("SOCKS")) {
                        value = value.substring(6);
                        colonIndex = value.indexOf(58);
                        webRequest.setSocksProxy(true);
                        webRequest.setProxyHost(value.substring(0, colonIndex));
                        webRequest.setProxyPort(Integer.parseInt(value.substring(colonIndex + 1)));
                    }
                }
            } else if (!proxyConfig.shouldBypassProxy(webRequest.getUrl().getHost())) {
                webRequest.setProxyHost(proxyConfig.getProxyHost());
                webRequest.setProxyPort(proxyConfig.getProxyPort());
                webRequest.setProxyScheme(proxyConfig.getProxyScheme());
                webRequest.setSocksProxy(proxyConfig.isSocksProxy());
            }
        }
        this.addDefaultHeaders(webRequest);
        WebResponse fromCache = this.getCache().getCachedResponse(webRequest);
        WebResponse webResponse = this.getWebResponseOrUseCached(webRequest, fromCache);
        int status = webResponse.getStatusCode();
        if (status == 305) {
            this.getIncorrectnessListener().notify("Ignoring HTTP status code [305] 'Use Proxy'", this);
        } else if (status >= 301 && status <= 308 && status != 304 && this.getOptions().isRedirectEnabled()) {
            URL newUrl;
            String locationString = null;
            try {
                locationString = webResponse.getResponseHeaderValue("Location");
                if (locationString == null) {
                    return webResponse;
                }
                locationString = new String(locationString.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
                newUrl = WebClient.expandUrl(url, locationString);
            }
            catch (MalformedURLException e) {
                this.getIncorrectnessListener().notify("Got a redirect status code [" + status + " " + webResponse.getStatusMessage() + "] but the location is not a valid URL [" + locationString + "]. Skipping redirection processing.", this);
                return webResponse;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Got a redirect status code [" + status + "] new location = [" + locationString + "]"));
            }
            if (allowedRedirects == 0) {
                throw new FailingHttpStatusCodeException("Too many redirects for " + webResponse.getWebRequest().getUrl(), webResponse);
            }
            if (status == 301 || status == 302 || status == 303) {
                WebRequest wrs = new WebRequest(newUrl, HttpMethod.GET);
                wrs.setCharset(webRequest.getCharset());
                if (HttpMethod.HEAD == webRequest.getHttpMethod()) {
                    wrs.setHttpMethod(HttpMethod.HEAD);
                }
                for (Map.Entry<String, String> entry : webRequest.getAdditionalHeaders().entrySet()) {
                    wrs.setAdditionalHeader(entry.getKey(), entry.getValue());
                }
                return this.loadWebResponseFromWebConnection(wrs, allowedRedirects - 1);
            }
            if (status == 307 || status == 308) {
                WebRequest wrs = new WebRequest(newUrl, webRequest.getHttpMethod());
                wrs.setCharset(webRequest.getCharset());
                if (webRequest.getRequestBody() != null) {
                    if (HttpMethod.POST == webRequest.getHttpMethod() || HttpMethod.PUT == webRequest.getHttpMethod() || HttpMethod.PATCH == webRequest.getHttpMethod()) {
                        wrs.setRequestBody(webRequest.getRequestBody());
                        wrs.setEncodingType(webRequest.getEncodingType());
                    }
                } else {
                    wrs.setRequestParameters(parameters);
                }
                for (Map.Entry<String, String> entry : webRequest.getAdditionalHeaders().entrySet()) {
                    wrs.setAdditionalHeader(entry.getKey(), entry.getValue());
                }
                return this.loadWebResponseFromWebConnection(wrs, allowedRedirects - 1);
            }
        }
        if (fromCache == null) {
            this.getCache().cacheIfPossible(webRequest, webResponse, null);
        }
        return webResponse;
    }

    private WebResponse getWebResponseOrUseCached(WebRequest webRequest, WebResponse cached) throws IOException {
        WebResponse webResponse;
        if (cached == null) {
            return this.getWebConnection().getResponse(webRequest);
        }
        if (!HeaderUtils.containsNoCache(cached)) {
            return new WebResponseFromCache(cached, webRequest);
        }
        if (HeaderUtils.containsETag(cached)) {
            webRequest.setAdditionalHeader("If-None-Match", cached.getResponseHeaderValue("Etag"));
        }
        if (HeaderUtils.containsLastModified(cached)) {
            webRequest.setAdditionalHeader("If-Modified-Since", cached.getResponseHeaderValue("Last-Modified"));
        }
        if ((webResponse = this.getWebConnection().getResponse(webRequest)).getStatusCode() >= 500) {
            return new WebResponseFromCache(cached, webRequest);
        }
        if (webResponse.getStatusCode() == 304) {
            LinkedHashMap<String, NameValuePair> header2NameValuePair = new LinkedHashMap<String, NameValuePair>();
            for (NameValuePair pair : cached.getResponseHeaders()) {
                header2NameValuePair.put(pair.getName(), pair);
            }
            for (NameValuePair pair : webResponse.getResponseHeaders()) {
                if (!WebClient.preferHeaderFrom304Response(pair.getName())) continue;
                header2NameValuePair.put(pair.getName(), pair);
            }
            WebResponseFromCache updatedCached = new WebResponseFromCache(cached, new ArrayList<NameValuePair>(header2NameValuePair.values()), webRequest);
            this.getCache().cacheIfPossible(webRequest, updatedCached, null);
            return updatedCached;
        }
        this.getCache().cacheIfPossible(webRequest, webResponse, null);
        return webResponse;
    }

    private static boolean preferHeaderFrom304Response(String name) {
        String lcName = name.toLowerCase(Locale.ROOT);
        for (String header : DISCARDING_304_RESPONSE_HEADER_NAMES) {
            if (!lcName.equals(header)) continue;
            return false;
        }
        for (String prefix : DISCARDING_304_HEADER_PREFIXES) {
            if (!lcName.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    private void addDefaultHeaders(WebRequest wrs) {
        this.requestHeaders_.forEach((name, value) -> {
            if (!wrs.isAdditionalHeader((String)name)) {
                wrs.setAdditionalHeader((String)name, (String)value);
            }
        });
        if (!wrs.isAdditionalHeader("Accept-Language")) {
            wrs.setAdditionalHeader("Accept-Language", this.getBrowserVersion().getAcceptLanguageHeader());
        }
        if (!wrs.isAdditionalHeader("Sec-Fetch-Dest")) {
            wrs.setAdditionalHeader("Sec-Fetch-Dest", "document");
        }
        if (!wrs.isAdditionalHeader("Sec-Fetch-Mode")) {
            wrs.setAdditionalHeader("Sec-Fetch-Mode", "navigate");
        }
        if (!wrs.isAdditionalHeader("Sec-Fetch-Site")) {
            wrs.setAdditionalHeader("Sec-Fetch-Site", "same-origin");
        }
        if (!wrs.isAdditionalHeader("Sec-Fetch-User")) {
            wrs.setAdditionalHeader("Sec-Fetch-User", "?1");
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTTP_HEADER_PRIORITY) && !wrs.isAdditionalHeader("Priority")) {
            wrs.setAdditionalHeader("Priority", "u=0, i");
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTTP_HEADER_CH_UA) && !wrs.isAdditionalHeader("sec-ch-ua")) {
            wrs.setAdditionalHeader("sec-ch-ua", this.getBrowserVersion().getSecClientHintUserAgentHeader());
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTTP_HEADER_CH_UA) && !wrs.isAdditionalHeader("sec-ch-ua-mobile")) {
            wrs.setAdditionalHeader("sec-ch-ua-mobile", "?0");
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTTP_HEADER_CH_UA) && !wrs.isAdditionalHeader("sec-ch-ua-platform")) {
            wrs.setAdditionalHeader("sec-ch-ua-platform", this.getBrowserVersion().getSecClientHintUserAgentPlatformHeader());
        }
        if (!wrs.isAdditionalHeader("Upgrade-Insecure-Requests")) {
            wrs.setAdditionalHeader("Upgrade-Insecure-Requests", "1");
        }
    }

    public List<WebWindow> getWebWindows() {
        return Collections.unmodifiableList(new ArrayList<WebWindow>(this.windows_));
    }

    public boolean containsWebWindow(WebWindow webWindow) {
        return this.windows_.contains(webWindow);
    }

    public List<TopLevelWindow> getTopLevelWindows() {
        return Collections.unmodifiableList(new ArrayList<TopLevelWindow>(this.topLevelWindows_));
    }

    public void setRefreshHandler(RefreshHandler handler) {
        this.refreshHandler_ = handler == null ? new NiceRefreshHandler(2) : handler;
    }

    public RefreshHandler getRefreshHandler() {
        return this.refreshHandler_;
    }

    public void setScriptPreProcessor(ScriptPreProcessor scriptPreProcessor) {
        this.scriptPreProcessor_ = scriptPreProcessor;
    }

    public ScriptPreProcessor getScriptPreProcessor() {
        return this.scriptPreProcessor_;
    }

    public void setHTMLParserListener(HTMLParserListener listener) {
        this.htmlParserListener_ = listener;
    }

    public HTMLParserListener getHTMLParserListener() {
        return this.htmlParserListener_;
    }

    public CSSErrorHandler getCssErrorHandler() {
        return this.cssErrorHandler_;
    }

    public void setCssErrorHandler(CSSErrorHandler cssErrorHandler) {
        WebAssert.notNull("cssErrorHandler", cssErrorHandler);
        this.cssErrorHandler_ = cssErrorHandler;
    }

    public void setJavaScriptTimeout(long timeout) {
        this.scriptEngine_.setJavaScriptTimeout(timeout);
    }

    public long getJavaScriptTimeout() {
        return this.scriptEngine_.getJavaScriptTimeout();
    }

    public IncorrectnessListener getIncorrectnessListener() {
        return this.incorrectnessListener_;
    }

    public void setIncorrectnessListener(IncorrectnessListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null is not a valid IncorrectnessListener");
        }
        this.incorrectnessListener_ = listener;
    }

    public WebConsole getWebConsole() {
        if (this.webConsole_ == null) {
            this.webConsole_ = new WebConsole();
        }
        return this.webConsole_;
    }

    public AjaxController getAjaxController() {
        return this.ajaxController_;
    }

    public void setAjaxController(AjaxController newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Null is not a valid AjaxController");
        }
        this.ajaxController_ = newValue;
    }

    public void setAttachmentHandler(AttachmentHandler handler) {
        this.attachmentHandler_ = handler;
    }

    public AttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler_;
    }

    public void setWebStartHandler(WebStartHandler handler) {
        this.webStartHandler_ = handler;
    }

    public WebStartHandler getWebStartHandler() {
        return this.webStartHandler_;
    }

    public ClipboardHandler getClipboardHandler() {
        return this.clipboardHandler_;
    }

    public void setClipboardHandler(ClipboardHandler handler) {
        this.clipboardHandler_ = handler;
    }

    public PrintHandler getPrintHandler() {
        return this.printHandler_;
    }

    public void setPrintHandler(PrintHandler handler) {
        this.printHandler_ = handler;
    }

    public FrameContentHandler getFrameContentHandler() {
        return this.frameContentHandler_;
    }

    public void setFrameContentHandler(FrameContentHandler handler) {
        this.frameContentHandler_ = handler;
    }

    public void setOnbeforeunloadHandler(OnbeforeunloadHandler onbeforeunloadHandler) {
        this.onbeforeunloadHandler_ = onbeforeunloadHandler;
    }

    public OnbeforeunloadHandler getOnbeforeunloadHandler() {
        return this.onbeforeunloadHandler_;
    }

    public Cache getCache() {
        return this.cache_;
    }

    public void setCache(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache should not be null!");
        }
        this.cache_ = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DialogWindow dialogWindow;
        TopLevelWindow topLevelWindow;
        if (this.scriptEngine_ != null) {
            this.scriptEngine_.prepareShutdown();
        }
        this.currentWindowTracker_ = new CurrentWindowTracker(this, false);
        ArrayList<WebWindow> windows = new ArrayList<WebWindow>(this.windows_);
        for (WebWindow window : windows) {
            if (window instanceof TopLevelWindow) {
                topLevelWindow = (TopLevelWindow)window;
                try {
                    topLevelWindow.close(true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception while closing a TopLevelWindow", (Throwable)e);
                }
                continue;
            }
            if (!(window instanceof DialogWindow)) continue;
            dialogWindow = (DialogWindow)window;
            try {
                dialogWindow.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while closing a DialogWindow", (Throwable)e);
            }
        }
        windows = new ArrayList<WebWindow>(this.windows_);
        for (WebWindow window : windows) {
            if (window instanceof TopLevelWindow) {
                topLevelWindow = (TopLevelWindow)window;
                try {
                    topLevelWindow.close(true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception while closing a TopLevelWindow", (Throwable)e);
                }
                continue;
            }
            if (!(window instanceof DialogWindow)) continue;
            dialogWindow = (DialogWindow)window;
            try {
                dialogWindow.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while closing a DialogWindow", (Throwable)e);
            }
        }
        if (!this.topLevelWindows_.isEmpty()) {
            LOG.error((Object)("Sill " + this.topLevelWindows_.size() + " top level windows are open. Please report this error!"));
            this.topLevelWindows_.clear();
        }
        if (!this.windows_.isEmpty()) {
            LOG.error((Object)("Sill " + this.windows_.size() + " windows are open. Please report this error!"));
            this.windows_.clear();
        }
        this.currentWindow_ = null;
        ThreadDeath toThrow = null;
        if (this.scriptEngine_ != null) {
            try {
                this.scriptEngine_.shutdown();
            }
            catch (ThreadDeath ex) {
                toThrow = ex;
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while shutdown the scriptEngine", (Throwable)e);
            }
        }
        this.scriptEngine_ = null;
        if (this.webConnection_ != null) {
            try {
                this.webConnection_.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while closing the connection", (Throwable)e);
            }
        }
        this.webConnection_ = null;
        WebClient webClient = this;
        synchronized (webClient) {
            if (this.executor_ != null) {
                try {
                    this.executor_.shutdownNow();
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception while shutdown the executor service", (Throwable)e);
                }
            }
        }
        this.executor_ = null;
        this.cache_.clear();
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public void reset() {
        this.close();
        this.webConnection_ = new HttpWebConnection(this);
        if (this.javaScriptEngineEnabled_) {
            this.scriptEngine_ = new JavaScriptEngine(this);
        }
        this.currentWindowTracker_ = new CurrentWindowTracker(this, true);
        this.currentWindow_ = new TopLevelWindow("", this);
    }

    public int waitForBackgroundJavaScript(long timeoutMillis) {
        int count = 0;
        long endTime = System.currentTimeMillis() + timeoutMillis;
        Iterator<WeakReference<JavaScriptJobManager>> i = this.jobManagers_.iterator();
        while (i.hasNext()) {
            JavaScriptJobManager jobManager;
            block5: {
                try {
                    WeakReference<JavaScriptJobManager> reference = i.next();
                    jobManager = (JavaScriptJobManager)reference.get();
                    if (jobManager == null) {
                        i.remove();
                    }
                    break block5;
                }
                catch (ConcurrentModificationException e) {
                    i = this.jobManagers_.iterator();
                    count = 0;
                }
                continue;
            }
            long newTimeout = endTime - System.currentTimeMillis();
            count += jobManager.waitForJobs(newTimeout);
        }
        if (count != this.getAggregateJobCount()) {
            long newTimeout = endTime - System.currentTimeMillis();
            return this.waitForBackgroundJavaScript(newTimeout);
        }
        return count;
    }

    public int waitForBackgroundJavaScriptStartingBefore(long delayMillis) {
        return this.waitForBackgroundJavaScriptStartingBefore(delayMillis, -1L);
    }

    public int waitForBackgroundJavaScriptStartingBefore(long delayMillis, long timeoutMillis) {
        int count = 0;
        long now = System.currentTimeMillis();
        long endTime = now + delayMillis;
        long endTimeout = now + timeoutMillis;
        if (timeoutMillis < 0L || timeoutMillis < delayMillis) {
            endTimeout = -1L;
        }
        Iterator<WeakReference<JavaScriptJobManager>> i = this.jobManagers_.iterator();
        while (i.hasNext()) {
            JavaScriptJobManager jobManager;
            block6: {
                try {
                    WeakReference<JavaScriptJobManager> reference = i.next();
                    jobManager = (JavaScriptJobManager)reference.get();
                    if (jobManager == null) {
                        i.remove();
                    }
                    break block6;
                }
                catch (ConcurrentModificationException e) {
                    i = this.jobManagers_.iterator();
                    count = 0;
                }
                continue;
            }
            now = System.currentTimeMillis();
            long newDelay = endTime - now;
            long newTimeout = endTimeout == -1L ? -1L : endTimeout - now;
            count += jobManager.waitForJobsStartingBefore(newDelay, newTimeout);
        }
        if (count != this.getAggregateJobCount()) {
            now = System.currentTimeMillis();
            long newDelay = endTime - now;
            long newTimeout = endTimeout == -1L ? -1L : endTimeout - now;
            return this.waitForBackgroundJavaScriptStartingBefore(newDelay, newTimeout);
        }
        return count;
    }

    private int getAggregateJobCount() {
        int count = 0;
        Iterator<WeakReference<JavaScriptJobManager>> i = this.jobManagers_.iterator();
        while (i.hasNext()) {
            JavaScriptJobManager jobManager;
            block4: {
                try {
                    WeakReference<JavaScriptJobManager> reference = i.next();
                    jobManager = (JavaScriptJobManager)reference.get();
                    if (jobManager == null) {
                        i.remove();
                    }
                    break block4;
                }
                catch (ConcurrentModificationException e) {
                    i = this.jobManagers_.iterator();
                    count = 0;
                }
                continue;
            }
            int jobCount = jobManager.getJobCount();
            count += jobCount;
        }
        return count;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.webConnection_ = new HttpWebConnection(this);
        this.scriptEngine_ = new JavaScriptEngine(this);
        this.jobManagers_ = Collections.synchronizedList(new ArrayList());
        this.loadQueue_ = new ArrayList<LoadJob>();
        this.css3ParserPool_ = new CSS3ParserPool();
        this.broadcastChannel_ = new HashSet<BroadcastChannel>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(WebWindow requestingWindow, String target, WebRequest request, boolean checkHash, String forceAttachmentWithFilename, String description) {
        LoadJob loadJob;
        Object page;
        WebWindow targetWindow = this.resolveWindow(requestingWindow, target);
        URL url = request.getUrl();
        if (targetWindow != null && HttpMethod.POST != request.getHttpMethod() && (page = targetWindow.getEnclosedPage()) != null) {
            if (page.isHtmlPage() && !((HtmlPage)page).isOnbeforeunloadAccepted()) {
                return;
            }
            if (checkHash) {
                boolean justHashJump;
                URL current = page.getUrl();
                boolean bl = justHashJump = HttpMethod.GET == request.getHttpMethod() && UrlUtils.sameFile(url, current) && null != url.getRef();
                if (justHashJump) {
                    WebClient.processOnlyHashChange(targetWindow, url);
                    return;
                }
            }
        }
        page = this.loadQueue_;
        synchronized (page) {
            for (LoadJob otherLoadJob : this.loadQueue_) {
                if (otherLoadJob.response_ == null) continue;
                WebRequest otherRequest = otherLoadJob.request_;
                URL otherUrl = otherRequest.getUrl();
                if (!url.getPath().equals(otherUrl.getPath()) || !url.toString().equals(otherUrl.toString()) || !request.getRequestParameters().equals(otherRequest.getRequestParameters()) || !Objects.equals(request.getRequestBody(), otherRequest.getRequestBody())) continue;
                return;
            }
        }
        try {
            WebResponse response;
            try {
                response = this.loadWebResponse(request);
            }
            catch (NoHttpResponseException e) {
                LOG.error((Object)"NoHttpResponseException while downloading; generating a NoHttpResponse", (Throwable)e);
                response = new WebResponse(RESPONSE_DATA_NO_HTTP_RESPONSE, request, 0L);
            }
            loadJob = new LoadJob(request, response, requestingWindow, target, forceAttachmentWithFilename);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<LoadJob> list = this.loadQueue_;
        synchronized (list) {
            this.loadQueue_.add(loadJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDownloadedResponses() throws FailingHttpStatusCodeException, IOException {
        ArrayList<LoadJob> queue;
        List<LoadJob> list = this.loadQueue_;
        synchronized (list) {
            if (this.loadQueue_.isEmpty()) {
                return;
            }
            queue = new ArrayList<LoadJob>(this.loadQueue_);
            this.loadQueue_.clear();
        }
        HashSet<WebWindow> updatedWindows = new HashSet<WebWindow>();
        for (int i = queue.size() - 1; i >= 0; --i) {
            LoadJob loadJob = (LoadJob)queue.get(i);
            if (loadJob.isOutdated()) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("No usage of download: " + loadJob));
                continue;
            }
            WebWindow window = this.resolveWindow(loadJob.requestingWindow_, loadJob.target_);
            if (updatedWindows.contains(window)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("No usage of download: " + loadJob));
                continue;
            }
            WebWindow win = this.openTargetWindow(loadJob.requestingWindow_, loadJob.target_, TARGET_SELF);
            Page pageBeforeLoad = win.getEnclosedPage();
            this.loadWebResponseInto(loadJob.response_, win, loadJob.forceAttachmentWithFilename_);
            if (this.scriptEngine_ != null) {
                this.scriptEngine_.registerWindowAndMaybeStartEventLoop(win);
            }
            if (pageBeforeLoad != win.getEnclosedPage()) {
                updatedWindows.add(win);
            }
            this.throwFailingHttpStatusCodeExceptionIfNecessary(loadJob.response_);
        }
    }

    private static void processOnlyHashChange(WebWindow window, URL urlWithOnlyHashChange) {
        Page page = window.getEnclosedPage();
        String oldURL = page.getUrl().toExternalForm();
        WebRequest req = page.getWebResponse().getWebRequest();
        req.setUrl(urlWithOnlyHashChange);
        Window jsWindow = (Window)window.getScriptableObject();
        if (null != jsWindow) {
            Location location = jsWindow.getLocation();
            location.setHash(oldURL, urlWithOnlyHashChange.getRef());
        }
        window.getHistory().addPage(page);
    }

    public WebClientOptions getOptions() {
        return this.options_;
    }

    public StorageHolder getStorageHolder() {
        return this.storageHolder_;
    }

    public synchronized Set<Cookie> getCookies(URL url) {
        CookieManager cookieManager = this.getCookieManager();
        if (!cookieManager.isCookiesEnabled()) {
            return Collections.emptySet();
        }
        URL normalizedUrl = HttpClientConverter.replaceForCookieIfNecessary(url);
        String host = normalizedUrl.getHost();
        if (host.isEmpty()) {
            return Collections.emptySet();
        }
        cookieManager.clearExpired(new Date());
        LinkedHashSet<Cookie> matchingCookies = new LinkedHashSet<Cookie>();
        HttpClientConverter.addMatching(cookieManager.getCookies(), normalizedUrl, this.getBrowserVersion(), matchingCookies);
        return Collections.unmodifiableSet(matchingCookies);
    }

    public void addCookie(String cookieString, URL pageUrl, Object origin) {
        CookieManager cookieManager = this.getCookieManager();
        if (!cookieManager.isCookiesEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipped adding cookie: '" + cookieString + "' because cookies are not enabled for the CookieManager."));
            }
            return;
        }
        try {
            List<Cookie> cookies = HttpClientConverter.parseCookie(cookieString, pageUrl, this.getBrowserVersion());
            for (Cookie cookie : cookies) {
                cookieManager.addCookie(cookie);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Added cookie: '" + cookieString + "'"));
            }
        }
        catch (MalformedCookieException e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)("Adding cookie '" + cookieString + "' failed."), (Throwable)e);
            }
            this.getIncorrectnessListener().notify("Adding cookie '" + cookieString + "' failed; reason: '" + e.getMessage() + "'.", origin);
        }
    }

    public boolean isJavaScriptEnabled() {
        return this.javaScriptEngineEnabled_ && this.getOptions().isJavaScriptEnabled();
    }

    public boolean isJavaScriptEngineEnabled() {
        return this.javaScriptEngineEnabled_;
    }

    public HtmlPage loadHtmlCodeIntoCurrentWindow(String htmlCode) throws IOException {
        HTMLParser htmlParser = this.getPageCreator().getHtmlParser();
        WebWindow webWindow = this.getCurrentWindow();
        StringWebResponse webResponse = new StringWebResponse(htmlCode, new URL("https://www.htmlunit.org/dummy.html"));
        HtmlPage page = new HtmlPage(webResponse, webWindow);
        webWindow.setEnclosedPage(page);
        htmlParser.parse(this, webResponse, page, false, false);
        return page;
    }

    public XHtmlPage loadXHtmlCodeIntoCurrentWindow(String xhtmlCode) throws IOException {
        HTMLParser htmlParser = this.getPageCreator().getHtmlParser();
        WebWindow webWindow = this.getCurrentWindow();
        StringWebResponse webResponse = new StringWebResponse(xhtmlCode, new URL("https://www.htmlunit.org/dummy.html"));
        XHtmlPage page = new XHtmlPage(webResponse, webWindow);
        webWindow.setEnclosedPage(page);
        htmlParser.parse(this, webResponse, page, true, false);
        return page;
    }

    public WebSocketAdapter buildWebSocketAdapter(WebSocketListener webSocketListener) {
        return this.webSocketAdapterFactory_.buildWebSocketAdapter(this, webSocketListener);
    }

    public void setWebSocketAdapter(WebSocketAdapterFactory factory) {
        this.webSocketAdapterFactory_ = factory;
    }

    public PooledCSS3Parser getCSS3Parser() {
        return this.css3ParserPool_.get();
    }

    public Set<BroadcastChannel> getBroadcastChannels() {
        return this.broadcastChannel_;
    }

    public static class PooledCSS3Parser
    extends CSS3Parser
    implements AutoCloseable {
        private CSS3ParserPool pool_;

        protected PooledCSS3Parser(CSS3ParserPool pool) {
            this.pool_ = pool;
        }

        protected PooledCSS3Parser markInUse(CSS3ParserPool pool) {
            if (this.pool_ != null) {
                throw new IllegalStateException("This PooledParser was not returned to the pool properly");
            }
            this.pool_ = pool;
            return this;
        }

        @Override
        public void close() {
            if (this.pool_ == null) {
                throw new IllegalStateException("This PooledParser was returned already");
            }
            CSS3ParserPool oldPool = this.pool_;
            this.pool_ = null;
            oldPool.recycle(this);
        }
    }

    static class CSS3ParserPool {
        private final ConcurrentLinkedDeque<PooledCSS3Parser> parsers_ = new ConcurrentLinkedDeque();

        CSS3ParserPool() {
        }

        public PooledCSS3Parser get() {
            PooledCSS3Parser parser = this.parsers_.pollLast();
            return parser != null ? parser.markInUse(this) : new PooledCSS3Parser(this);
        }

        protected void recycle(PooledCSS3Parser parser) {
            this.parsers_.addLast(parser);
        }
    }

    private static class LoadJob {
        private final WebWindow requestingWindow_;
        private final String target_;
        private final WebResponse response_;
        private final WeakReference<Page> originalPage_;
        private final WebRequest request_;
        private final String forceAttachmentWithFilename_;

        LoadJob(WebRequest request, WebResponse response, WebWindow requestingWindow, String target, String forceAttachmentWithFilename) {
            this.request_ = request;
            this.requestingWindow_ = requestingWindow;
            this.target_ = target;
            this.response_ = response;
            this.originalPage_ = new WeakReference<Page>(requestingWindow.getEnclosedPage());
            this.forceAttachmentWithFilename_ = forceAttachmentWithFilename;
        }

        public boolean isOutdated() {
            if (this.target_ != null && !this.target_.isEmpty()) {
                return false;
            }
            if (this.requestingWindow_.isClosed()) {
                return true;
            }
            return this.requestingWindow_.getEnclosedPage() != this.originalPage_.get();
        }
    }

    private static final class CurrentWindowTracker
    implements WebWindowListener,
    Serializable {
        private final WebClient webClient_;
        private final boolean ensureOneTopLevelWindow_;

        CurrentWindowTracker(WebClient webClient, boolean ensureOneTopLevelWindow) {
            this.webClient_ = webClient;
            this.ensureOneTopLevelWindow_ = ensureOneTopLevelWindow;
        }

        @Override
        public void webWindowClosed(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            if (window instanceof TopLevelWindow) {
                this.webClient_.topLevelWindows_.remove(window);
                if (window == this.webClient_.getCurrentWindow() && !this.webClient_.topLevelWindows_.isEmpty()) {
                    this.webClient_.setCurrentWindow((WebWindow)this.webClient_.topLevelWindows_.get(this.webClient_.topLevelWindows_.size() - 1));
                }
            } else if (window == this.webClient_.getCurrentWindow()) {
                if (this.webClient_.topLevelWindows_.isEmpty()) {
                    this.webClient_.setCurrentWindow(null);
                } else {
                    this.webClient_.setCurrentWindow((WebWindow)this.webClient_.topLevelWindows_.get(this.webClient_.topLevelWindows_.size() - 1));
                }
            }
        }

        public void afterWebWindowClosedListenersProcessed(WebWindowEvent event) {
            if (!this.ensureOneTopLevelWindow_) {
                return;
            }
            if (this.webClient_.topLevelWindows_.isEmpty()) {
                TopLevelWindow newWindow = new TopLevelWindow("", this.webClient_);
                this.webClient_.setCurrentWindow(newWindow);
            }
        }

        @Override
        public void webWindowContentChanged(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            boolean use = false;
            if (window instanceof DialogWindow) {
                use = true;
            } else if (window instanceof TopLevelWindow) {
                use = event.getOldPage() == null;
            } else if (window instanceof FrameWindow) {
                FrameWindow fw = (FrameWindow)window;
                String enclosingPageState = fw.getEnclosingPage().getDocumentElement().getReadyState();
                URL frameUrl = fw.getEnclosedPage().getUrl();
                if (!"complete".equals(enclosingPageState) || frameUrl == UrlUtils.URL_ABOUT_BLANK) {
                    return;
                }
                BaseFrameElement frameElement = fw.getFrameElement();
                if (this.webClient_.isJavaScriptEnabled() && frameElement.isDisplayed()) {
                    ComputedCssStyleDeclaration style = fw.getComputedStyle(frameElement, null);
                    boolean bl = use = style.getCalculatedWidth(false, false) != 0 && style.getCalculatedHeight(false, false) != 0;
                }
            }
            if (use) {
                this.webClient_.setCurrentWindow(window);
            }
        }

        @Override
        public void webWindowOpened(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            if (window instanceof TopLevelWindow) {
                TopLevelWindow tlw = (TopLevelWindow)window;
                this.webClient_.topLevelWindows_.add(tlw);
            }
        }
    }

    private static final class ThreadNamingFactory
    implements ThreadFactory {
        private static int ID_ = 1;
        private final ThreadFactory baseFactory_;

        ThreadNamingFactory(ThreadFactory aBaseFactory) {
            this.baseFactory_ = aBaseFactory;
        }

        @Override
        public Thread newThread(Runnable aRunnable) {
            Thread thread = this.baseFactory_.newThread(aRunnable);
            thread.setName("WebClient Thread " + ID_++);
            return thread;
        }
    }
}

