/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Interpreter;
import org.htmlunit.corejs.javascript.JSCode;
import org.htmlunit.corejs.javascript.JSFunction;
import org.htmlunit.corejs.javascript.ScriptOrFn;
import org.htmlunit.corejs.javascript.Scriptable;

final class InterpreterData<T extends ScriptOrFn<T>>
extends JSCode<T>
implements Serializable {
    private static final long serialVersionUID = 5067677351589230234L;
    static final int INITIAL_MAX_ICODE_LENGTH = 1024;
    static final int INITIAL_STRINGTABLE_SIZE = 64;
    static final int INITIAL_NUMBERTABLE_SIZE = 64;
    static final int INITIAL_BIGINTTABLE_SIZE = 64;
    final String[] itsStringTable;
    final double[] itsDoubleTable;
    final BigInteger[] itsBigIntTable;
    final InterpreterData<JSFunction>[] itsNestedFunctions;
    final Object[] itsRegExpLiterals;
    final Object[] itsTemplateLiterals;
    final byte[] itsICode;
    final int[] itsExceptionTable;
    final int itsMaxVars;
    final int itsMaxLocals;
    final int itsMaxStack;
    final int itsMaxFrameArray;
    final int itsMaxCalleeArgs;
    final Object[] literalIds;
    final Map<Integer, Integer> longJumps;
    final int firstLinePC;
    private int icodeHashCode = 0;

    InterpreterData(String[] itsStringTable, double[] itsDoubleTable, BigInteger[] itsBigIntTable, InterpreterData<JSFunction>[] itsNestedFunctions, Object[] itsRegExpLiterals, Object[] itsTemplateLiterals, byte[] itsICode, int[] itsExceptionTable, int itsMaxVars, int itsMaxLocals, int itsMaxStack, int itsMaxFrameArray, int itsMaxCalleeArgs, Object[] literalIds, Map<Integer, Integer> longJumps, int firstLinePC) {
        this.itsStringTable = itsStringTable;
        this.itsDoubleTable = itsDoubleTable;
        this.itsBigIntTable = itsBigIntTable;
        this.itsNestedFunctions = itsNestedFunctions;
        this.itsRegExpLiterals = itsRegExpLiterals;
        this.itsTemplateLiterals = itsTemplateLiterals;
        this.itsICode = itsICode;
        this.itsExceptionTable = itsExceptionTable;
        this.itsMaxVars = itsMaxVars;
        this.itsMaxLocals = itsMaxLocals;
        this.itsMaxStack = itsMaxStack;
        this.itsMaxFrameArray = itsMaxFrameArray;
        this.itsMaxCalleeArgs = itsMaxCalleeArgs;
        this.literalIds = literalIds;
        this.longJumps = longJumps;
        this.firstLinePC = firstLinePC;
    }

    public int icodeHashCode() {
        int h = this.icodeHashCode;
        if (h == 0) {
            this.icodeHashCode = h = Arrays.hashCode(this.itsICode);
        }
        return h;
    }

    public String toString() {
        return "An idata thing.";
    }

    @Override
    public Object execute(Context cx, T executableObject, Object newTarget, Scriptable scope, Object thisObj, Object[] args) {
        return Interpreter.interpret(executableObject, this, cx, scope, (Scriptable)thisObj, args);
    }

    @Override
    public Object resume(Context cx, T executableObject, Object state, Scriptable scope, int operation, Object value) {
        return Interpreter.resumeGenerator(cx, scope, operation, state, value);
    }

    public static class Builder<T extends ScriptOrFn<T>>
    extends JSCode.Builder<T> {
        String[] itsStringTable;
        double[] itsDoubleTable;
        BigInteger[] itsBigIntTable;
        InterpreterData<JSFunction>[] itsNestedFunctions;
        Object[] itsRegExpLiterals;
        Object[] itsTemplateLiterals;
        byte[] itsICode = new byte[1024];
        int[] itsExceptionTable;
        int itsMaxVars;
        int itsMaxLocals;
        int itsMaxStack;
        int itsMaxFrameArray;
        int itsMaxCalleeArgs;
        Object[] literalIds;
        Map<Integer, Integer> longJumps;
        InterpreterData<T> built = null;
        int firstLinePC = -1;

        public Builder() {
            this.itsStringTable = new String[64];
            this.itsBigIntTable = new BigInteger[64];
        }

        @Override
        public JSCode<T> build() {
            if (this.built == null) {
                Map<Integer, Integer> jumpMap = this.longJumps != null ? Collections.unmodifiableMap(new HashMap<Integer, Integer>(this.longJumps)) : null;
                this.built = new InterpreterData(this.itsStringTable, this.itsDoubleTable, this.itsBigIntTable, this.itsNestedFunctions, this.itsRegExpLiterals, this.itsTemplateLiterals, this.itsICode, this.itsExceptionTable, this.itsMaxVars, this.itsMaxLocals, this.itsMaxStack, this.itsMaxFrameArray, this.itsMaxCalleeArgs, this.literalIds, jumpMap, this.firstLinePC);
            }
            return this.built;
        }
    }
}

