/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.WeakHashMap;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.NativeMap;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

public class NativeWeakMap
extends ScriptableObject {
    private static final long serialVersionUID = 8670434366883930453L;
    private static final String CLASS_NAME = "WeakMap";
    private boolean instanceOfWeakMap = false;
    private transient WeakHashMap<Object, Object> map = new WeakHashMap();
    private static final Object NULL_VALUE = new Object();

    static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 0, 2, NativeWeakMap::jsConstructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.definePrototypeMethod(scope, "set", 2, NativeWeakMap::js_set);
        constructor.definePrototypeMethod(scope, "delete", 1, NativeWeakMap::js_delete);
        constructor.definePrototypeMethod(scope, "get", 1, NativeWeakMap::js_get);
        constructor.definePrototypeMethod(scope, "has", 1, NativeWeakMap::js_has);
        constructor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
        return constructor;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args) {
        NativeWeakMap nm = new NativeWeakMap();
        nm.instanceOfWeakMap = true;
        if (args.length > 0) {
            NativeMap.loadFromIterable(cx, scope, nm, NativeMap.key(args));
        }
        return nm;
    }

    private static Object js_delete(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeWeakMap.realThis(thisObj, "delete").js_delete(NativeMap.key(args));
    }

    private Object js_delete(Object key) {
        if (!NativeWeakMap.isValidKey(key)) {
            return Boolean.FALSE;
        }
        return this.map.remove(key) != null;
    }

    private static Object js_get(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeWeakMap.realThis(thisObj, "get").js_get(NativeMap.key(args));
    }

    private Object js_get(Object key) {
        if (!NativeWeakMap.isValidKey(key)) {
            return Undefined.instance;
        }
        Object result = this.map.get(key);
        if (result == null) {
            return Undefined.instance;
        }
        if (result == NULL_VALUE) {
            return null;
        }
        return result;
    }

    private static Object js_has(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeWeakMap.realThis(thisObj, "has").js_has(NativeMap.key(args));
    }

    private Object js_has(Object key) {
        if (!NativeWeakMap.isValidKey(key)) {
            return Boolean.FALSE;
        }
        return this.map.containsKey(key);
    }

    private static Object js_set(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeWeakMap.realThis(thisObj, "set").js_set(NativeMap.key(args), args.length > 1 ? args[1] : Undefined.instance);
    }

    private Object js_set(Object key, Object v) {
        if (!NativeWeakMap.isValidKey(key)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(key));
        }
        Object value = v == null ? NULL_VALUE : v;
        this.map.put(key, value);
        return this;
    }

    private static boolean isValidKey(Object key) {
        return ScriptRuntime.isUnregisteredSymbol(key) || ScriptRuntime.isObject(key);
    }

    private static NativeWeakMap realThis(Scriptable thisObj, String name) {
        NativeWeakMap nm = LambdaConstructor.convertThisObject(thisObj, NativeWeakMap.class);
        if (!nm.instanceOfWeakMap) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", name);
        }
        return nm;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.map = new WeakHashMap();
    }
}

