/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.dtoa;

import org.htmlunit.corejs.javascript.dtoa.MathUtils;

public class Decimal {
    private static final int MASK_28 = 0xFFFFFFF;
    public static final int MAX_CHARS = 32;
    private final long digits;
    private final int exponent;
    private final boolean negative;
    private int length;
    private final char[] buf = new char[32];

    Decimal(long d, int e, boolean n) {
        this.digits = d;
        this.exponent = e;
        this.negative = n;
    }

    public String toString() {
        this.length = 0;
        int len = MathUtils.flog10pow2(64 - Long.numberOfLeadingZeros(this.digits));
        if (this.digits >= MathUtils.pow10(len)) {
            ++len;
        }
        long f = this.digits * MathUtils.pow10(17 - len);
        int e = this.exponent + len;
        long hm = Decimal.multiplyHigh(f, 193428131138340668L) >>> 20;
        int l = (int)(f - 100000000L * hm);
        int h = (int)(hm * 1441151881L >>> 57);
        int m = (int)(hm - 100000000L * (long)h);
        if (this.negative) {
            this.append('-');
        }
        if (0 < e && e <= 8) {
            return this.toFixed(h, m, l, e);
        }
        if (8 < e && e <= 16) {
            return this.toFixedBigger(h, m, l, e);
        }
        if (16 < e && e <= 21) {
            return this.toFixedBiggest(h, m, l, e);
        }
        if (-6 < e && e <= 0) {
            return this.toFixedSmall(h, m, l, e);
        }
        return this.toExponential(h, m, l, e);
    }

    private String toFixed(int h, int m, int l, int e) {
        int t;
        int i;
        assert (e <= 8);
        this.appendDigit(h);
        int y = this.y(m);
        for (i = 1; i < e; ++i) {
            t = 10 * y;
            this.appendDigit(t >>> 28);
            y = t & 0xFFFFFFF;
        }
        this.append('.');
        while (i <= 8) {
            t = 10 * y;
            this.appendDigit(t >>> 28);
            y = t & 0xFFFFFFF;
            ++i;
        }
        this.lowDigits(l);
        return this.makeString();
    }

    private String toFixedBigger(int h, int m, int l, int e) {
        int t;
        int i;
        assert (e > 8 && e <= 16);
        this.appendDigit(h);
        this.append8Digits(m);
        int y = this.y(l);
        for (i = 9; i < e; ++i) {
            t = 10 * y;
            this.appendDigit(t >>> 28);
            y = t & 0xFFFFFFF;
        }
        this.append('.');
        while (i <= 16) {
            t = 10 * y;
            this.appendDigit(t >>> 28);
            y = t & 0xFFFFFFF;
            ++i;
        }
        this.trimZeroes();
        return this.makeString();
    }

    private String toFixedBiggest(int h, int m, int l, int e) {
        assert (e > 16);
        this.appendDigit(h);
        this.append8Digits(m);
        this.append8Digits(l);
        for (int i = 17; i < e; ++i) {
            this.append('0');
        }
        return this.makeString();
    }

    private String toFixedSmall(int h, int m, int l, int e) {
        assert (e <= 0);
        this.appendDigit(0);
        this.append('.');
        while (e < 0) {
            this.appendDigit(0);
            ++e;
        }
        this.appendDigit(h);
        this.append8Digits(m);
        this.lowDigits(l);
        return this.makeString();
    }

    private String toExponential(int h, int m, int l, int e) {
        this.appendDigit(h);
        this.append('.');
        this.append8Digits(m);
        this.lowDigits(l);
        this.exponent(e - 1);
        return this.makeString();
    }

    private int y(int a) {
        return (int)(Decimal.multiplyHigh((long)(a + 1) << 28, 193428131138340668L) >>> 20) - 1;
    }

    private void lowDigits(int l) {
        if (l != 0) {
            this.append8Digits(l);
        }
        this.trimZeroes();
    }

    private void append8Digits(int m) {
        int y = this.y(m);
        for (int i = 0; i < 8; ++i) {
            int t = 10 * y;
            this.appendDigit(t >>> 28);
            y = t & 0xFFFFFFF;
        }
    }

    private void exponent(int e) {
        int d;
        assert (e >= -999 && e <= 999);
        this.append('e');
        if (e < 0) {
            this.append('-');
            e = -e;
        } else {
            this.append('+');
        }
        if (e < 10) {
            this.appendDigit(e);
            return;
        }
        if (e >= 100) {
            d = e * 1311 >>> 17;
            this.appendDigit(d);
            e -= 100 * d;
        }
        d = e * 103 >>> 10;
        this.appendDigit(d);
        this.appendDigit(e - 10 * d);
    }

    private void trimZeroes() {
        while (this.length > 0 && this.buf[this.length - 1] == '0') {
            --this.length;
        }
        if (this.length > 0 && this.buf[this.length - 1] == '.') {
            --this.length;
        }
    }

    private void append(char ch) {
        this.buf[this.length++] = ch;
    }

    private void appendDigit(int d) {
        this.buf[this.length++] = (char)(48 + d);
    }

    private String makeString() {
        return new String(this.buf, 0, this.length);
    }

    public static long multiplyHigh(long x, long y) {
        long x1 = x >> 32;
        long x2 = x & 0xFFFFFFFFL;
        long y1 = y >> 32;
        long y2 = y & 0xFFFFFFFFL;
        long z2 = x2 * y2;
        long t = x1 * y2 + (z2 >>> 32);
        long z1 = t & 0xFFFFFFFFL;
        long z0 = t >> 32;
        return x1 * y1 + z0 + ((z1 += x2 * y1) >> 32);
    }
}

