/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.lc.member;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeInfoFactory;

public final class NativeJavaField {
    private final Field field;
    private final boolean isFinal;
    private final TypeInfo type;

    public NativeJavaField(Field field, TypeInfoFactory typeFactory) {
        this.field = field;
        this.isFinal = Modifier.isFinal(field.getModifiers());
        this.type = typeFactory.create(field.getGenericType());
    }

    public Field raw() {
        return this.field;
    }

    public TypeInfo type() {
        return this.type;
    }

    public Object get(Object javaObject) throws IllegalAccessException {
        return this.field.get(javaObject);
    }

    public void set(Object javaObject, Object value) throws IllegalAccessException {
        if (this.isFinal) {
            return;
        }
        this.field.set(javaObject, value);
    }
}

