/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.util.StringUtils;

public class HtmlMap
extends HtmlElement {
    public static final String TAG_NAME = "map";

    HtmlMap(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean isDisplayed() {
        HtmlImage image = this.findReferencingImage();
        if (null != image) {
            return image.isDisplayed();
        }
        return false;
    }

    private HtmlImage findReferencingImage() {
        HtmlPage page = this.getHtmlPageOrNull();
        String name = this.getNameAttribute();
        if (null != page && StringUtils.isNotBlank(name)) {
            name = "#" + name.trim();
            for (HtmlElement elem : page.getDocumentElement().getStaticElementsByTagName("img")) {
                HtmlImage image = (HtmlImage)elem;
                if (!name.equals(image.getUseMapAttribute())) continue;
                return image;
            }
        }
        return null;
    }
}

