/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.ValidatableElement;
import org.htmlunit.javascript.host.html.HTMLObjectElement;
import org.htmlunit.util.StringUtils;
import org.htmlunit.xml.XmlPage;

public class HtmlObject
extends HtmlElement
implements ValidatableElement {
    private static final Log LOG = LogFactory.getLog(HtmlObject.class);
    public static final String TAG_NAME = "object";
    private String customValidity_;

    HtmlObject(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getDeclareAttribute() {
        return this.getAttributeDirect("declare");
    }

    public final String getClassIdAttribute() {
        return this.getAttributeDirect("classid");
    }

    public final String getCodebaseAttribute() {
        return this.getAttributeDirect("codebase");
    }

    public final String getDataAttribute() {
        return this.getAttributeDirect("data");
    }

    public final String getTypeAttribute() {
        return this.getAttributeDirect("type");
    }

    public final String getCodeTypeAttribute() {
        return this.getAttributeDirect("codetype");
    }

    public final String getArchiveAttribute() {
        return this.getAttributeDirect("archive");
    }

    public final String getStandbyAttribute() {
        return this.getAttributeDirect("standby");
    }

    public final String getHeightAttribute() {
        return this.getAttributeDirect("height");
    }

    public final String getWidthAttribute() {
        return this.getAttributeDirect("width");
    }

    public final String getUseMapAttribute() {
        return this.getAttributeDirect("usemap");
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeDirect("tabindex");
    }

    public final String getAlignAttribute() {
        return this.getAttributeDirect("align");
    }

    public final String getBorderAttribute() {
        return this.getAttributeDirect("border");
    }

    public final String getHspaceAttribute() {
        return this.getAttributeDirect("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttributeDirect("vspace");
    }

    @Override
    public void onAllChildrenAddedToPage(boolean postponed) {
        String clsId;
        if (this.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Object node added: " + this.asXml()));
        }
        if (ATTRIBUTE_NOT_DEFINED != (clsId = this.getClassIdAttribute()) && this.getPage().getWebClient().isJavaScriptEngineEnabled()) {
            ((HTMLObjectElement)this.getScriptableObject()).setClassid(clsId);
        }
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean willValidate() {
        return false;
    }

    @Override
    public void setCustomValidity(String message) {
        this.customValidity_ = message;
    }

    @Override
    public boolean isCustomErrorValidityState() {
        return !StringUtils.isEmptyOrNull(this.customValidity_);
    }

    @Override
    public boolean isValidValidityState() {
        return !this.isCustomErrorValidityState();
    }
}

