/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html.parser.neko;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.ObjectInstantiationException;
import org.htmlunit.WebClient;
import org.htmlunit.WebResponse;
import org.htmlunit.cyberneko.HTMLConfiguration;
import org.htmlunit.cyberneko.HTMLElements;
import org.htmlunit.cyberneko.HTMLTagBalancingListener;
import org.htmlunit.cyberneko.xerces.parsers.AbstractSAXParser;
import org.htmlunit.cyberneko.xerces.xni.Augmentations;
import org.htmlunit.cyberneko.xerces.xni.QName;
import org.htmlunit.cyberneko.xerces.xni.XMLAttributes;
import org.htmlunit.cyberneko.xerces.xni.XMLString;
import org.htmlunit.cyberneko.xerces.xni.XNIException;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLInputSource;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLParserConfiguration;
import org.htmlunit.html.DomCDataSection;
import org.htmlunit.html.DomComment;
import org.htmlunit.html.DomDocumentType;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.ElementFactory;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlHiddenInput;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlSvg;
import org.htmlunit.html.HtmlTable;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.html.HtmlTemplate;
import org.htmlunit.html.ScriptElement;
import org.htmlunit.html.SubmittableElement;
import org.htmlunit.html.XHtmlPage;
import org.htmlunit.html.parser.HTMLParser;
import org.htmlunit.html.parser.HTMLParserDOMBuilder;
import org.htmlunit.html.parser.HTMLParserListener;
import org.htmlunit.html.parser.neko.HtmlUnitNekoHTMLErrorHandler;
import org.htmlunit.html.parser.neko.HtmlUnitNekoHtmlParser;
import org.htmlunit.javascript.host.html.HTMLBodyElement;
import org.htmlunit.util.StringUtils;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

final class HtmlUnitNekoDOMBuilder
extends AbstractSAXParser
implements ContentHandler,
LexicalHandler,
HTMLTagBalancingListener,
HTMLParserDOMBuilder {
    private static final HTMLElements HTMLELEMENTS;
    private static final HTMLElements HTMLELEMENTS_WITH_CMD;
    private final HTMLParser htmlParser_;
    private final HtmlPage page_;
    private Locator locator_;
    private final Deque<DomNode> stack_ = new ArrayDeque<DomNode>();
    private boolean snippetStartNodeOverwritten_;
    private final int initialSize_;
    private DomNode currentNode_;
    private final boolean createdByJavascript_;
    private final XMLString characters_ = new XMLString();
    private HeadParsed headParsed_ = HeadParsed.NO;
    private HtmlElement body_;
    private boolean lastTagWasSynthesized_;
    private HtmlForm consumingForm_;
    private boolean formEndingIsAdjusting_;
    private boolean insideSvg_;
    private boolean insideTemplate_;
    private static final String FEATURE_AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    private static final String FEATURE_PARSE_NOSCRIPT = "http://cyberneko.org/html/features/parse-noscript-content";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushInputString(String html) {
        this.page_.registerParsingStart();
        this.page_.registerInlineSnippetParsingStart();
        try {
            WebResponse webResponse = this.page_.getWebResponse();
            Charset charset = webResponse.getContentCharset();
            String url = webResponse.getWebRequest().getUrl().toString();
            XMLInputSource in = new XMLInputSource(null, url, null, new StringReader(html), charset.name());
            ((HTMLConfiguration)this.parserConfiguration_).evaluateInputSource(in);
        }
        finally {
            this.page_.registerParsingEnd();
            this.page_.registerInlineSnippetParsingEnd();
        }
    }

    HtmlUnitNekoDOMBuilder(HTMLParser htmlParser, DomNode node, URL url, String htmlContent, boolean createdByJavascript) {
        super(HtmlUnitNekoDOMBuilder.createConfiguration(node.getPage().getWebClient().getBrowserVersion()));
        boolean reportErrors;
        this.htmlParser_ = htmlParser;
        this.page_ = (HtmlPage)node.getPage();
        this.currentNode_ = node;
        for (Node ancestor : this.currentNode_.getAncestors()) {
            this.stack_.push((DomNode)ancestor);
        }
        this.createdByJavascript_ = createdByJavascript;
        WebClient webClient = this.page_.getWebClient();
        HTMLParserListener listener = webClient.getHTMLParserListener();
        boolean bl = reportErrors = listener != null;
        if (reportErrors) {
            this.parserConfiguration_.setErrorHandler(new HtmlUnitNekoHTMLErrorHandler(listener, url, htmlContent));
        }
        try {
            this.setFeature(FEATURE_AUGMENTATIONS, true);
            this.setFeature("http://cyberneko.org/html/features/report-errors", reportErrors);
            this.setFeature(FEATURE_PARSE_NOSCRIPT, !webClient.isJavaScriptEnabled());
            this.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-iframe", false);
            this.setContentHandler(this);
            this.setLexicalHandler(this);
        }
        catch (SAXException e) {
            throw new ObjectInstantiationException("unable to create HTML parser", e);
        }
        this.initialSize_ = this.stack_.size();
    }

    private static XMLParserConfiguration createConfiguration(BrowserVersion browserVersion) {
        if (browserVersion.hasFeature(BrowserVersionFeatures.HTML_COMMAND_TAG)) {
            return new HTMLConfiguration(new HTMLElements.HTMLElementsWithCache(HTMLELEMENTS_WITH_CMD));
        }
        return new HTMLConfiguration(new HTMLElements.HTMLElementsWithCache(HTMLELEMENTS));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.lastTagWasSynthesized_ = augs.isSynthesized();
        super.startElement(element, attributes, augs);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        ElementFactory factory;
        HtmlBody body;
        if (this.snippetStartNodeOverwritten_) {
            this.snippetStartNodeOverwritten_ = false;
            return;
        }
        this.handleCharacters();
        String tagLower = StringUtils.toRootLowerCase(localName);
        if (this.page_.isParsingHtmlSnippet() && ("html".equals(tagLower) || "body".equals(tagLower))) {
            this.stack_.push(this.currentNode_);
            return;
        }
        if ("head".equals(tagLower)) {
            if (this.headParsed_ == HeadParsed.YES || this.page_.isParsingHtmlSnippet()) {
                this.stack_.push(this.currentNode_);
                return;
            }
            this.headParsed_ = this.lastTagWasSynthesized_ ? HeadParsed.SYNTHESIZED : HeadParsed.YES;
        }
        HtmlBody oldBody = null;
        boolean isBodyTag = "body".equals(tagLower);
        if (isBodyTag && (body = this.page_.getBody()) != null) {
            oldBody = body;
        }
        if (namespaceURI != null) {
            namespaceURI = namespaceURI.trim();
        }
        if (!(this.page_ instanceof XHtmlPage) && "http://www.w3.org/1999/xhtml".equals(namespaceURI)) {
            namespaceURI = null;
        }
        if ((factory = this.htmlParser_.getElementFactory(this.page_, namespaceURI, qName, this.insideSvg_, false)) == HtmlUnitNekoHtmlParser.SVG_FACTORY) {
            namespaceURI = "http://www.w3.org/2000/svg";
        }
        DomElement newElement = factory.createElementNS(this.page_, namespaceURI, qName, atts);
        newElement.setStartLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        this.addNodeToRightParent(this.currentNode_, newElement);
        if (newElement instanceof HtmlSvg) {
            this.insideSvg_ = true;
        } else if (newElement instanceof HtmlTemplate) {
            this.insideTemplate_ = true;
        } else if (newElement instanceof HtmlForm) {
            this.consumingForm_ = (HtmlForm)newElement;
            this.formEndingIsAdjusting_ = false;
        } else if (this.consumingForm_ != null && newElement instanceof SubmittableElement && ((HtmlElement)newElement).getEnclosingForm() != this.consumingForm_) {
            ((HtmlElement)newElement).setOwningForm(this.consumingForm_);
        }
        if (oldBody != null) {
            oldBody.quietlyRemoveAndMoveChildrenTo(newElement);
        }
        if (!this.insideSvg_ && isBodyTag) {
            this.body_ = (HtmlElement)newElement;
        } else if (this.createdByJavascript_ && newElement instanceof ScriptElement && (!this.insideTemplate_ || !this.page_.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SCRIPT_IN_TEMPLATE_EXECUTED_ON_ATTACH))) {
            ScriptElement script = (ScriptElement)((Object)newElement);
            script.markAsCreatedByDomParser();
        }
        this.currentNode_ = newElement;
        this.stack_.push(this.currentNode_);
    }

    private void addNodeToRightParent(DomNode currentNode, DomElement newElement) {
        String currentNodeName = currentNode.getNodeName();
        String newNodeName = newElement.getNodeName();
        if (HtmlUnitNekoDOMBuilder.isTableChild(newNodeName)) {
            DomNode parent = "table".equals(currentNodeName) ? currentNode : this.findElementOnStack("table");
            HtmlUnitNekoDOMBuilder.appendChild(parent, newElement);
            return;
        }
        if ("tr".equals(newNodeName)) {
            DomNode parent = HtmlUnitNekoDOMBuilder.isTableChild(currentNodeName) ? currentNode : this.findElementOnStack("tbody", "thead", "tfoot");
            HtmlUnitNekoDOMBuilder.appendChild(parent, newElement);
            return;
        }
        if (HtmlUnitNekoDOMBuilder.isTableCell(newNodeName)) {
            DomNode parent = "tr".equals(currentNodeName) ? currentNode : this.findElementOnStack("tr");
            HtmlUnitNekoDOMBuilder.appendChild(parent, newElement);
            return;
        }
        if ("table".equals(currentNodeName) || HtmlUnitNekoDOMBuilder.isTableChild(currentNodeName) || "tr".equals(currentNodeName)) {
            if ("template".equals(newNodeName)) {
                currentNode.appendChild(newElement);
            } else if (!"colgroup".equals(currentNodeName) && ("script".equals(newNodeName) || "form".equals(newNodeName) || "style".equals(newNodeName))) {
                currentNode.appendChild(newElement);
            } else if ("col".equals(newNodeName) && "colgroup".equals(currentNodeName)) {
                currentNode.appendChild(newElement);
            } else if ("caption".equals(currentNodeName)) {
                currentNode.appendChild(newElement);
            } else if (newElement instanceof HtmlHiddenInput) {
                currentNode.appendChild(newElement);
            } else {
                DomNode parent = this.findElementOnStack("table");
                parent.insertBefore(newElement);
            }
            return;
        }
        if (this.formEndingIsAdjusting_ && "form".equals(currentNodeName)) {
            HtmlUnitNekoDOMBuilder.appendChild(currentNode.getParentNode(), newElement);
            return;
        }
        HtmlUnitNekoDOMBuilder.appendChild(currentNode, newElement);
    }

    private DomNode findElementOnStack(String searchedElementName) {
        for (DomNode node : this.stack_) {
            if (!searchedElementName.equals(node.getNodeName())) continue;
            return node;
        }
        return this.stack_.peek();
    }

    private DomNode findElementOnStack(String ... searchedElementNames) {
        for (DomNode node : this.stack_) {
            for (String searchedElementName : searchedElementNames) {
                if (!searchedElementName.equals(node.getNodeName())) continue;
                return node;
            }
        }
        return this.stack_.peek();
    }

    private static boolean isTableChild(String nodeName) {
        if (nodeName == null || nodeName.length() < 5) {
            return false;
        }
        return "thead".equals(nodeName) || "tbody".equals(nodeName) || "tfoot".equals(nodeName) || "caption".equals(nodeName) || "colgroup".equals(nodeName);
    }

    private static boolean isTableCell(String nodeName) {
        if (nodeName == null || nodeName.length() != 2) {
            return false;
        }
        return "td".equals(nodeName) || "th".equals(nodeName);
    }

    @Override
    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.lastTagWasSynthesized_ = augs.isSynthesized();
        super.endElement(element, augs);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String tagLower = StringUtils.toRootLowerCase(localName);
        this.handleCharacters();
        if (this.page_.isParsingHtmlSnippet()) {
            if ("html".equals(tagLower) || "body".equals(tagLower)) {
                return;
            }
            if (this.stack_.size() == this.initialSize_) {
                this.snippetStartNodeOverwritten_ = !StringUtils.equalsChar('p', tagLower);
                return;
            }
        }
        if ("svg".equals(tagLower)) {
            this.insideSvg_ = false;
        } else if ("template".equals(tagLower)) {
            this.insideTemplate_ = false;
        }
        if (this.stack_.isEmpty()) {
            return;
        }
        DomNode previousNode = this.stack_.pop();
        previousNode.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        if ("form".equals(tagLower) && !this.lastTagWasSynthesized_) {
            this.consumingForm_ = null;
        }
        if (!this.stack_.isEmpty()) {
            this.currentNode_ = this.stack_.peek();
        }
        boolean postponed = this.page_.isParsingInlineHtmlSnippet();
        previousNode.onAllChildrenAddedToPage(postponed);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters_.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters_.append(ch, start, length);
    }

    private void handleCharacters() {
        if (this.characters_.length() == 0) {
            return;
        }
        String textValue = this.characters_.toString();
        this.characters_.clear();
        if (StringUtils.isBlank(textValue)) {
            HtmlUnitNekoDOMBuilder.appendChild(this.currentNode_, new DomText(this.page_, textValue));
            return;
        }
        if (this.currentNode_ instanceof HtmlTableRow) {
            HtmlTableRow row = (HtmlTableRow)this.currentNode_;
            HtmlTable enclosingTable = row.getEnclosingTable();
            if (enclosingTable != null) {
                if (enclosingTable.getPreviousSibling() instanceof DomText) {
                    DomText domText = (DomText)enclosingTable.getPreviousSibling();
                    domText.setTextContent(domText.getWholeText() + textValue);
                } else {
                    enclosingTable.insertBefore(new DomText(this.page_, textValue));
                }
            }
        } else if (this.currentNode_ instanceof HtmlTable) {
            HtmlTable enclosingTable = (HtmlTable)this.currentNode_;
            if (enclosingTable.getPreviousSibling() instanceof DomText) {
                DomText domText = (DomText)enclosingTable.getPreviousSibling();
                domText.setTextContent(domText.getWholeText() + textValue);
            } else {
                enclosingTable.insertBefore(new DomText(this.page_, textValue));
            }
        } else if (this.currentNode_ instanceof HtmlImage) {
            this.currentNode_.getParentNode().appendChild(new DomText(this.page_, textValue));
        } else {
            HtmlUnitNekoDOMBuilder.appendChild(this.currentNode_, new DomText(this.page_, textValue));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.handleCharacters();
        if (this.locator_ != null) {
            this.page_.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        this.handleCharacters();
        String data = new String(ch, start, length);
        DomComment comment = new DomComment(this.page_, data);
        HtmlUnitNekoDOMBuilder.appendChild(this.currentNode_, comment);
    }

    @Override
    public void endCDATA() {
        String data = this.characters_.toString();
        this.characters_.clear();
        DomCDataSection cdataSection = new DomCDataSection(this.page_, data);
        HtmlUnitNekoDOMBuilder.appendChild(this.currentNode_, cdataSection);
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
        this.handleCharacters();
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        DomDocumentType type = new DomDocumentType(this.page_, name, publicId, systemId);
        this.page_.setDocumentType(type);
        DomDocumentType child = type;
        this.page_.appendChild(child);
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void ignoredEndElement(QName element, Augmentations augs) {
        if ("form".equals(element.getLocalpart()) && this.consumingForm_ != null) {
            this.consumingForm_ = null;
            if (!(this.findElementOnStack("table", "form") instanceof HtmlTable)) {
                this.formEndingIsAdjusting_ = true;
            }
        }
    }

    @Override
    public void ignoredStartElement(QName elem, XMLAttributes attrs, Augmentations augs) {
        String lp;
        if (attrs != null && this.body_ != null && (lp = elem.getLocalpart()) != null && lp.length() == 4) {
            DomNode parent;
            if ("body".equalsIgnoreCase(lp)) {
                HtmlUnitNekoDOMBuilder.copyAttributes(this.body_, attrs);
            } else if ("html".equalsIgnoreCase(lp) && (parent = this.body_.getParentNode()) instanceof DomElement) {
                HtmlUnitNekoDOMBuilder.copyAttributes((DomElement)parent, attrs);
            }
        }
    }

    private static void copyAttributes(DomElement to, XMLAttributes attrs) {
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            String attrName = StringUtils.toRootLowerCase(attrs.getLocalName(i));
            if (to.getAttributes().getNamedItem(attrName) != null) continue;
            to.setAttribute(attrName, attrs.getValue(i));
            if (!attrName.startsWith("on") || !to.getPage().getWebClient().isJavaScriptEngineEnabled() || !(to.getScriptableObject() instanceof HTMLBodyElement)) continue;
            HTMLBodyElement jsBody = (HTMLBodyElement)to.getScriptableObject();
            jsBody.createEventHandlerFromAttribute(attrName, attrs.getValue(i));
        }
    }

    @Override
    public void parse(XMLInputSource inputSource) throws XNIException, IOException {
        HTMLParserDOMBuilder oldBuilder = this.page_.getDOMBuilder();
        this.page_.setDOMBuilder(this);
        try {
            super.parse(inputSource);
        }
        finally {
            this.page_.setDOMBuilder(oldBuilder);
        }
    }

    private static void appendChild(DomNode parent, DomNode child) {
        if (parent instanceof HtmlTemplate) {
            ((HtmlTemplate)parent).getContent().appendChild(child);
            return;
        }
        parent.appendChild(child);
    }

    static {
        int commandShortCode = 147;
        HTMLElements.Element command = new HTMLElements.Element(147, "COMMAND", 4, new short[]{18, 56}, null);
        HTMLELEMENTS = new HTMLElements();
        HTMLElements value = new HTMLElements();
        value.setElement(command);
        HTMLELEMENTS_WITH_CMD = value;
    }

    private static enum HeadParsed {
        YES,
        SYNTHESIZED,
        NO;

    }
}

