/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.net.URL;
import java.util.Set;
import org.htmlunit.Page;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.event.MessageEvent;
import org.htmlunit.util.UrlUtils;

@JsxClass
public class BroadcastChannel
extends EventTarget {
    private String name_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsxConstructor
    public static BroadcastChannel jsConstructor(Context cx, Scriptable scope, Object[] args, Function ctorObj, boolean inNewExpr) {
        Set<BroadcastChannel> broadcastChannels;
        if (args.length < 1 || JavaScriptEngine.isUndefined(args[0])) {
            throw JavaScriptEngine.typeError("BroadcastChannel constructor requires a channel name argument");
        }
        BroadcastChannel broadcastChannel = new BroadcastChannel();
        Window window = BroadcastChannel.getWindow(ctorObj);
        broadcastChannel.setParentScope(window);
        broadcastChannel.setPrototype(((FunctionObject)ctorObj).getClassPrototype());
        broadcastChannel.name_ = JavaScriptEngine.toString(args[0]);
        Set<BroadcastChannel> set = broadcastChannels = window.getWebWindow().getWebClient().getBroadcastChannels();
        synchronized (set) {
            broadcastChannels.add(broadcastChannel);
        }
        return broadcastChannel;
    }

    @JsxGetter
    public String getName() {
        return this.name_;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.getEventListenersContainer().getEventHandler("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.getEventListenersContainer().setEventHandler("message", onmessage);
    }

    @JsxGetter
    public Function getOnmessageerror() {
        return this.getEventListenersContainer().getEventHandler("messageerror");
    }

    @JsxSetter
    public void setOnmessageerror(Object onmessageerror) {
        this.getEventListenersContainer().setEventHandler("messageerror", onmessageerror);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsxFunction
    public void postMessage(Object message) {
        Set<BroadcastChannel> broadcastChannels;
        if (this.name_ == null) {
            return;
        }
        Window w = this.getWindow();
        WebWindow webWindow = w.getWebWindow();
        Page page = webWindow.getEnclosedPage();
        URL currentURL = page.getUrl();
        String origin = currentURL.getProtocol() + "://" + currentURL.getHost() + ':' + currentURL.getPort();
        final AbstractJavaScriptEngine<?> jsEngine = webWindow.getWebClient().getJavaScriptEngine();
        Set<BroadcastChannel> set = broadcastChannels = webWindow.getWebClient().getBroadcastChannels();
        synchronized (set) {
            for (final BroadcastChannel channel : broadcastChannels) {
                Window channelWindow;
                WebWindow channelWebWindow;
                Page channelPage;
                if (channel == this || !this.name_.equals(channel.name_) || !UrlUtils.isSameOrigin(currentURL, (channelPage = (channelWebWindow = (channelWindow = channel.getWindow()).getWebWindow()).getEnclosedPage()).getUrl())) continue;
                Scriptable ports = JavaScriptEngine.newArray((Scriptable)w, 0);
                final MessageEvent event = new MessageEvent();
                event.initMessageEvent("message", false, false, message, origin, "", null, ports);
                event.setParentScope(channelWindow);
                event.setPrototype(channelWindow.getPrototype(event.getClass()));
                PostponedAction action = new PostponedAction(channelPage, "BroadcastChannel.postMessage"){

                    @Override
                    public void execute() {
                        HtmlUnitContextFactory cf = jsEngine.getContextFactory();
                        cf.call(cx -> channel.dispatchEvent(event));
                    }
                };
                jsEngine.addPostponedAction(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsxFunction
    public void close() {
        Set<BroadcastChannel> broadcastChannels;
        Set<BroadcastChannel> set = broadcastChannels = this.getWindow().getWebWindow().getWebClient().getBroadcastChannels();
        synchronized (set) {
            broadcastChannels.remove(this);
        }
        this.name_ = null;
    }
}

