/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.css.ElementCssStyleDeclaration;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomCDataSection;
import org.htmlunit.html.DomCharacterData;
import org.htmlunit.html.DomComment;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlTemplate;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.DOMRect;
import org.htmlunit.javascript.host.DOMRectList;
import org.htmlunit.javascript.host.NamedNodeMap;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.css.CSSStyleDeclaration;
import org.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import org.htmlunit.javascript.host.dom.Attr;
import org.htmlunit.javascript.host.dom.DOMTokenList;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.EventHandler;
import org.htmlunit.javascript.host.event.UIEvent;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLScriptElement;
import org.htmlunit.javascript.host.html.HTMLStyleElement;
import org.htmlunit.javascript.host.html.HTMLTemplateElement;
import org.htmlunit.util.StringUtils;
import org.xml.sax.SAXException;

@JsxClass(domClass=DomElement.class)
public class Element
extends Node {
    static final String POSITION_BEFORE_BEGIN = "beforebegin";
    static final String POSITION_AFTER_BEGIN = "afterbegin";
    static final String POSITION_BEFORE_END = "beforeend";
    static final String POSITION_AFTER_END = "afterend";
    private static final Pattern CLASS_NAMES_SPLIT_PATTERN = Pattern.compile("\\s");
    private static final Pattern PRINT_NODE_PATTERN = Pattern.compile(" {2}");
    private static final Pattern PRINT_NODE_QUOTE_PATTERN = Pattern.compile("\"");
    private NamedNodeMap attributes_;
    private Map<String, HTMLCollection> elementsByTagName_;
    private int scrollLeft_;
    private int scrollTop_;
    private CSSStyleDeclaration style_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        this.setParentScope(this.getWindow().getDocument());
        this.style_ = new CSSStyleDeclaration(this, new ElementCssStyleDeclaration(this.getDomNodeOrDie()));
        DomElement htmlElt = (DomElement)domNode;
        for (DomAttr attr : htmlElt.getAttributesMap().values()) {
            String eventName = StringUtils.toRootLowerCase(attr.getName());
            if (!eventName.startsWith("on")) continue;
            this.createEventHandler(eventName.substring(2), attr.getValue());
        }
    }

    protected void createEventHandler(String eventName, String attrValue) {
        DomElement htmlElt = this.getDomNodeOrDie();
        EventHandler eventHandler = new EventHandler(htmlElt, eventName, attrValue);
        eventHandler.setPrototype(ScriptableObject.getClassPrototype(htmlElt.getScriptableObject(), "Function"));
        this.setEventHandler(eventName, eventHandler);
    }

    @JsxGetter
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    @JsxGetter
    public NamedNodeMap getAttributes() {
        if (this.attributes_ == null) {
            this.attributes_ = this.createAttributesObject();
        }
        return this.attributes_;
    }

    protected NamedNodeMap createAttributesObject() {
        return new NamedNodeMap(this.getDomNodeOrDie());
    }

    @JsxFunction
    public String getAttribute(String attributeName) {
        String value = this.getDomNodeOrDie().getAttribute(attributeName);
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value) {
            value = null;
        }
        return value;
    }

    @JsxFunction
    public void setAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute(name, value);
    }

    @JsxFunction
    public HTMLCollection getElementsByTagName(String tagName) {
        boolean caseSensitive;
        String searchTagName;
        DomNode dom;
        if (this.elementsByTagName_ == null) {
            this.elementsByTagName_ = new HashMap<String, HTMLCollection>();
        }
        if ((dom = this.getDomNodeOrNull()) == null) {
            searchTagName = StringUtils.toRootLowerCase(tagName);
            caseSensitive = false;
        } else {
            SgmlPage page = dom.getPage();
            if (page != null && page.hasCaseSensitiveTagNames()) {
                searchTagName = tagName;
                caseSensitive = true;
            } else {
                searchTagName = StringUtils.toRootLowerCase(tagName);
                caseSensitive = false;
            }
        }
        HTMLCollection collection = this.elementsByTagName_.get(searchTagName);
        if (collection != null) {
            return collection;
        }
        DomElement node = this.getDomNodeOrDie();
        collection = new HTMLCollection((DomNode)node, false);
        if (StringUtils.equalsChar('*', tagName)) {
            collection.setIsMatchingPredicate((Predicate<DomNode> & Serializable)nodeToMatch -> true);
        } else {
            collection.setIsMatchingPredicate((Predicate<DomNode> & Serializable)nodeToMatch -> {
                if (caseSensitive) {
                    return searchTagName.equals(nodeToMatch.getNodeName());
                }
                return searchTagName.equalsIgnoreCase(nodeToMatch.getNodeName());
            });
        }
        this.elementsByTagName_.put(tagName, collection);
        return collection;
    }

    @JsxFunction
    public HtmlUnitScriptable getAttributeNode(String name) {
        Map<String, DomAttr> attributes = this.getDomNodeOrDie().getAttributesMap();
        for (DomAttr attr : attributes.values()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public HTMLCollection getElementsByTagNameNS(Object namespaceURI, String localName) {
        HTMLCollection elements = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false);
        elements.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> !(!"*".equals(namespaceURI) && !Objects.equals(namespaceURI, node.getNamespaceURI()) || !"*".equals(localName) && !Objects.equals(localName, node.getLocalName())));
        return elements;
    }

    @JsxFunction
    public boolean hasAttribute(String name) {
        return this.getDomNodeOrDie().hasAttribute(name);
    }

    @Override
    @JsxFunction
    public boolean hasAttributes() {
        return super.hasAttributes();
    }

    @Override
    public DomElement getDomNodeOrDie() {
        return (DomElement)super.getDomNodeOrDie();
    }

    @JsxFunction
    public void removeAttribute(String name) {
        this.getDomNodeOrDie().removeAttribute(name);
    }

    @JsxFunction
    public DOMRect getBoundingClientRect() {
        DOMRect textRectangle = new DOMRect(1, 1, 1, 1);
        textRectangle.setParentScope(this.getWindow());
        textRectangle.setPrototype(this.getPrototype(textRectangle.getClass()));
        return textRectangle;
    }

    @Override
    @JsxGetter
    public int getChildElementCount() {
        return this.getDomNodeOrDie().getChildElementCount();
    }

    @Override
    @JsxGetter
    public Element getFirstElementChild() {
        return super.getFirstElementChild();
    }

    @Override
    @JsxGetter
    public Element getLastElementChild() {
        return super.getLastElementChild();
    }

    @JsxGetter
    public Element getNextElementSibling() {
        DomElement child = this.getDomNodeOrDie().getNextElementSibling();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public Element getPreviousElementSibling() {
        DomElement child = this.getDomNodeOrDie().getPreviousElementSibling();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @Override
    public Element getParentElement() {
        Node parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Element); parent = parent.getParent()) {
        }
        return (Element)parent;
    }

    @Override
    @JsxGetter
    public HTMLCollection getChildren() {
        return super.getChildren();
    }

    @JsxGetter
    public DOMTokenList getClassList() {
        return new DOMTokenList(this, "class");
    }

    @JsxFunction
    public String getAttributeNS(String namespaceURI, String localName) {
        String value = this.getDomNodeOrDie().getAttributeNS(namespaceURI, localName);
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value) {
            return null;
        }
        return value;
    }

    @JsxFunction
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().hasAttributeNS(namespaceURI, localName);
    }

    @JsxFunction
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.getDomNodeOrDie().setAttributeNS(namespaceURI, qualifiedName, value);
    }

    @JsxFunction
    public void removeAttributeNS(String namespaceURI, String localName) {
        this.getDomNodeOrDie().removeAttributeNS(namespaceURI, localName);
    }

    @JsxFunction
    public Attr setAttributeNode(Attr newAtt) {
        String name = newAtt.getName();
        NamedNodeMap nodes = this.getAttributes();
        Attr replacedAtt = (Attr)nodes.getNamedItemWithoutSytheticClassAttr(name);
        if (replacedAtt != null) {
            replacedAtt.detachFromParent();
        }
        DomAttr newDomAttr = newAtt.getDomNodeOrDie();
        this.getDomNodeOrDie().setAttributeNode(newDomAttr);
        return replacedAtt;
    }

    @JsxFunction
    public NodeList querySelectorAll(String selectors) {
        try {
            return NodeList.staticNodeList(this, this.getDomNodeOrDie().querySelectorAll(selectors));
        }
        catch (CSSException e) {
            throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ").", 12);
        }
    }

    @JsxFunction
    public Node querySelector(String selectors) {
        try {
            Object node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)((DomNode)node).getScriptableObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ").", 12);
        }
    }

    @JsxGetter(propertyName="className")
    public String getClassName_js() {
        return this.getDomNodeOrDie().getAttributeDirect("class");
    }

    @JsxSetter(propertyName="className")
    public void setClassName_js(String className) {
        this.getDomNodeOrDie().setAttribute("class", className);
    }

    @JsxGetter
    public int getClientHeight() {
        ComputedCssStyleDeclaration style = this.getWindow().getWebWindow().getComputedStyle(this.getDomNodeOrDie(), null);
        return style.getCalculatedHeight(false, true);
    }

    @JsxGetter
    public int getClientWidth() {
        ComputedCssStyleDeclaration style = this.getWindow().getWebWindow().getComputedStyle(this.getDomNodeOrDie(), null);
        return style.getCalculatedWidth(false, true);
    }

    @JsxGetter
    public int getClientLeft() {
        ComputedCssStyleDeclaration style = this.getWindow().getWebWindow().getComputedStyle(this.getDomNodeOrDie(), null);
        return style.getBorderLeftValue();
    }

    @JsxGetter
    public int getClientTop() {
        ComputedCssStyleDeclaration style = this.getWindow().getWebWindow().getComputedStyle(this.getDomNodeOrDie(), null);
        return style.getBorderTopValue();
    }

    @JsxFunction
    public HtmlUnitScriptable getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().getAttributeNodeNS(namespaceURI, localName).getScriptableObject();
    }

    @JsxFunction
    public HTMLCollection getElementsByClassName(String className) {
        DomElement elt = this.getDomNodeOrDie();
        String[] classNames = CLASS_NAMES_SPLIT_PATTERN.split(className, 0);
        HTMLCollection elements = new HTMLCollection((DomNode)elt, true);
        elements.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> {
            if (!(node instanceof HtmlElement)) {
                return false;
            }
            String classAttribute = ((HtmlElement)node).getAttributeDirect("class");
            if (DomElement.ATTRIBUTE_NOT_DEFINED == classAttribute) {
                return false;
            }
            classAttribute = " " + classAttribute + " ";
            for (String aClassName : classNames) {
                if (classAttribute.contains(" " + aClassName + " ")) continue;
                return false;
            }
            return true;
        });
        return elements;
    }

    @JsxFunction
    public DOMRectList getClientRects() {
        Window w = this.getWindow();
        DOMRectList rectList = new DOMRectList();
        rectList.setParentScope(w);
        rectList.setPrototype(this.getPrototype(rectList.getClass()));
        if (!this.isDisplayNone() && this.getDomNodeOrDie().isAttachedToPage()) {
            DOMRect rect = new DOMRect(0, 0, 1, 1);
            rect.setParentScope(w);
            rect.setPrototype(this.getPrototype(rect.getClass()));
            rectList.add(rect);
        }
        return rectList;
    }

    protected final boolean isDisplayNone() {
        for (Element element = this; element != null; element = element.getParentElement()) {
            ComputedCSSStyleDeclaration style = element.getWindow().getComputedStyle(element, null);
            String display = ((CSSStyleDeclaration)style).getDisplay();
            if (!HtmlElement.DisplayStyle.NONE.value().equals(display)) continue;
            return true;
        }
        return false;
    }

    @JsxFunction
    public Node insertAdjacentElement(String where, Object insertedElement) {
        if (insertedElement instanceof Node) {
            Node insertedElementNode = (Node)insertedElement;
            DomNode childNode = insertedElementNode.getDomNodeOrDie();
            Object[] values = this.getInsertAdjacentLocation(where);
            DomNode node = (DomNode)values[0];
            boolean append = (Boolean)values[1];
            if (append) {
                node.appendChild(childNode);
            } else {
                node.insertBefore(childNode);
            }
            return insertedElementNode;
        }
        throw JavaScriptEngine.reportRuntimeError("Passed object is not an element: " + insertedElement);
    }

    @JsxFunction
    public void insertAdjacentText(String where, String text) {
        Object[] values = this.getInsertAdjacentLocation(where);
        DomNode node = (DomNode)values[0];
        boolean append = (Boolean)values[1];
        DomText domText = new DomText(node.getPage(), text);
        if (append) {
            node.appendChild(domText);
        } else {
            node.insertBefore(domText);
        }
    }

    private Object[] getInsertAdjacentLocation(String where) {
        boolean append;
        DomNode node;
        DomElement currentNode = this.getDomNodeOrDie();
        if (POSITION_AFTER_BEGIN.equalsIgnoreCase(where)) {
            if (currentNode.getFirstChild() == null) {
                node = currentNode;
                append = true;
            } else {
                node = currentNode.getFirstChild();
                append = false;
            }
        } else if (POSITION_BEFORE_BEGIN.equalsIgnoreCase(where)) {
            node = currentNode;
            append = false;
        } else if (POSITION_BEFORE_END.equalsIgnoreCase(where)) {
            node = currentNode;
            append = true;
        } else if (POSITION_AFTER_END.equalsIgnoreCase(where)) {
            if (currentNode.getNextSibling() == null) {
                node = currentNode.getParentNode();
                append = true;
            } else {
                node = currentNode.getNextSibling();
                append = false;
            }
        } else {
            throw JavaScriptEngine.reportRuntimeError("Illegal position value: \"" + where + "\"");
        }
        if (append) {
            return new Object[]{node, Boolean.TRUE};
        }
        return new Object[]{node, Boolean.FALSE};
    }

    @JsxFunction
    public void insertAdjacentHTML(String position, String text) {
        Object[] values = this.getInsertAdjacentLocation(position);
        DomNode domNode = (DomNode)values[0];
        boolean append = (Boolean)values[1];
        HTMLElement.ProxyDomNode proxyDomNode = new HTMLElement.ProxyDomNode(domNode.getPage(), domNode, append);
        Element.parseHtmlSnippet(proxyDomNode, text);
    }

    private static void parseHtmlSnippet(DomNode target, String source) {
        try {
            target.parseHtmlSnippet(source);
        }
        catch (IOException | SAXException e) {
            LogFactory.getLog(HtmlElement.class).error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
            throw JavaScriptEngine.reportRuntimeError("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage());
        }
    }

    @JsxFunction
    public String getHTML() {
        return this.getInnerHTML();
    }

    @JsxGetter
    public String getInnerHTML() {
        try {
            DomNode domNode = this.getDomNodeOrDie();
            if (this instanceof HTMLTemplateElement) {
                domNode = ((HtmlTemplate)this.getDomNodeOrDie()).getContent();
            }
            return this.getInnerHTML(domNode);
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.typeError(e.getMessage());
        }
    }

    @JsxSetter
    public void setInnerHTML(Object value) {
        DomElement domNode;
        try {
            domNode = this.getDomNodeOrDie();
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.typeError(e.getMessage());
        }
        String html = null;
        if (value != null && StringUtils.isEmptyString(html = JavaScriptEngine.toString(value))) {
            html = null;
        }
        try {
            domNode.setInnerHtml(html);
        }
        catch (IOException | SAXException e) {
            LogFactory.getLog(HtmlElement.class).error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
            throw JavaScriptEngine.reportRuntimeError("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage());
        }
    }

    protected String getInnerHTML(DomNode domNode) {
        StringBuilder buf = new StringBuilder();
        String tagName = this.getTagName();
        boolean isPlain = "SCRIPT".equals(tagName);
        isPlain = isPlain || "STYLE".equals(tagName);
        this.printChildren(buf, domNode, !isPlain);
        return buf.toString();
    }

    @JsxGetter
    public String getOuterHTML() {
        StringBuilder buf = new StringBuilder();
        this.printNode(buf, this.getDomNodeOrDie(), true);
        return buf.toString();
    }

    @JsxSetter
    public void setOuterHTML(Object value) {
        boolean append;
        DomNode target;
        DomElement domNode = this.getDomNodeOrDie();
        DomNode parent = domNode.getParentNode();
        if (null == parent) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OUTER_HTML_THROWS_FOR_DETACHED)) {
                throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "outerHTML is readonly for detached nodes", 7);
            }
            return;
        }
        if (value == null) {
            domNode.remove();
            return;
        }
        String valueStr = JavaScriptEngine.toString(value);
        if (valueStr.isEmpty()) {
            domNode.remove();
            return;
        }
        DomNode nextSibling = domNode.getNextSibling();
        domNode.remove();
        if (nextSibling != null) {
            target = nextSibling;
            append = false;
        } else {
            target = parent;
            append = true;
        }
        HTMLElement.ProxyDomNode proxyDomNode = new HTMLElement.ProxyDomNode(target.getPage(), target, append);
        Element.parseHtmlSnippet(proxyDomNode, valueStr);
    }

    protected final void printChildren(StringBuilder builder, DomNode node, boolean html) {
        if (node instanceof HtmlTemplate) {
            HtmlTemplate template = (HtmlTemplate)node;
            for (DomNode child : template.getContent().getChildren()) {
                this.printNode(builder, child, html);
            }
            return;
        }
        for (DomNode child : node.getChildren()) {
            this.printNode(builder, child, html);
        }
    }

    protected void printNode(StringBuilder builder, DomNode node, boolean html) {
        if (node instanceof DomComment) {
            if (html) {
                String s = PRINT_NODE_PATTERN.matcher(node.getNodeValue()).replaceAll(" ");
                builder.append("<!--").append(s).append("-->");
            }
        } else if (node instanceof DomCDataSection) {
            builder.append("<![CDATA[").append(node.getNodeValue()).append("]]>");
        } else if (node instanceof DomCharacterData) {
            String s = node.getNodeValue();
            if (html) {
                s = StringUtils.escapeXmlChars(s);
            }
            builder.append(s);
        } else if (html) {
            DomElement element = (DomElement)node;
            Element scriptObject = (Element)node.getScriptableObject();
            String tag = element.getTagName();
            Element htmlElement = null;
            if (scriptObject instanceof HTMLElement) {
                htmlElement = scriptObject;
            }
            builder.append('<').append(tag);
            for (DomAttr attr : element.getAttributesMap().values()) {
                if (!attr.getSpecified()) continue;
                String name = attr.getName();
                String value = PRINT_NODE_QUOTE_PATTERN.matcher(attr.getValue()).replaceAll("&quot;");
                builder.append(' ').append(name).append("=\"").append(value).append('\"');
            }
            builder.append('>');
            boolean isHtml = !(scriptObject instanceof HTMLScriptElement) && !(scriptObject instanceof HTMLStyleElement);
            this.printChildren(builder, node, isHtml);
            if (null == htmlElement || !htmlElement.isEndTagForbidden()) {
                builder.append("</").append(tag).append('>');
            }
        } else if (node instanceof HtmlElement) {
            HtmlElement element = (HtmlElement)node;
            if (StringUtils.equalsChar('p', element.getTagName())) {
                int i;
                for (i = builder.length() - 1; i >= 0 && Character.isWhitespace(builder.charAt(i)); --i) {
                }
                builder.setLength(i + 1);
                builder.append('\n');
            }
            if (!"script".equals(element.getTagName())) {
                this.printChildren(builder, node, html);
            }
        }
    }

    protected boolean isEndTagForbidden() {
        return false;
    }

    @JsxGetter
    public String getId() {
        return this.getDomNodeOrDie().getId();
    }

    @JsxSetter
    public void setId(String newId) {
        this.getDomNodeOrDie().setId(newId);
    }

    @JsxFunction
    public void removeAttributeNode(Attr attribute) {
        String name = attribute.getName();
        String namespaceUri = attribute.getNamespaceURI();
        this.removeAttributeNS(namespaceUri, name);
    }

    @JsxGetter
    public int getScrollTop() {
        ComputedCssStyleDeclaration style;
        if (this.scrollTop_ < 0) {
            this.scrollTop_ = 0;
        } else if (this.scrollTop_ > 0 && !(style = this.getWindow().getWebWindow().getComputedStyle(this.getDomNodeOrDie(), null)).isScrollable(false)) {
            this.scrollTop_ = 0;
        }
        return this.scrollTop_;
    }

    @JsxSetter
    public void setScrollTop(int scroll) {
        this.scrollTop_ = scroll;
    }

    @JsxGetter
    public int getScrollLeft() {
        ComputedCssStyleDeclaration style;
        if (this.scrollLeft_ < 0) {
            this.scrollLeft_ = 0;
        } else if (this.scrollLeft_ > 0 && !(style = this.getWindow().getWebWindow().getComputedStyle(this.getDomNodeOrDie(), null)).isScrollable(true)) {
            this.scrollLeft_ = 0;
        }
        return this.scrollLeft_;
    }

    @JsxSetter
    public void setScrollLeft(int scroll) {
        this.scrollLeft_ = scroll;
    }

    @JsxGetter
    public int getScrollHeight() {
        return this.getClientHeight();
    }

    @JsxGetter
    public int getScrollWidth() {
        return this.getClientWidth();
    }

    protected CSSStyleDeclaration getStyle() {
        return this.style_;
    }

    protected void setStyle(String style) {
        this.getStyle().setCssText(style);
    }

    @JsxFunction
    public void scroll(Scriptable x, Scriptable y) {
        this.scrollTo(x, y);
    }

    @JsxFunction
    public void scrollBy(Scriptable x, Scriptable y) {
        int xOff = 0;
        int yOff = 0;
        if (y != null) {
            xOff = JavaScriptEngine.toInt32(x);
            yOff = JavaScriptEngine.toInt32(y);
        } else {
            if (!(x instanceof NativeObject)) {
                throw JavaScriptEngine.typeError("eee");
            }
            if (x.has("left", x)) {
                xOff = JavaScriptEngine.toInt32(x.get("left", x));
            }
            if (x.has("top", x)) {
                yOff = JavaScriptEngine.toInt32(x.get("top", x));
            }
        }
        this.setScrollLeft(this.getScrollLeft() + xOff);
        this.setScrollTop(this.getScrollTop() + yOff);
        this.fireScrollEvent(this);
    }

    private void fireScrollEvent(Node node) {
        Event event;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_SCROLL_UIEVENT)) {
            event = new UIEvent(node, "scroll");
        } else {
            event = new Event(node, "scroll");
            event.setCancelable(false);
        }
        event.setBubbles(false);
        node.fireEvent(event);
    }

    private void fireScrollEvent(Window window) {
        Event event;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_SCROLL_UIEVENT)) {
            event = new UIEvent(window.getDocument(), "scroll");
        } else {
            event = new Event(window.getDocument(), "scroll");
            event.setCancelable(false);
        }
        window.fireEvent(event);
    }

    @JsxFunction
    public void scrollTo(Scriptable x, Scriptable y) {
        int yOff;
        int xOff;
        if (y != null) {
            xOff = JavaScriptEngine.toInt32(x);
            yOff = JavaScriptEngine.toInt32(y);
        } else {
            if (!(x instanceof NativeObject)) {
                throw JavaScriptEngine.typeError("eee");
            }
            xOff = this.getScrollLeft();
            yOff = this.getScrollTop();
            if (x.has("left", x)) {
                xOff = JavaScriptEngine.toInt32(x.get("left", x));
            }
            if (x.has("top", x)) {
                yOff = JavaScriptEngine.toInt32(x.get("top", x));
            }
        }
        this.setScrollLeft(xOff);
        this.setScrollTop(yOff);
        this.fireScrollEvent(this);
    }

    @JsxFunction
    public void scrollIntoView() {
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof HTMLElement)) continue;
            this.fireScrollEvent(parent);
        }
        this.fireScrollEvent(this.getWindow());
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void scrollIntoViewIfNeeded() {
    }

    @Override
    @JsxGetter
    public String getPrefix() {
        return super.getPrefix();
    }

    @Override
    @JsxGetter
    public String getLocalName() {
        return super.getLocalName();
    }

    @Override
    @JsxGetter
    public String getNamespaceURI() {
        return super.getNamespaceURI();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnbeforecopy() {
        return this.getEventHandler("beforecopy");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforecopy(Object onbeforecopy) {
        this.setEventHandler("beforecopy", onbeforecopy);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnbeforecut() {
        return this.getEventHandler("beforecut");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforecut(Object onbeforecut) {
        this.setEventHandler("beforecut", onbeforecut);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnbeforepaste() {
        return this.getEventHandler("beforepaste");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforepaste(Object onbeforepaste) {
        this.setEventHandler("beforepaste", onbeforepaste);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnsearch() {
        return this.getEventHandler("search");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnsearch(Object onsearch) {
        this.setEventHandler("search", onsearch);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnwebkitfullscreenchange() {
        return this.getEventHandler("webkitfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwebkitfullscreenchange(Object onwebkitfullscreenchange) {
        this.setEventHandler("webkitfullscreenchange", onwebkitfullscreenchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnwebkitfullscreenerror() {
        return this.getEventHandler("webkitfullscreenerror");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwebkitfullscreenerror(Object onwebkitfullscreenerror) {
        this.setEventHandler("webkitfullscreenerror", onwebkitfullscreenerror);
    }

    public Function getOnwheel() {
        return this.getEventHandler("wheel");
    }

    public void setOnwheel(Object onwheel) {
        this.setEventHandler("wheel", onwheel);
    }

    @Override
    @JsxFunction
    public void remove() {
        super.remove();
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setCapture(boolean retargetToElement) {
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void releaseCapture() {
    }

    @JsxFunction
    public static void before(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        Node.before(context, thisObj, args, function);
    }

    @JsxFunction
    public static void after(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        Node.after(context, thisObj, args, function);
    }

    @JsxFunction
    public static void replaceWith(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        Node.replaceWith(context, thisObj, args, function);
    }

    @JsxFunction
    public static boolean matches(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        if (!(thisObj instanceof Element)) {
            throw JavaScriptEngine.typeError("Illegal invocation");
        }
        String selectorString = (String)args[0];
        try {
            DomNode domNode = ((Element)thisObj).getDomNodeOrNull();
            return domNode != null && ((DomElement)domNode).matches(selectorString);
        }
        catch (CSSException e) {
            throw JavaScriptEngine.asJavaScriptException((HtmlUnitScriptable)Element.getTopLevelScope(thisObj), "An invalid or illegal selector was specified (selector: '" + selectorString + "' error: " + e.getMessage() + ").", 12);
        }
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static boolean mozMatchesSelector(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        return Element.matches(context, scope, thisObj, args, function);
    }

    @JsxFunction
    public static boolean webkitMatchesSelector(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        return Element.matches(context, scope, thisObj, args, function);
    }

    @JsxFunction
    public static Element closest(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        if (!(thisObj instanceof Element)) {
            throw JavaScriptEngine.typeError("Illegal invocation");
        }
        String selectorString = (String)args[0];
        try {
            DomNode domNode = ((Element)thisObj).getDomNodeOrNull();
            if (domNode == null) {
                return null;
            }
            DomElement elem = domNode.closest(selectorString);
            if (elem == null) {
                return null;
            }
            return (Element)elem.getScriptableObject();
        }
        catch (CSSException e) {
            throw JavaScriptEngine.syntaxError("An invalid or illegal selector was specified (selector: '" + selectorString + "' error: " + e.getMessage() + ").");
        }
    }

    @JsxFunction
    public boolean toggleAttribute(String name, Object force) {
        if (JavaScriptEngine.isUndefined(force)) {
            if (this.hasAttribute(name)) {
                this.removeAttribute(name);
                return false;
            }
            this.setAttribute(name, "");
            return true;
        }
        if (JavaScriptEngine.toBoolean(force)) {
            this.setAttribute(name, "");
            return true;
        }
        this.removeAttribute(name);
        return false;
    }

    @JsxFunction
    public static void append(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        if (!(thisObj instanceof Element)) {
            throw JavaScriptEngine.typeError("Illegal invocation");
        }
        Node.append(context, thisObj, args, function);
    }

    @JsxFunction
    public static void prepend(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        if (!(thisObj instanceof Element)) {
            throw JavaScriptEngine.typeError("Illegal invocation");
        }
        Node.prepend(context, thisObj, args, function);
    }

    @JsxFunction
    public static void replaceChildren(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        if (!(thisObj instanceof Element)) {
            throw JavaScriptEngine.typeError("Illegal invocation");
        }
        Node.replaceChildren(context, thisObj, args, function);
    }
}

