/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import org.htmlunit.Page;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import org.htmlunit.javascript.background.JavaScriptFunctionJob;
import org.htmlunit.javascript.background.JavaScriptJob;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.util.StringUtils;

public final class WindowOrWorkerGlobalScopeMixin {
    private static final int MIN_TIMER_DELAY = 1;

    private WindowOrWorkerGlobalScopeMixin() {
    }

    public static String atob(String encodedData, HtmlUnitScriptable scriptable) {
        String withoutWhitespace = StringUtils.replaceChars(encodedData, " \t\r\n\f", "");
        byte[] bytes = withoutWhitespace.getBytes(StandardCharsets.ISO_8859_1);
        try {
            return new String(Base64.getDecoder().decode(bytes), StandardCharsets.ISO_8859_1);
        }
        catch (IllegalArgumentException e) {
            throw JavaScriptEngine.asJavaScriptException(scriptable, "Failed to execute atob(): " + e.getMessage(), 5);
        }
    }

    public static String btoa(String stringToEncode, HtmlUnitScriptable scriptable) {
        int l = stringToEncode.length();
        for (int i = 0; i < l; ++i) {
            if (stringToEncode.charAt(i) <= '\u00ff') continue;
            throw JavaScriptEngine.asJavaScriptException(scriptable, "Function btoa supports only latin1 characters", 5);
        }
        byte[] bytes = stringToEncode.getBytes(StandardCharsets.ISO_8859_1);
        try {
            return new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw JavaScriptEngine.asJavaScriptException(scriptable, "Failed to execute btoa(): " + e.getMessage(), 5);
        }
    }

    public static Object setTimeout(Context context, Scriptable thisObj, Object[] args, Function function) {
        if (args.length < 1) {
            throw JavaScriptEngine.typeError("Function not provided");
        }
        int timeout = JavaScriptEngine.toInt32(args.length > 1 ? args[1] : JavaScriptEngine.UNDEFINED);
        Object[] params = args.length > 2 ? Arrays.copyOfRange(args, 2, args.length) : JavaScriptEngine.EMPTY_ARGS;
        return WindowOrWorkerGlobalScopeMixin.setTimeoutIntervalImpl((Window)thisObj, args[0], timeout, true, params);
    }

    public static Object setInterval(Context context, Scriptable thisObj, Object[] args, Function function) {
        if (args.length < 1) {
            throw JavaScriptEngine.typeError("Function not provided");
        }
        int timeout = JavaScriptEngine.toInt32(args.length > 1 ? args[1] : JavaScriptEngine.UNDEFINED);
        Object[] params = args.length > 2 ? Arrays.copyOfRange(args, 2, args.length) : JavaScriptEngine.EMPTY_ARGS;
        return WindowOrWorkerGlobalScopeMixin.setTimeoutIntervalImpl((Window)thisObj, args[0], timeout, false, params);
    }

    private static int setTimeoutIntervalImpl(Window window, Object code, int timeout, boolean isTimeout, Object[] params) {
        if (timeout < 1) {
            timeout = 1;
        }
        WebWindow webWindow = window.getWebWindow();
        Page page = (Page)((Object)window.getDomNodeOrNull());
        Integer period = null;
        if (!isTimeout) {
            period = timeout;
        }
        if (code instanceof String) {
            String s = (String)code;
            String description = "window.set" + (isTimeout ? "Timeout" : "Interval") + "(" + s + ", " + timeout + ")";
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, period, description, webWindow, s);
            return webWindow.getJobManager().addJob(job, page);
        }
        if (code instanceof Function) {
            Function f = (Function)code;
            String functionName = f instanceof FunctionObject ? ((FunctionObject)f).getFunctionName() : String.valueOf(f);
            String description = "window.set" + (isTimeout ? "Timeout" : "Interval") + "(" + functionName + ", " + timeout + ")";
            JavaScriptFunctionJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, period, description, webWindow, f, params);
            return webWindow.getJobManager().addJob(job, page);
        }
        throw JavaScriptEngine.reportRuntimeError("Unknown type for function.");
    }
}

