/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.json.JsonParser;
import org.htmlunit.corejs.javascript.typedarrays.NativeFloat32Array;
import org.htmlunit.corejs.javascript.typedarrays.NativeFloat64Array;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.DOMMatrix;

@JsxClass
public class DOMMatrixReadOnly
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(DOMMatrixReadOnly.class);
    private double m11_ = 1.0;
    private double m12_ = 0.0;
    private double m13_ = 0.0;
    private double m14_ = 0.0;
    private double m21_ = 0.0;
    private double m22_ = 1.0;
    private double m23_ = 0.0;
    private double m24_ = 0.0;
    private double m31_ = 0.0;
    private double m32_ = 0.0;
    private double m33_ = 1.0;
    private double m34_ = 0.0;
    private double m41_ = 0.0;
    private double m42_ = 0.0;
    private double m43_ = 0.0;
    private double m44_ = 1.0;
    private boolean is2D_ = true;

    @JsxConstructor
    public static DOMMatrixReadOnly jsConstructor(Context cx, Scriptable scope, Object[] args, Function ctorObj, boolean inNewExpr) {
        DOMMatrixReadOnly matrix = new DOMMatrixReadOnly();
        matrix.init(args, ctorObj);
        return matrix;
    }

    protected void init(Object[] args, Function ctorObj) {
        Window window = DOMMatrixReadOnly.getWindow(ctorObj);
        this.setParentScope(window);
        this.setPrototype(((FunctionObject)ctorObj).getClassPrototype());
        if (args.length == 0 || JavaScriptEngine.isUndefined(args[0])) {
            return;
        }
        if (args[0] instanceof NativeArray) {
            NativeArray arrayArgs = (NativeArray)args[0];
            if (arrayArgs.getLength() == 6L) {
                this.m11_ = JavaScriptEngine.toNumber(arrayArgs.get(0));
                this.m12_ = JavaScriptEngine.toNumber(arrayArgs.get(1));
                this.m21_ = JavaScriptEngine.toNumber(arrayArgs.get(2));
                this.m22_ = JavaScriptEngine.toNumber(arrayArgs.get(3));
                this.m41_ = JavaScriptEngine.toNumber(arrayArgs.get(4));
                this.m42_ = JavaScriptEngine.toNumber(arrayArgs.get(5));
                this.is2D_ = true;
                return;
            }
            if (arrayArgs.getLength() == 16L) {
                this.m11_ = JavaScriptEngine.toNumber(arrayArgs.get(0));
                this.m12_ = JavaScriptEngine.toNumber(arrayArgs.get(1));
                this.m13_ = JavaScriptEngine.toNumber(arrayArgs.get(2));
                this.m14_ = JavaScriptEngine.toNumber(arrayArgs.get(3));
                this.m21_ = JavaScriptEngine.toNumber(arrayArgs.get(4));
                this.m22_ = JavaScriptEngine.toNumber(arrayArgs.get(5));
                this.m23_ = JavaScriptEngine.toNumber(arrayArgs.get(6));
                this.m24_ = JavaScriptEngine.toNumber(arrayArgs.get(7));
                this.m31_ = JavaScriptEngine.toNumber(arrayArgs.get(8));
                this.m32_ = JavaScriptEngine.toNumber(arrayArgs.get(9));
                this.m33_ = JavaScriptEngine.toNumber(arrayArgs.get(10));
                this.m34_ = JavaScriptEngine.toNumber(arrayArgs.get(11));
                this.m41_ = JavaScriptEngine.toNumber(arrayArgs.get(12));
                this.m42_ = JavaScriptEngine.toNumber(arrayArgs.get(13));
                this.m43_ = JavaScriptEngine.toNumber(arrayArgs.get(14));
                this.m44_ = JavaScriptEngine.toNumber(arrayArgs.get(15));
                this.is2D_ = false;
                return;
            }
            throw JavaScriptEngine.typeError("DOMMatrixReadOnly constructor: Matrix init sequence must have a length of 6 or 16 (actual value: " + arrayArgs.getLength() + ")");
        }
        throw JavaScriptEngine.asJavaScriptException(window, "An invalid or illegal string was specified", 12);
    }

    @JsxGetter
    public double getM11() {
        return this.m11_;
    }

    public void setM11(double m11) {
        this.m11_ = m11;
    }

    @JsxGetter
    public double getA() {
        return this.m11_;
    }

    @JsxGetter
    public double getM12() {
        return this.m12_;
    }

    public void setM12(double m12) {
        this.m12_ = m12;
    }

    @JsxGetter
    public double getB() {
        return this.m12_;
    }

    @JsxGetter
    public double getM13() {
        return this.m13_;
    }

    public void setM13(double m13) {
        this.m13_ = m13;
    }

    @JsxGetter
    public double getM14() {
        return this.m14_;
    }

    public void setM14(double m14) {
        this.m14_ = m14;
    }

    @JsxGetter
    public double getM21() {
        return this.m21_;
    }

    public void setM21(double m21) {
        this.m21_ = m21;
    }

    @JsxGetter
    public double getC() {
        return this.m21_;
    }

    @JsxGetter
    public double getM22() {
        return this.m22_;
    }

    public void setM22(double m22) {
        this.m22_ = m22;
    }

    @JsxGetter
    public double getD() {
        return this.m22_;
    }

    @JsxGetter
    public double getM23() {
        return this.m23_;
    }

    public void setM23(double m23) {
        this.m23_ = m23;
    }

    @JsxGetter
    public double getM24() {
        return this.m24_;
    }

    public void setM24(double m24) {
        this.m24_ = m24;
    }

    @JsxGetter
    public double getM31() {
        return this.m31_;
    }

    public void setM31(double m31) {
        this.m31_ = m31;
    }

    @JsxGetter
    public double getM32() {
        return this.m32_;
    }

    public void setM32(double m32) {
        this.m32_ = m32;
    }

    @JsxGetter
    public double getM33() {
        return this.m33_;
    }

    public void setM33(double m33) {
        this.m33_ = m33;
    }

    @JsxGetter
    public double getM34() {
        return this.m34_;
    }

    public void setM34(double m34) {
        this.m34_ = m34;
    }

    @JsxGetter
    public double getM41() {
        return this.m41_;
    }

    public void setM41(double m41) {
        this.m41_ = m41;
    }

    @JsxGetter
    public double getE() {
        return this.m41_;
    }

    @JsxGetter
    public double getM42() {
        return this.m42_;
    }

    public void setM42(double m42) {
        this.m42_ = m42;
    }

    @JsxGetter
    public double getF() {
        return this.m42_;
    }

    @JsxGetter
    public double getM43() {
        return this.m43_;
    }

    public void setM43(double m43) {
        this.m43_ = m43;
    }

    @JsxGetter
    public double getM44() {
        return this.m44_;
    }

    public void setM44(double m44) {
        this.m44_ = m44;
    }

    @JsxGetter
    public boolean isIs2D() {
        return this.is2D_;
    }

    public void setIs2D(boolean is2D) {
        this.is2D_ = is2D;
    }

    @JsxGetter
    public boolean getIsIdentity() {
        return this.m11_ == 1.0 && this.m22_ == 1.0 && this.m33_ == 1.0 && this.m44_ == 1.0 && this.m12_ == 0.0 && this.m13_ == 0.0 && this.m14_ == 0.0 && this.m21_ == 0.0 && this.m23_ == 0.0 && this.m24_ == 0.0 && this.m31_ == 0.0 && this.m32_ == 0.0 && this.m34_ == 0.0 && this.m41_ == 0.0 && this.m42_ == 0.0 && this.m43_ == 0.0;
    }

    @JsxFunction
    public DOMMatrix flipX() {
        DOMMatrix matrix = new DOMMatrix();
        Window window = this.getWindow();
        matrix.setParentScope(window);
        matrix.setPrototype(window.getPrototype(DOMMatrix.class));
        matrix.setM11(-this.m11_);
        matrix.setM12(-this.m12_);
        matrix.setM13(-this.m13_);
        matrix.setM14(-this.m14_);
        matrix.setM21(this.m21_);
        matrix.setM22(this.m22_);
        matrix.setM23(this.m23_);
        matrix.setM24(this.m24_);
        matrix.setM31(this.m31_);
        matrix.setM32(this.m32_);
        matrix.setM33(this.m33_);
        matrix.setM34(this.m34_);
        matrix.setM41(this.m41_);
        matrix.setM42(this.m42_);
        matrix.setM43(this.m43_);
        matrix.setM44(this.m44_);
        matrix.setIs2D(this.is2D_);
        return matrix;
    }

    @JsxFunction
    public DOMMatrix flipY() {
        DOMMatrix matrix = new DOMMatrix();
        Window window = this.getWindow();
        matrix.setParentScope(window);
        matrix.setPrototype(window.getPrototype(DOMMatrix.class));
        matrix.setM11(this.m11_);
        matrix.setM12(this.m12_);
        matrix.setM13(this.m13_);
        matrix.setM14(this.m14_);
        matrix.setM21(-this.m21_);
        matrix.setM22(-this.m22_);
        matrix.setM23(-this.m23_);
        matrix.setM24(-this.m24_);
        matrix.setM31(this.m31_);
        matrix.setM32(this.m32_);
        matrix.setM33(this.m33_);
        matrix.setM34(this.m34_);
        matrix.setM41(this.m41_);
        matrix.setM42(this.m42_);
        matrix.setM43(this.m43_);
        matrix.setM44(this.m44_);
        matrix.setIs2D(this.is2D_);
        return matrix;
    }

    @JsxFunction
    public DOMMatrix inverse() {
        DOMMatrix matrix = new DOMMatrix();
        Window window = this.getWindow();
        matrix.setParentScope(window);
        matrix.setPrototype(window.getPrototype(DOMMatrix.class));
        matrix.setM11(this.m11_);
        matrix.setM12(this.m12_);
        matrix.setM13(this.m13_);
        matrix.setM14(this.m14_);
        matrix.setM21(this.m21_);
        matrix.setM22(this.m22_);
        matrix.setM23(this.m23_);
        matrix.setM24(this.m24_);
        matrix.setM31(this.m31_);
        matrix.setM32(this.m32_);
        matrix.setM33(this.m33_);
        matrix.setM34(this.m34_);
        matrix.setM41(this.m41_);
        matrix.setM42(this.m42_);
        matrix.setM43(this.m43_);
        matrix.setM44(this.m44_);
        matrix.setIs2D(this.is2D_);
        return matrix.invertSelf();
    }

    @JsxFunction
    public DOMMatrix multiply(Object other) {
        DOMMatrix result = new DOMMatrix();
        Window window = this.getWindow();
        result.setParentScope(window);
        result.setPrototype(window.getPrototype(DOMMatrix.class));
        if (other == null || JavaScriptEngine.isUndefined(other)) {
            return result;
        }
        if (!(other instanceof DOMMatrixReadOnly)) {
            throw JavaScriptEngine.typeError("Failed to execute 'multiply' on 'DOMMatrixReadOnly': parameter 1 is not of type 'DOMMatrixReadOnly'.");
        }
        DOMMatrixReadOnly otherMatrix = (DOMMatrixReadOnly)other;
        result.setIs2D(this.is2D_ && otherMatrix.is2D_);
        result.setM11(this.m11_ * otherMatrix.m11_ + this.m21_ * otherMatrix.m12_ + this.m31_ * otherMatrix.m13_ + this.m41_ * otherMatrix.m14_);
        result.setM12(this.m12_ * otherMatrix.m11_ + this.m22_ * otherMatrix.m12_ + this.m32_ * otherMatrix.m13_ + this.m42_ * otherMatrix.m14_);
        if (!result.isIs2D()) {
            result.setM13(this.m13_ * otherMatrix.m11_ + this.m23_ * otherMatrix.m12_ + this.m33_ * otherMatrix.m13_ + this.m43_ * otherMatrix.m14_);
            result.setM14(this.m14_ * otherMatrix.m11_ + this.m24_ * otherMatrix.m12_ + this.m34_ * otherMatrix.m13_ + this.m44_ * otherMatrix.m14_);
        }
        result.setM21(this.m11_ * otherMatrix.m21_ + this.m21_ * otherMatrix.m22_ + this.m31_ * otherMatrix.m23_ + this.m41_ * otherMatrix.m24_);
        result.setM22(this.m12_ * otherMatrix.m21_ + this.m22_ * otherMatrix.m22_ + this.m32_ * otherMatrix.m23_ + this.m42_ * otherMatrix.m24_);
        if (!result.isIs2D()) {
            result.setM23(this.m13_ * otherMatrix.m21_ + this.m23_ * otherMatrix.m22_ + this.m33_ * otherMatrix.m23_ + this.m43_ * otherMatrix.m24_);
            result.setM24(this.m14_ * otherMatrix.m21_ + this.m24_ * otherMatrix.m22_ + this.m34_ * otherMatrix.m23_ + this.m44_ * otherMatrix.m24_);
        }
        if (!result.isIs2D()) {
            result.setM31(this.m11_ * otherMatrix.m31_ + this.m21_ * otherMatrix.m32_ + this.m31_ * otherMatrix.m33_ + this.m41_ * otherMatrix.m34_);
            result.setM32(this.m12_ * otherMatrix.m31_ + this.m22_ * otherMatrix.m32_ + this.m32_ * otherMatrix.m33_ + this.m42_ * otherMatrix.m34_);
            result.setM33(this.m13_ * otherMatrix.m31_ + this.m23_ * otherMatrix.m32_ + this.m33_ * otherMatrix.m33_ + this.m43_ * otherMatrix.m34_);
            result.setM34(this.m14_ * otherMatrix.m31_ + this.m24_ * otherMatrix.m32_ + this.m34_ * otherMatrix.m33_ + this.m44_ * otherMatrix.m34_);
        }
        result.setM41(this.m11_ * otherMatrix.m41_ + this.m21_ * otherMatrix.m42_ + this.m31_ * otherMatrix.m43_ + this.m41_ * otherMatrix.m44_);
        result.setM42(this.m12_ * otherMatrix.m41_ + this.m22_ * otherMatrix.m42_ + this.m32_ * otherMatrix.m43_ + this.m42_ * otherMatrix.m44_);
        if (!result.isIs2D()) {
            result.setM43(this.m13_ * otherMatrix.m41_ + this.m23_ * otherMatrix.m42_ + this.m33_ * otherMatrix.m43_ + this.m43_ * otherMatrix.m44_);
            result.setM44(this.m14_ * otherMatrix.m41_ + this.m24_ * otherMatrix.m42_ + this.m34_ * otherMatrix.m43_ + this.m44_ * otherMatrix.m44_);
        }
        return result;
    }

    @JsxFunction
    public DOMMatrixReadOnly rotate(Object rotZ) {
        DOMMatrix result = new DOMMatrix();
        Window window = this.getWindow();
        result.setParentScope(window);
        result.setPrototype(window.getPrototype(DOMMatrix.class));
        double angleInDegrees = 0.0;
        if (rotZ != null && !JavaScriptEngine.isUndefined(rotZ)) {
            angleInDegrees = JavaScriptEngine.toNumber(rotZ);
        }
        double angleInRadians = Math.toRadians(angleInDegrees);
        double cos = Math.cos(angleInRadians);
        double sin = Math.sin(angleInRadians);
        if (this.is2D_) {
            result.setM11(this.m11_ * cos + this.m21_ * sin);
            result.setM12(this.m12_ * cos + this.m22_ * sin);
            result.setM21(this.m11_ * -sin + this.m21_ * cos);
            result.setM22(this.m12_ * -sin + this.m22_ * cos);
            result.setM41(this.m41_);
            result.setM42(this.m42_);
            result.setIs2D(true);
        } else {
            result.setM11(this.m11_ * cos + this.m21_ * sin);
            result.setM12(this.m12_ * cos + this.m22_ * sin);
            result.setM13(this.m13_ * cos + this.m23_ * sin);
            result.setM14(this.m14_ * cos + this.m24_ * sin);
            result.setM21(this.m11_ * -sin + this.m21_ * cos);
            result.setM22(this.m12_ * -sin + this.m22_ * cos);
            result.setM23(this.m13_ * -sin + this.m23_ * cos);
            result.setM24(this.m14_ * -sin + this.m24_ * cos);
            result.setM31(this.m31_);
            result.setM32(this.m32_);
            result.setM33(this.m33_);
            result.setM34(this.m34_);
            result.setM41(this.m41_);
            result.setM42(this.m42_);
            result.setM43(this.m43_);
            result.setM44(this.m44_);
            result.setIs2D(false);
        }
        return result;
    }

    @JsxFunction
    public DOMMatrixReadOnly rotateAxisAngle(Object xObj, Object yObj, Object zObj, Object alphaObj) {
        double x = 0.0;
        double y = 0.0;
        double z = 1.0;
        double alpha = 0.0;
        if (xObj != null && !JavaScriptEngine.isUndefined(xObj)) {
            x = JavaScriptEngine.toNumber(xObj);
        }
        if (yObj != null && !JavaScriptEngine.isUndefined(yObj)) {
            y = JavaScriptEngine.toNumber(yObj);
        }
        if (zObj != null && !JavaScriptEngine.isUndefined(zObj)) {
            z = JavaScriptEngine.toNumber(zObj);
        }
        if (alphaObj != null && !JavaScriptEngine.isUndefined(alphaObj)) {
            alpha = JavaScriptEngine.toNumber(alphaObj);
        }
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            DOMMatrix result = new DOMMatrix();
            Window window = this.getWindow();
            result.setParentScope(window);
            result.setPrototype(window.getPrototype(DOMMatrix.class));
            return result;
        }
        double length = Math.sqrt(x * x + y * y + z * z);
        x /= length;
        y /= length;
        z /= length;
        double angle2 = Math.toRadians(alpha) / 2.0;
        double sc = Math.sin(angle2) * Math.cos(angle2);
        double sq = Math.pow(Math.sin(angle2), 2.0);
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        DOMMatrix rot = new DOMMatrix();
        rot.setM11(1.0 - 2.0 * (y2 + z2) * sq);
        rot.setM12(2.0 * (x * y * sq + z * sc));
        rot.setM13(2.0 * (x * z * sq - y * sc));
        rot.setM14(0.0);
        rot.setM21(2.0 * (x * y * sq - z * sc));
        rot.setM22(1.0 - 2.0 * (x2 + z2) * sq);
        rot.setM23(2.0 * (y * z * sq + x * sc));
        rot.setM24(0.0);
        rot.setM31(2.0 * (x * z * sq + y * sc));
        rot.setM32(2.0 * (y * z * sq - x * sc));
        rot.setM33(1.0 - 2.0 * (x2 + y2) * sq);
        rot.setM34(0.0);
        rot.setM41(0.0);
        rot.setM42(0.0);
        rot.setM43(0.0);
        rot.setM44(1.0);
        rot.setIs2D(false);
        DOMMatrix multiplied = this.multiply(rot);
        multiplied.setIs2D(this.is2D_ && x == 0.0 && y == 0.0);
        return multiplied;
    }

    @JsxFunction
    public DOMMatrixReadOnly skewX(Object alphaObj) {
        double alpha = 0.0;
        if (alphaObj != null && !JavaScriptEngine.isUndefined(alphaObj)) {
            alpha = JavaScriptEngine.toNumber(alphaObj);
        }
        double angle = Math.toRadians(alpha);
        DOMMatrix rot = new DOMMatrix();
        rot.setM21(Math.tan(angle));
        DOMMatrix multiplied = this.multiply(rot);
        return multiplied;
    }

    @JsxFunction
    public DOMMatrixReadOnly skewY(Object alphaObj) {
        double alpha = 0.0;
        if (alphaObj != null && !JavaScriptEngine.isUndefined(alphaObj)) {
            alpha = JavaScriptEngine.toNumber(alphaObj);
        }
        double angle = Math.toRadians(alpha);
        DOMMatrixReadOnly rot = new DOMMatrixReadOnly();
        rot.m12_ = Math.tan(angle);
        DOMMatrix multiplied = this.multiply(rot);
        return multiplied;
    }

    @JsxFunction
    public DOMMatrixReadOnly translate(Object xObj, Object yObj, Object zObj) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (xObj != null && !JavaScriptEngine.isUndefined(xObj)) {
            x = JavaScriptEngine.toNumber(xObj);
        }
        if (yObj != null && !JavaScriptEngine.isUndefined(yObj)) {
            y = JavaScriptEngine.toNumber(yObj);
        }
        if (zObj != null && !JavaScriptEngine.isUndefined(zObj)) {
            z = JavaScriptEngine.toNumber(zObj);
        }
        DOMMatrixReadOnly translate = new DOMMatrixReadOnly();
        translate.m41_ = x;
        translate.m42_ = y;
        translate.m43_ = z;
        translate.is2D_ = false;
        DOMMatrix multiplied = this.multiply(translate);
        multiplied.setIs2D(this.is2D_ && (zObj == null || JavaScriptEngine.isUndefined(zObj) || z == 0.0));
        return multiplied;
    }

    @JsxFunction
    public NativeFloat32Array toFloat32Array() {
        NativeFloat32Array result = (NativeFloat32Array)JavaScriptEngine.newObject(this.getParentScope(), "Float32Array", new Object[]{16});
        result.setArrayElement(0, this.m11_);
        result.setArrayElement(1, this.m12_);
        result.setArrayElement(2, this.m13_);
        result.setArrayElement(3, this.m14_);
        result.setArrayElement(4, this.m21_);
        result.setArrayElement(5, this.m22_);
        result.setArrayElement(6, this.m23_);
        result.setArrayElement(7, this.m24_);
        result.setArrayElement(8, this.m31_);
        result.setArrayElement(9, this.m32_);
        result.setArrayElement(10, this.m33_);
        result.setArrayElement(11, this.m34_);
        result.setArrayElement(12, this.m41_);
        result.setArrayElement(13, this.m42_);
        result.setArrayElement(14, this.m43_);
        result.setArrayElement(15, this.m44_);
        return result;
    }

    @JsxFunction
    public NativeFloat64Array toFloat64Array() {
        NativeFloat64Array result = (NativeFloat64Array)JavaScriptEngine.newObject(this.getParentScope(), "Float64Array", new Object[]{16});
        result.setArrayElement(0, this.m11_);
        result.setArrayElement(1, this.m12_);
        result.setArrayElement(2, this.m13_);
        result.setArrayElement(3, this.m14_);
        result.setArrayElement(4, this.m21_);
        result.setArrayElement(5, this.m22_);
        result.setArrayElement(6, this.m23_);
        result.setArrayElement(7, this.m24_);
        result.setArrayElement(8, this.m31_);
        result.setArrayElement(9, this.m32_);
        result.setArrayElement(10, this.m33_);
        result.setArrayElement(11, this.m34_);
        result.setArrayElement(12, this.m41_);
        result.setArrayElement(13, this.m42_);
        result.setArrayElement(14, this.m43_);
        result.setArrayElement(15, this.m44_);
        return result;
    }

    @JsxFunction(functionName="toString")
    public String js_toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.is2D_ ? "matrix(" : "matrix3d(");
        DOMMatrixReadOnly.appendDouble(result, this.m11_).append(", ");
        DOMMatrixReadOnly.appendDouble(result, this.m12_).append(", ");
        if (!this.is2D_) {
            DOMMatrixReadOnly.appendDouble(result, this.m13_).append(", ");
            DOMMatrixReadOnly.appendDouble(result, this.m14_).append(", ");
        }
        DOMMatrixReadOnly.appendDouble(result, this.m21_).append(", ");
        DOMMatrixReadOnly.appendDouble(result, this.m22_).append(", ");
        if (!this.is2D_) {
            DOMMatrixReadOnly.appendDouble(result, this.m23_).append(", ");
            DOMMatrixReadOnly.appendDouble(result, this.m24_).append(", ");
            DOMMatrixReadOnly.appendDouble(result, this.m31_).append(", ");
            DOMMatrixReadOnly.appendDouble(result, this.m32_).append(", ");
            DOMMatrixReadOnly.appendDouble(result, this.m33_).append(", ");
            DOMMatrixReadOnly.appendDouble(result, this.m34_).append(", ");
        }
        DOMMatrixReadOnly.appendDouble(result, this.m41_).append(", ");
        DOMMatrixReadOnly.appendDouble(result, this.m42_);
        if (!this.is2D_) {
            result.append(", ");
            DOMMatrixReadOnly.appendDouble(result, this.m43_).append(", ");
            DOMMatrixReadOnly.appendDouble(result, this.m44_);
        }
        result.append(')');
        return result.toString();
    }

    private static StringBuilder appendDouble(StringBuilder builder, double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return builder.append(d);
        }
        if (d % 1.0 == 0.0) {
            return builder.append((int)d);
        }
        return builder.append(d);
    }

    @JsxFunction
    public Object toJSON() {
        String jsonString = "{\"a\":" + this.m11_ + ", \"b\":" + this.m12_ + ", \"c\":" + this.m21_ + ", \"d\":" + this.m22_ + ", \"e\":" + this.m41_ + ", \"f\":" + this.m42_ + ", \"m11\":" + this.m11_ + ", \"m12\":" + this.m12_ + ", \"m13\":" + this.m13_ + ", \"m14\":" + this.m14_ + ", \"m21\":" + this.m21_ + ", \"m22\":" + this.m22_ + ", \"m23\":" + this.m23_ + ", \"m24\":" + this.m24_ + ", \"m31\":" + this.m31_ + ", \"m32\":" + this.m32_ + ", \"m33\":" + this.m33_ + ", \"m34\":" + this.m34_ + ", \"m41\":" + this.m41_ + ", \"m42\":" + this.m42_ + ", \"m43\":" + this.m43_ + ", \"m44\":" + this.m44_ + ", \"is2D\":" + this.is2D_ + ", \"isIdentity\":" + this.getIsIdentity() + '}';
        try {
            return new JsonParser(Context.getCurrentContext(), this.getParentScope()).parseValue(jsonString);
        }
        catch (JsonParser.ParseException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Failed parsingJSON '" + jsonString + "'"), (Throwable)e);
            }
            return null;
        }
    }
}

