/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import hidden.jth.org.apache.commons.lang3.math.NumberUtils;
import java.io.IOException;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlFileInput;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlNumberInput;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlTextInput;
import org.htmlunit.html.impl.SelectableTextInput;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.DOMRectList;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.file.FileList;
import org.htmlunit.javascript.host.html.HTMLCanvasElement;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLFormElement;
import org.htmlunit.javascript.host.html.LabelsNodeList;
import org.htmlunit.javascript.host.html.ValidityState;
import org.htmlunit.util.StringUtils;

@JsxClass(domClass=HtmlInput.class)
public class HTMLInputElement
extends HTMLElement {
    private NodeList labels_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public String getType() {
        return this.getDomNodeOrDie().getType();
    }

    @JsxSetter
    public void setType(String newType) {
        this.getDomNodeOrDie().changeType(newType, false);
    }

    @Override
    @JsxSetter
    public void setValue(Object newValue) {
        if (null == newValue) {
            this.getDomNodeOrDie().setValue("");
            this.getDomNodeOrDie().valueModifiedByJavascript();
            return;
        }
        String val = JavaScriptEngine.toString(newValue);
        if ("file".equals(this.getType())) {
            if (!StringUtils.isEmptyOrNull(val)) {
                throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Failed to set the 'value' property on 'HTMLInputElement'.", 11);
            }
            return;
        }
        this.getDomNodeOrDie().setValue(val);
        this.getDomNodeOrDie().valueModifiedByJavascript();
    }

    @JsxSetter
    public void setChecked(boolean checked) {
        this.getDomNodeOrDie().setChecked(checked);
    }

    @Override
    public HtmlInput getDomNodeOrDie() {
        return (HtmlInput)super.getDomNodeOrDie();
    }

    @JsxGetter
    public boolean isChecked() {
        return this.getDomNodeOrDie().isChecked();
    }

    @JsxFunction
    public void select() {
        HtmlInput input = this.getDomNodeOrDie();
        if (input instanceof HtmlTextInput) {
            ((HtmlTextInput)input).select();
        }
    }

    @JsxGetter
    public String getDefaultValue() {
        return this.getDomNodeOrDie().getDefaultValue();
    }

    @JsxSetter
    public void setDefaultValue(String defaultValue) {
        this.getDomNodeOrDie().setDefaultValue(defaultValue);
    }

    @JsxGetter
    public boolean isDefaultChecked() {
        return this.getDomNodeOrDie().isDefaultChecked();
    }

    @JsxSetter
    public void setDefaultChecked(boolean defaultChecked) {
        this.getDomNodeOrDie().setDefaultChecked(defaultChecked);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public int getTextLength() {
        return this.getValue().length();
    }

    @JsxGetter
    public Integer getSelectionStart() {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equals(this.getType())) {
                return null;
            }
            return ((SelectableTextInput)((Object)dom)).getSelectionStart();
        }
        return null;
    }

    @JsxSetter
    public void setSelectionStart(int start) {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equals(this.getType())) {
                throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Failed to set the 'selectionStart' propertyfrom 'HTMLInputElement': The input element's type ('number') does not support selection.", 11);
            }
            ((SelectableTextInput)((Object)dom)).setSelectionStart(start);
            return;
        }
        throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Failed to set the 'selectionStart' property from 'HTMLInputElement': The input element's type (" + this.getType() + ") does not support selection.", 11);
    }

    @JsxGetter
    public Integer getSelectionEnd() {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equals(this.getType())) {
                return null;
            }
            return ((SelectableTextInput)((Object)dom)).getSelectionEnd();
        }
        return null;
    }

    @JsxSetter
    public void setSelectionEnd(int end) {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equals(this.getType())) {
                throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Failed to set the 'selectionEnd' propertyfrom 'HTMLInputElement': The input element's type ('number') does not support selection.", 11);
            }
            ((SelectableTextInput)((Object)dom)).setSelectionEnd(end);
            return;
        }
        throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Failed to set the 'selectionEnd' property from 'HTMLInputElement': The input element's type (" + this.getType() + ") does not support selection.", 11);
    }

    @JsxGetter
    public int getMaxLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("maxLength");
        return NumberUtils.toInt(attrValue, -1);
    }

    @JsxSetter
    public void setMaxLength(int length) {
        this.getDomNodeOrDie().setMaxLength(length);
    }

    @JsxGetter
    public int getMinLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("minLength");
        return NumberUtils.toInt(attrValue, -1);
    }

    @JsxSetter
    public void setMinLength(int length) {
        this.getDomNodeOrDie().setMinLength(length);
    }

    @JsxGetter
    public String getMin() {
        return this.getDomNodeOrDie().getAttributeDirect("min");
    }

    @JsxSetter
    public void setMin(String min) {
        this.getDomNodeOrDie().setAttribute("min", min);
    }

    @JsxGetter
    public String getMax() {
        return this.getDomNodeOrDie().getAttributeDirect("max");
    }

    @JsxSetter
    public void setMax(String max) {
        this.getDomNodeOrDie().setAttribute("max", max);
    }

    @JsxGetter
    public String getStep() {
        return this.getDomNodeOrDie().getAttributeDirect("step");
    }

    @JsxSetter
    public void setStep(String step) {
        this.getDomNodeOrDie().setAttribute("step", step);
    }

    @JsxGetter
    public boolean isReadOnly() {
        return this.getDomNodeOrDie().isReadOnly();
    }

    @JsxSetter
    public void setReadOnly(boolean readOnly) {
        this.getDomNodeOrDie().setReadOnly(readOnly);
    }

    @JsxFunction
    public void setSelectionRange(int start, int end) {
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    @JsxGetter
    public String getAlt() {
        return this.getDomNodeOrDie().getAttributeDirect("alt");
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @JsxGetter
    public String getSrc() {
        return this.getDomNodeOrDie().getSrc();
    }

    @JsxSetter
    public void setSrc(String src) {
        this.getDomNodeOrDie().setSrcAttribute(src);
    }

    @Override
    @JsxGetter
    public String getValue() {
        String valueAttr;
        HtmlInput htmlInput = this.getDomNodeOrDie();
        if (htmlInput instanceof HtmlNumberInput && !(valueAttr = htmlInput.getValue()).isEmpty()) {
            if (StringUtils.equalsChar('-', valueAttr) || StringUtils.equalsChar('+', valueAttr)) {
                return "";
            }
            int lastPos = valueAttr.length() - 1;
            if (lastPos >= 0 && valueAttr.charAt(lastPos) == '.' && htmlInput.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_DOT_AT_END_IS_DOUBLE)) {
                return "";
            }
            try {
                Double.parseDouble(valueAttr);
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return htmlInput.getValue();
    }

    @Override
    public String getAttribute(String attributeName) {
        String superAttribute = super.getAttribute(attributeName);
        if ("value".equalsIgnoreCase(attributeName)) {
            if ((superAttribute == null || !superAttribute.isEmpty()) && this.getDefaultValue().isEmpty()) {
                return null;
            }
            if (!"file".equals(this.getType())) {
                return this.getDefaultValue();
            }
        }
        return superAttribute;
    }

    @Override
    public void click() throws IOException {
        HtmlInput domNode = this.getDomNodeOrDie();
        boolean originalState = domNode.isChecked();
        domNode.click(false, false, false, false, false, true, false);
        boolean newState = domNode.isChecked();
        if (originalState != newState && (domNode instanceof HtmlRadioButtonInput || domNode instanceof HtmlCheckBoxInput)) {
            domNode.fireEvent("change");
        }
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }

    @JsxGetter
    public boolean isRequired() {
        return this.getDomNodeOrDie().isRequired();
    }

    @JsxSetter
    public void setRequired(boolean required) {
        this.getDomNodeOrDie().setRequired(required);
    }

    @JsxGetter
    public String getSize() {
        return this.getDomNodeOrDie().getSize();
    }

    @JsxSetter
    public void setSize(String size) {
        this.getDomNodeOrDie().setSize(size);
    }

    @JsxGetter
    public String getAccept() {
        return this.getDomNodeOrDie().getAccept();
    }

    @JsxSetter
    public void setAccept(String accept) {
        this.getDomNodeOrDie().setAccept(accept);
    }

    @JsxGetter
    public String getAutocomplete() {
        return this.getDomNodeOrDie().getAutocomplete();
    }

    @JsxSetter
    public void setAutocomplete(String autocomplete) {
        this.getDomNodeOrDie().setAutocomplete(autocomplete);
    }

    @JsxGetter
    public FileList getFiles() {
        HtmlInput htmlInput = this.getDomNodeOrDie();
        if (htmlInput instanceof HtmlFileInput) {
            FileList list = new FileList(((HtmlFileInput)htmlInput).getFiles());
            list.setParentScope(this.getParentScope());
            list.setPrototype(this.getPrototype(list.getClass()));
            return list;
        }
        return null;
    }

    @JsxGetter
    public String getPlaceholder() {
        return this.getDomNodeOrDie().getPlaceholder();
    }

    @JsxSetter
    public void setPlaceholder(String placeholder) {
        this.getDomNodeOrDie().setPlaceholder(placeholder);
    }

    @JsxGetter
    public int getWidth() {
        String value = this.getDomNodeOrDie().getAttributeDirect("width");
        Integer intValue = HTMLCanvasElement.getValue(value);
        if (intValue != null) {
            return intValue;
        }
        return 0;
    }

    @JsxSetter
    public void setWidth(int width) {
        this.getDomNodeOrDie().setAttribute("width", Integer.toString(width));
    }

    @JsxGetter
    public int getHeight() {
        String value = this.getDomNodeOrDie().getAttributeDirect("height");
        Integer intValue = HTMLCanvasElement.getValue(value);
        if (intValue != null) {
            return intValue;
        }
        return 0;
    }

    @JsxSetter
    public void setHeight(int height) {
        this.getDomNodeOrDie().setAttribute("height", Integer.toString(height));
    }

    @JsxGetter
    public NodeList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsNodeList(this.getDomNodeOrDie());
        }
        return this.labels_;
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }

    @Override
    @JsxGetter
    public String getName() {
        return super.getName();
    }

    @Override
    @JsxSetter
    public void setName(String newName) {
        super.setName(newName);
    }

    @Override
    @JsxGetter
    public boolean isDisabled() {
        return super.isDisabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }

    @Override
    @JsxGetter
    public HTMLFormElement getForm() {
        return super.getForm();
    }

    @JsxGetter
    public ValidityState getValidity() {
        ValidityState validityState = new ValidityState();
        validityState.setPrototype(this.getPrototype(validityState.getClass()));
        validityState.setParentScope(this.getParentScope());
        validityState.setDomNode(this.getDomNodeOrDie());
        return validityState;
    }

    @JsxGetter
    public boolean isWillValidate() {
        return this.getDomNodeOrDie().willValidate();
    }

    @JsxFunction
    public void setCustomValidity(String message) {
        this.getDomNodeOrDie().setCustomValidity(message);
    }

    @JsxGetter
    public boolean isFormNoValidate() {
        return this.getDomNodeOrDie().isFormNoValidate();
    }

    @JsxSetter
    public void setFormNoValidate(boolean value) {
        this.getDomNodeOrDie().setFormNoValidate(value);
    }

    @Override
    public DOMRectList getClientRects() {
        if ("hidden".equals(this.getType())) {
            Window w = this.getWindow();
            DOMRectList rectList = new DOMRectList();
            rectList.setParentScope(w);
            rectList.setPrototype(this.getPrototype(rectList.getClass()));
            return rectList;
        }
        return super.getClientRects();
    }
}

