/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.media;

import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.NativePromise;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.DOMException;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.media.AudioBuffer;
import org.htmlunit.javascript.host.media.AudioBufferSourceNode;
import org.htmlunit.javascript.host.media.GainNode;

@JsxClass
public class BaseAudioContext
extends EventTarget {
    @Override
    @JsxConstructor
    public void jsConstructor() {
        throw JavaScriptEngine.typeErrorIllegalConstructor();
    }

    @JsxFunction
    public AudioBufferSourceNode createBufferSource() {
        AudioBufferSourceNode node = new AudioBufferSourceNode();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(node.getClass()));
        return node;
    }

    @JsxFunction
    public AudioBuffer createBuffer() {
        AudioBuffer node = new AudioBuffer();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(node.getClass()));
        return node;
    }

    @JsxFunction
    public GainNode createGain() {
        GainNode node = new GainNode();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(node.getClass()));
        node.jsConstructor(this);
        return node;
    }

    @JsxFunction
    public NativePromise decodeAudioData(NativeArrayBuffer buffer, Function success, final Function error) {
        Window window = this.getWindow();
        final HtmlPage owningPage = (HtmlPage)window.getDocument().getPage();
        final JavaScriptEngine jsEngine = (JavaScriptEngine)window.getWebWindow().getWebClient().getJavaScriptEngine();
        final DOMException domException = new DOMException("decodeAudioData not supported by HtmlUnit", 9);
        domException.setParentScope(window);
        domException.setPrototype(window.getPrototype(DOMException.class));
        if (error != null) {
            jsEngine.addPostponedAction(new PostponedAction(owningPage, "BaseAudioContext.decodeAudioData"){

                @Override
                public void execute() {
                    jsEngine.callFunction(owningPage, error, BaseAudioContext.this.getParentScope(), BaseAudioContext.this, new Object[]{domException});
                }
            });
            return null;
        }
        return this.setupRejectedPromise(() -> domException);
    }
}

