/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlunit.html.impl.Color;

public final class StringUtils {
    private static final Pattern HEX_COLOR = Pattern.compile("#([\\da-fA-F]{3}|[\\da-fA-F]{6})");
    private static final Pattern RGB_COLOR = Pattern.compile("rgb\\(\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*\\)");
    private static final Pattern RGBA_COLOR = Pattern.compile("rgba\\(\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*,\\s*((0?.[1-9])|[01])\\s*\\)");
    private static final Pattern HSL_COLOR = Pattern.compile("hsl\\(\\s*((0|[1-9]\\d?|[12]\\d\\d?|3[0-5]\\d)(.\\d*)?)\\s*,\\s*((0|[1-9]\\d?|100)(.\\d*)?)%\\s*,\\s*((0|[1-9]\\d?|100)(.\\d*)?)%\\s*\\)");
    private static final Pattern ILLEGAL_FILE_NAME_CHARS = Pattern.compile("\\\\|/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}");
    private static final Map<String, String> CAMELIZE_CACHE = new ConcurrentHashMap<String, String>();

    private StringUtils() {
    }

    public static boolean isEmptyString(CharSequence s) {
        return s != null && s.length() == 0;
    }

    public static boolean isEmptyOrNull(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static <T extends CharSequence> T defaultIfEmptyOrNull(T s, T defaultString) {
        return StringUtils.isEmptyOrNull(s) ? defaultString : s;
    }

    public static boolean isBlank(CharSequence s) {
        if (s == null) {
            return true;
        }
        int length = s.length();
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence s) {
        if (s == null) {
            return false;
        }
        int length = s.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsChar(char expected, CharSequence s) {
        return s != null && s.length() == 1 && expected == s.charAt(0);
    }

    public static boolean startsWithIgnoreCase(String s, String expectedStart) {
        if (expectedStart == null || expectedStart.length() == 0) {
            throw new IllegalArgumentException("Expected start string can't be null or empty");
        }
        if (s == null) {
            return false;
        }
        if (s == expectedStart) {
            return true;
        }
        return s.regionMatches(true, 0, expectedStart, 0, expectedStart.length());
    }

    public static boolean endsWithIgnoreCase(String s, String expectedEnd) {
        if (expectedEnd == null) {
            throw new IllegalArgumentException("Expected end string can't be null or empty");
        }
        int expectedEndLength = expectedEnd.length();
        if (expectedEndLength == 0) {
            throw new IllegalArgumentException("Expected end string can't be null or empty");
        }
        if (s == null) {
            return false;
        }
        if (s == expectedEnd) {
            return true;
        }
        return s.regionMatches(true, s.length() - expectedEndLength, expectedEnd, 0, expectedEndLength);
    }

    public static boolean containsIgnoreCase(String s, String expected) {
        if (expected == null) {
            throw new IllegalArgumentException("Expected string can't be null or empty");
        }
        int expectedLength = expected.length();
        if (expectedLength == 0) {
            throw new IllegalArgumentException("Expected string can't be null or empty");
        }
        if (s == null) {
            return false;
        }
        if (s == expected) {
            return true;
        }
        int max = s.length() - expectedLength;
        for (int i = 0; i <= max; ++i) {
            if (!s.regionMatches(true, i, expected, 0, expectedLength)) continue;
            return true;
        }
        return false;
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        int index;
        char ch;
        int i;
        if (StringUtils.isEmptyOrNull(str) || StringUtils.isEmptyOrNull(searchChars)) {
            return str;
        }
        int replaceCharsLength = replaceChars == null ? 0 : replaceChars.length();
        int strLength = str.length();
        StringBuilder buf = null;
        for (i = 0; i < strLength; ++i) {
            ch = str.charAt(i);
            index = searchChars.indexOf(ch);
            if (index == -1) continue;
            buf = new StringBuilder(strLength);
            buf.append(str, 0, i);
            if (index >= replaceCharsLength) break;
            buf.append(replaceChars.charAt(index));
            break;
        }
        if (buf == null) {
            return str;
        }
        ++i;
        while (i < strLength) {
            ch = str.charAt(i);
            index = searchChars.indexOf(ch);
            if (index != -1) {
                if (index < replaceCharsLength) {
                    buf.append(replaceChars.charAt(index));
                }
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String escapeXmlChars(String s) {
        return hidden.jth.org.apache.commons.lang3.StringUtils.replaceEach(s, new String[]{"&", "<", ">"}, new String[]{"&amp;", "&lt;", "&gt;"});
    }

    public static String escapeXml(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder escaped = null;
        boolean offset = false;
        int max = text.length();
        int readOffset = 0;
        for (int i = 0; i < max; ++i) {
            int codepoint = Character.codePointAt(text, i);
            boolean codepointValid = StringUtils.supportedByXML10(codepoint);
            if (codepointValid && codepoint != 60 && codepoint != 62 && codepoint != 38 && codepoint != 39 && codepoint != 34) continue;
            if (escaped == null) {
                escaped = new StringBuilder(max);
            }
            if (i > readOffset) {
                escaped.append(text, readOffset, i);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i;
            }
            readOffset = i + 1;
            if (!codepointValid) continue;
            if (codepoint == 60) {
                escaped.append("&lt;");
                continue;
            }
            if (codepoint == 62) {
                escaped.append("&gt;");
                continue;
            }
            if (codepoint == 38) {
                escaped.append("&amp;");
                continue;
            }
            if (codepoint == 39) {
                escaped.append("&apos;");
                continue;
            }
            if (codepoint != 34) continue;
            escaped.append("&quot;");
        }
        if (escaped == null) {
            return text;
        }
        if (max > readOffset) {
            escaped.append(text, readOffset, max);
        }
        return escaped.toString();
    }

    public static String escapeXmlAttributeValue(String attValue) {
        if (attValue == null) {
            return null;
        }
        StringBuilder escaped = null;
        boolean offset = false;
        int max = attValue.length();
        int readOffset = 0;
        for (int i = 0; i < max; ++i) {
            int codepoint = Character.codePointAt(attValue, i);
            boolean codepointValid = StringUtils.supportedByXML10(codepoint);
            if (codepointValid && codepoint != 60 && codepoint != 38 && codepoint != 34) continue;
            if (escaped == null) {
                escaped = new StringBuilder(max);
            }
            if (i > readOffset) {
                escaped.append(attValue, readOffset, i);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i;
            }
            readOffset = i + 1;
            if (!codepointValid) continue;
            if (codepoint == 60) {
                escaped.append("&lt;");
                continue;
            }
            if (codepoint == 38) {
                escaped.append("&amp;");
                continue;
            }
            if (codepoint != 34) continue;
            escaped.append("&quot;");
        }
        if (escaped == null) {
            return attValue;
        }
        if (max > readOffset) {
            escaped.append(attValue, readOffset, max);
        }
        return escaped.toString();
    }

    private static boolean supportedByXML10(int codepoint) {
        if (codepoint < 32) {
            return codepoint == 9 || codepoint == 10 || codepoint == 13;
        }
        if (codepoint <= 55295) {
            return true;
        }
        if (codepoint < 57344) {
            return false;
        }
        if (codepoint <= 65533) {
            return true;
        }
        if (codepoint < 65536) {
            return false;
        }
        if (codepoint <= 0x10FFFF) {
            return true;
        }
        return true;
    }

    public static int indexOf(String s, char searchChar, int beginIndex, int endIndex) {
        for (int i = beginIndex; i < endIndex; ++i) {
            if (s.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static Color asColorHexadecimal(String token) {
        if (token == null) {
            return null;
        }
        Matcher tmpMatcher = HEX_COLOR.matcher(token);
        boolean tmpFound = tmpMatcher.matches();
        if (!tmpFound) {
            return null;
        }
        String tmpHex = tmpMatcher.group(1);
        if (tmpHex.length() == 6) {
            int tmpRed = Integer.parseInt(tmpHex.substring(0, 2), 16);
            int tmpGreen = Integer.parseInt(tmpHex.substring(2, 4), 16);
            int tmpBlue = Integer.parseInt(tmpHex.substring(4, 6), 16);
            return new Color(tmpRed, tmpGreen, tmpBlue);
        }
        int tmpRed = Integer.parseInt(tmpHex.substring(0, 1) + tmpHex.substring(0, 1), 16);
        int tmpGreen = Integer.parseInt(tmpHex.substring(1, 2) + tmpHex.substring(1, 2), 16);
        int tmpBlue = Integer.parseInt(tmpHex.substring(2, 3) + tmpHex.substring(2, 3), 16);
        return new Color(tmpRed, tmpGreen, tmpBlue);
    }

    public static Color findColorRGB(String token) {
        if (token == null) {
            return null;
        }
        Matcher tmpMatcher = RGB_COLOR.matcher(token);
        if (!tmpMatcher.find()) {
            return null;
        }
        int tmpRed = Integer.parseInt(tmpMatcher.group(1));
        int tmpGreen = Integer.parseInt(tmpMatcher.group(2));
        int tmpBlue = Integer.parseInt(tmpMatcher.group(3));
        return new Color(tmpRed, tmpGreen, tmpBlue);
    }

    public static Color findColorRGBA(String token) {
        if (token == null) {
            return null;
        }
        Matcher tmpMatcher = RGBA_COLOR.matcher(token);
        if (!tmpMatcher.find()) {
            return null;
        }
        int tmpRed = Integer.parseInt(tmpMatcher.group(1));
        int tmpGreen = Integer.parseInt(tmpMatcher.group(2));
        int tmpBlue = Integer.parseInt(tmpMatcher.group(3));
        int tmpAlpha = (int)(Float.parseFloat(tmpMatcher.group(4)) * 255.0f);
        return new Color(tmpRed, tmpGreen, tmpBlue, tmpAlpha);
    }

    public static Color findColorHSL(String token) {
        if (token == null) {
            return null;
        }
        Matcher tmpMatcher = HSL_COLOR.matcher(token);
        if (!tmpMatcher.find()) {
            return null;
        }
        float tmpHue = Float.parseFloat(tmpMatcher.group(1)) / 360.0f;
        float tmpSaturation = Float.parseFloat(tmpMatcher.group(4)) / 100.0f;
        float tmpLightness = Float.parseFloat(tmpMatcher.group(7)) / 100.0f;
        return StringUtils.hslToRgb(tmpHue, tmpSaturation, tmpLightness);
    }

    private static Color hslToRgb(float h, float s, float l) {
        if (s == 0.0f) {
            return new Color(StringUtils.to255(l), StringUtils.to255(l), StringUtils.to255(l));
        }
        float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
        float p = 2.0f * l - q;
        float r = StringUtils.hueToRgb(p, q, h + 0.33333334f);
        float g = StringUtils.hueToRgb(p, q, h);
        float b = StringUtils.hueToRgb(p, q, h - 0.33333334f);
        return new Color(StringUtils.to255(r), StringUtils.to255(g), StringUtils.to255(b));
    }

    private static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    private static int to255(float value) {
        return (int)Math.min(255.0f, 256.0f * value);
    }

    public static String formatColor(Color color) {
        return "rgb(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    public static String sanitizeForAppendReplacement(String toSanitize) {
        return hidden.jth.org.apache.commons.lang3.StringUtils.replaceEach(toSanitize, new String[]{"\\", "$"}, new String[]{"\\\\", "\\$"});
    }

    public static String sanitizeForFileName(String toSanitize) {
        return ILLEGAL_FILE_NAME_CHARS.matcher(toSanitize).replaceAll("_");
    }

    public static String cssCamelize(String string) {
        if (string == null) {
            return null;
        }
        String result = CAMELIZE_CACHE.get(string);
        if (null != result) {
            return result;
        }
        int pos = string.indexOf(45);
        if (pos == -1 || pos == string.length() - 1) {
            CAMELIZE_CACHE.put(string, string);
            return string;
        }
        StringBuilder builder = new StringBuilder(string);
        builder.deleteCharAt(pos);
        builder.setCharAt(pos, Character.toUpperCase(builder.charAt(pos)));
        for (int i = pos + 1; i < builder.length() - 1; ++i) {
            if (builder.charAt(i) != '-') continue;
            builder.deleteCharAt(i);
            builder.setCharAt(i, Character.toUpperCase(builder.charAt(i)));
        }
        result = builder.toString();
        CAMELIZE_CACHE.put(string, result);
        return result;
    }

    public static String toRootLowerCase(String s) {
        return s == null ? null : s.toLowerCase(Locale.ROOT);
    }

    public static String cssDeCamelize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (Character.isUpperCase(ch)) {
                builder.append('-').append(Character.toLowerCase(ch));
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    public static byte[] toByteArray(String content, Charset charset) {
        if (content == null || content.isEmpty()) {
            return new byte[0];
        }
        return content.getBytes(charset);
    }

    public static String[] splitAtJavaWhitespace(String str) {
        String[] parts = hidden.jth.org.apache.commons.lang3.StringUtils.split(str);
        if (parts == null) {
            return new String[0];
        }
        return parts;
    }

    public static String[] splitAtBlank(String str) {
        String[] parts = hidden.jth.org.apache.commons.lang3.StringUtils.split(str, ' ');
        if (parts == null) {
            return new String[0];
        }
        return parts;
    }

    public static String[] splitAtComma(String str) {
        String[] parts = hidden.jth.org.apache.commons.lang3.StringUtils.split(str, ',');
        if (parts == null) {
            return new String[0];
        }
        return parts;
    }

    public static String[] splitAtCommaOrBlank(String str) {
        String[] parts = hidden.jth.org.apache.commons.lang3.StringUtils.split(str, ", ");
        if (parts == null) {
            return new String[0];
        }
        return parts;
    }

    public static String substringBefore(String str, String find) {
        if (StringUtils.isEmptyOrNull(find)) {
            throw new IllegalArgumentException("'find' string parameter has to be not empty and not null");
        }
        if (StringUtils.isEmptyString(str)) {
            return str;
        }
        int pos = str.indexOf(find);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }
}

