/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DoTypeProcessor;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextSelectionDelegate;
import com.gargoylesoftware.htmlunit.html.impl.SelectionDelegate;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlNumberInput
extends HtmlInput
implements SelectableTextInput,
LabelableElement {
    private static final char[] VALID_INT_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-'};
    private SelectableTextSelectionDelegate selectionDelegate_ = new SelectableTextSelectionDelegate(this);
    private DoTypeProcessor doTypeProcessor_ = new DoTypeProcessor(this);

    HtmlNumberInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        String value = this.getValueAttribute();
        if (!value.isEmpty()) {
            try {
                Double.parseDouble(value.trim());
            }
            catch (NumberFormatException e) {
                this.setValueAttribute("");
            }
        }
    }

    @Override
    protected void doType(char c, boolean lastType) {
        this.doTypeProcessor_.doType(this.getValueAttribute(), (SelectionDelegate)this.selectionDelegate_, c, (HtmlElement)this, lastType);
    }

    @Override
    protected void doType(int keyCode, boolean lastType) {
        this.doTypeProcessor_.doType(this.getValueAttribute(), (SelectionDelegate)this.selectionDelegate_, keyCode, (HtmlElement)this, lastType);
    }

    @Override
    protected void typeDone(String newValue, boolean notifyAttributeChangeListeners) {
        if (newValue.length() <= this.getMaxLength()) {
            if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_ACCEPT_ALL)) {
                this.setAttributeNS(null, "value", newValue, notifyAttributeChangeListeners, false);
                return;
            }
            if (StringUtils.isBlank(newValue) || "-".equals(newValue) || "+".equals(newValue)) {
                this.setAttributeNS(null, "value", newValue, notifyAttributeChangeListeners, false);
                return;
            }
            String parseValue = newValue;
            int lastPos = parseValue.length() - 1;
            if (parseValue.charAt(lastPos) == '.') {
                parseValue = parseValue.substring(0, lastPos);
            }
            try {
                Double.parseDouble(parseValue);
                this.setAttributeNS(null, "value", newValue, notifyAttributeChangeListeners, false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    protected boolean isSubmittableByEnter() {
        return true;
    }

    @Override
    public void select() {
        this.selectionDelegate_.select();
    }

    @Override
    public String getSelectedText() {
        return this.selectionDelegate_.getSelectedText();
    }

    @Override
    public String getText() {
        return this.getValueAttribute();
    }

    @Override
    public void setText(String text) {
        this.setValueAttribute(text);
    }

    @Override
    public int getSelectionStart() {
        return this.selectionDelegate_.getSelectionStart();
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        this.selectionDelegate_.setSelectionStart(selectionStart);
    }

    @Override
    public int getSelectionEnd() {
        return this.selectionDelegate_.getSelectionEnd();
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        this.selectionDelegate_.setSelectionEnd(selectionEnd);
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        Page page;
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
        if ("value".equals(qualifiedName) && (page = this.getPage()) != null && ((SgmlPage)page).isHtmlPage()) {
            int pos = 0;
            if (!this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_MOVE_SELECTION_TO_START)) {
                pos = attributeValue.length();
            }
            this.setSelectionStart(pos);
            this.setSelectionEnd(pos);
        }
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        boolean modifyValue = this.getValueAttribute().equals(this.getDefaultValue());
        this.setDefaultValue(defaultValue, modifyValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValueAttribute(String newValue) {
        try {
            if (!newValue.isEmpty()) {
                String lang = ((SgmlPage)this.getPage()).getWebClient().getBrowserVersion().getBrowserLanguage();
                NumberFormat format = NumberFormat.getInstance(Locale.forLanguageTag(lang));
                format.parse(newValue);
            }
            super.setValueAttribute(newValue);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setSelectionEnd(0);
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlNumberInput newnode = (HtmlNumberInput)super.cloneNode(deep);
        newnode.selectionDelegate_ = new SelectableTextSelectionDelegate(newnode);
        newnode.doTypeProcessor_ = new DoTypeProcessor(newnode);
        return newnode;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        String valueAttr = this.getValueAttribute();
        if (!valueAttr.isEmpty()) {
            double value;
            block20: {
                if ("-".equals(valueAttr) || "+".equals(valueAttr)) {
                    return false;
                }
                if (this.getStep().isEmpty()) {
                    String val = valueAttr;
                    int lastPos = val.length() - 1;
                    if (lastPos >= 0 && val.charAt(lastPos) == '.') {
                        if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_DOT_AT_END_IS_DOUBLE)) {
                            return false;
                        }
                        val = val.substring(0, lastPos);
                    }
                    if (!StringUtils.containsOnly((CharSequence)val, VALID_INT_CHARS)) {
                        return false;
                    }
                }
                try {
                    value = Double.parseDouble(valueAttr);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (!this.getMin().isEmpty()) {
                    try {
                        double min = Double.parseDouble(this.getMin());
                        if (value < min) {
                            return false;
                        }
                        if (this.getStep().isEmpty()) break block20;
                        try {
                            double step = Double.parseDouble(this.getStep());
                            if (Math.abs((value - min) % step) > 1.0E-6) {
                                return false;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    catch (NumberFormatException min) {
                        // empty catch block
                    }
                }
            }
            if (!this.getMax().isEmpty()) {
                try {
                    double max = Double.parseDouble(this.getMax());
                    if (value > max) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return true;
    }
}

