/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.file;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.LambdaConstructor;
import net.sourceforge.htmlunit.corejs.javascript.LambdaFunction;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class Blob
extends SimpleScriptable {
    private static final String OPTIONS_TYPE_NAME = "type";
    private static final String OPTIONS_TYPE_DEFAULT = "";
    private static final String OPTIONS_LASTMODIFIED = "lastModified";
    private Backend backend_;

    protected static String extractFileTypeOrDefault(ScriptableObject properties) {
        if (properties == null || Undefined.isUndefined(properties)) {
            return OPTIONS_TYPE_DEFAULT;
        }
        Object optionsType = properties.get(OPTIONS_TYPE_NAME, (Scriptable)properties);
        if (optionsType != null && properties != Scriptable.NOT_FOUND && !Undefined.isUndefined(optionsType)) {
            return Context.toString(optionsType);
        }
        return OPTIONS_TYPE_DEFAULT;
    }

    protected static long extractLastModifiedOrDefault(ScriptableObject properties) {
        if (properties == null || Undefined.isUndefined(properties)) {
            return System.currentTimeMillis();
        }
        Object optionsType = properties.get(OPTIONS_LASTMODIFIED, (Scriptable)properties);
        if (optionsType != null && properties != Scriptable.NOT_FOUND && !Undefined.isUndefined(optionsType)) {
            try {
                return Long.parseLong(Context.toString(optionsType));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }

    public Blob() {
    }

    @JsxConstructor
    public Blob(NativeArray fileBits, ScriptableObject properties) {
        NativeArray nativeBits = fileBits;
        if (Undefined.isUndefined(fileBits)) {
            nativeBits = null;
        }
        this.setBackend(InMemoryBackend.create(nativeBits, null, Blob.extractFileTypeOrDefault(properties), Blob.extractLastModifiedOrDefault(properties)));
    }

    public Blob(byte[] bits, String contentType) {
        this.setBackend(new InMemoryBackend(bits, null, contentType, -1L));
    }

    @JsxGetter
    public long getSize() {
        return this.getBackend().getSize();
    }

    @JsxGetter
    public String getType() {
        return this.getBackend().getType(this.getBrowserVersion());
    }

    @JsxFunction
    public Blob slice(Object start, Object end, Object contentType) {
        Blob blob = new Blob();
        blob.setParentScope(this.getParentScope());
        blob.setPrototype(this.getPrototype(Blob.class));
        int size = (int)this.getSize();
        int usedStart = 0;
        int usedEnd = size;
        if (start != null && !Undefined.isUndefined(start)) {
            usedStart = ScriptRuntime.toInt32(start);
            if (usedStart < 0) {
                usedStart = size + usedStart;
            }
            usedStart = Math.max(0, usedStart);
        }
        if (end != null && !Undefined.isUndefined(end)) {
            usedEnd = ScriptRuntime.toInt32(end);
            if (usedEnd < 0) {
                usedEnd = size + usedEnd;
            }
            usedEnd = Math.min(size, usedEnd);
        }
        String usedContentType = OPTIONS_TYPE_DEFAULT;
        if (contentType != null && !Undefined.isUndefined(contentType)) {
            usedContentType = ScriptRuntime.toString(contentType).toLowerCase(Locale.ROOT);
        }
        if (usedEnd <= usedStart || (long)usedStart >= this.getSize()) {
            blob.setBackend(new InMemoryBackend(new byte[0], null, usedContentType, 0L));
            return blob;
        }
        blob.setBackend(new InMemoryBackend(this.getBackend().getBytes(usedStart, usedEnd), null, usedContentType, 0L));
        return blob;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object text() {
        Scriptable scope = ScriptableObject.getTopLevelScope(this);
        LambdaConstructor ctor = (LambdaConstructor)Blob.getProperty(scope, "Promise");
        try {
            LambdaFunction resolve = (LambdaFunction)Blob.getProperty((Scriptable)ctor, "resolve");
            return resolve.call(Context.getCurrentContext(), this, ctor, new Object[]{this.getBackend().getText()});
        }
        catch (IOException e) {
            LambdaFunction reject = (LambdaFunction)Blob.getProperty((Scriptable)ctor, "reject");
            return reject.call(Context.getCurrentContext(), this, ctor, new Object[]{e.getMessage()});
        }
    }

    public byte[] getBytes() {
        return this.getBackend().getBytes(0, (int)this.getBackend().getSize());
    }

    public void fillRequest(WebRequest webRequest) {
        boolean contentTypeDefinedByCaller;
        webRequest.setRequestBody(new String(this.getBytes(), StandardCharsets.UTF_8));
        boolean bl = contentTypeDefinedByCaller = webRequest.getAdditionalHeader("Content-Type") != null;
        if (!contentTypeDefinedByCaller && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_SEND_IGNORES_BLOB_MIMETYPE_AS_CONTENTTYPE)) {
            String mimeType = this.getType();
            if (StringUtils.isNotBlank(mimeType)) {
                webRequest.setAdditionalHeader("Content-Type", mimeType);
            }
            webRequest.setEncodingType(null);
        }
    }

    protected Backend getBackend() {
        return this.backend_;
    }

    protected void setBackend(Backend backend) {
        this.backend_ = backend;
    }

    protected static class InMemoryBackend
    extends Backend {
        private final String fileName_;
        private final String type_;
        private final long lastModified_;
        private final byte[] bytes_;

        protected InMemoryBackend(byte[] bytes, String fileName, String type, long lastModified) {
            this.fileName_ = fileName;
            this.type_ = type;
            this.lastModified_ = lastModified;
            this.bytes_ = bytes;
        }

        protected static InMemoryBackend create(NativeArray fileBits, String fileName, String type, long lastModified) {
            if (fileBits == null) {
                return new InMemoryBackend(new byte[0], fileName, type, lastModified);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (long i = 0L; i < fileBits.getLength(); ++i) {
                byte[] bytes;
                byte[] bytes2;
                Object fileBit = fileBits.get(i);
                if (fileBit instanceof NativeArrayBuffer) {
                    bytes2 = ((NativeArrayBuffer)fileBit).getBuffer();
                    out.write(bytes2, 0, bytes2.length);
                    continue;
                }
                if (fileBit instanceof NativeArrayBufferView) {
                    bytes2 = ((NativeArrayBufferView)fileBit).getBuffer().getBuffer();
                    out.write(bytes2, 0, bytes2.length);
                    continue;
                }
                if (fileBit instanceof Blob) {
                    Blob blob = (Blob)fileBit;
                    bytes = blob.getBackend().getBytes(0, (int)blob.getSize());
                    out.write(bytes, 0, bytes.length);
                    continue;
                }
                String bits = Context.toString(fileBits.get(i));
                bytes = bits.getBytes(StandardCharsets.UTF_8);
                out.write(bytes, 0, bytes.length);
            }
            return new InMemoryBackend(out.toByteArray(), fileName, type, lastModified);
        }

        @Override
        public String getName() {
            return this.fileName_;
        }

        @Override
        public long getLastModified() {
            return this.lastModified_;
        }

        @Override
        public long getSize() {
            return this.bytes_.length;
        }

        @Override
        public String getType(BrowserVersion browserVersion) {
            if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_BLOB_CONTENT_TYPE_CASE_SENSITIVE)) {
                return this.type_.toLowerCase(Locale.ROOT);
            }
            return this.type_;
        }

        @Override
        public String getText() throws IOException {
            return new String(this.bytes_, StandardCharsets.UTF_8);
        }

        @Override
        public File getFile() {
            throw new UnsupportedOperationException("com.gargoylesoftware.htmlunit.javascript.host.file.File.InMemoryBackend.getFile()");
        }

        @Override
        public byte[] getBytes(int start, int end) {
            byte[] result = new byte[end - start];
            System.arraycopy(this.bytes_, start, result, 0, result.length);
            return result;
        }
    }

    protected static abstract class Backend
    implements Serializable {
        abstract String getName();

        abstract long getLastModified();

        abstract long getSize();

        abstract String getType(BrowserVersion var1);

        abstract String getText() throws IOException;

        abstract byte[] getBytes(int var1, int var2);

        Backend() {
        }

        abstract File getFile();
    }
}

