/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.InvisibleAction;
import hudson.model.User;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.NullSCM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.SAXException;

public class FakeChangeLogSCM
extends NullSCM {
    private List<EntryImpl> entries = new ArrayList<EntryImpl>();

    public EntryImpl addChange() {
        EntryImpl e = new EntryImpl();
        this.entries.add(e);
        return e;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath remoteDir, BuildListener listener, File changeLogFile) throws IOException, InterruptedException {
        new FilePath(changeLogFile).touch(0L);
        build.addAction((Action)new ChangelogAction(this.entries));
        this.entries = new ArrayList<EntryImpl>();
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return new FakeChangeLogParser();
    }

    public static class EntryImpl
    extends ChangeLogSet.Entry {
        private String msg = "some commit message";
        private String author = "someone";

        public EntryImpl withAuthor(String author) {
            this.author = author;
            return this;
        }

        public EntryImpl withMsg(String msg) {
            this.msg = msg;
            return this;
        }

        public String getMsg() {
            return this.msg;
        }

        public User getAuthor() {
            return User.get((String)this.author);
        }

        public Collection<String> getAffectedPaths() {
            return Collections.singleton("path");
        }
    }

    public static class FakeChangeLogSet
    extends ChangeLogSet<EntryImpl> {
        private List<EntryImpl> entries;

        public FakeChangeLogSet(AbstractBuild<?, ?> build, List<EntryImpl> entries) {
            super(build);
            this.entries = entries;
        }

        public boolean isEmptySet() {
            return this.entries.isEmpty();
        }

        public Iterator<EntryImpl> iterator() {
            return this.entries.iterator();
        }
    }

    public static class FakeChangeLogParser
    extends ChangeLogParser {
        public FakeChangeLogSet parse(AbstractBuild build, File changelogFile) throws IOException, SAXException {
            return new FakeChangeLogSet(build, ((ChangelogAction)build.getAction(ChangelogAction.class)).entries);
        }
    }

    public static class ChangelogAction
    extends InvisibleAction {
        private final List<EntryImpl> entries;

        public ChangelogAction(List<EntryImpl> entries) {
            this.entries = entries;
        }
    }
}

