/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import jenkins.model.RunAction2;
import jenkins.model.lazy.LazyBuildMixIn;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class RunLoadCounter {
    private static final ThreadLocal<String> currProject = new ThreadLocal();
    private static final ThreadLocal<AtomicInteger> currCount = new ThreadLocal();

    public static void prepare(LazyBuildMixIn.LazyLoadingJob<?, ?> project) throws IOException {
        ((MarkerAdder)((Object)ExtensionList.lookup(RunListener.class).get(MarkerAdder.class))).register((Job)project);
        for (Run build : project.getLazyBuildMixIn()._getRuns()) {
            Marker.add(build);
            build.save();
        }
    }

    public static int countLoads(LazyBuildMixIn.LazyLoadingJob<?, ?> project, Runnable thunk) {
        project.getLazyBuildMixIn()._getRuns().purgeCache();
        currProject.set(((Job)project).getFullName());
        currCount.set(new AtomicInteger());
        thunk.run();
        return currCount.get().get();
    }

    public static <T> T assertMaxLoads(LazyBuildMixIn.LazyLoadingJob<?, ?> project, int max, Callable<T> thunk) throws Exception {
        project.getLazyBuildMixIn()._getRuns().purgeCache();
        currProject.set(((Job)project).getFullName());
        currCount.set(new AtomicInteger(-(max + 1)));
        return thunk.call();
    }

    private RunLoadCounter() {
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final class MarkerAdder
    extends RunListener<Run<?, ?>> {
        private final Set<String> jobs = new HashSet<String>();

        public void onStarted(Run r, TaskListener tl) {
            if (this.jobs.contains(r.getParent().getFullName())) {
                Marker.add(r);
            }
        }

        void register(Job<?, ?> job) {
            this.jobs.add(job.getFullName());
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class Marker
    extends InvisibleAction
    implements RunAction2 {
        private final String project;
        private final int build;

        static void add(Run<?, ?> build) {
            build.addAction((Action)new Marker(build.getParent().getFullName(), build.getNumber()));
        }

        Marker(String project, int build) {
            this.project = project;
            this.build = build;
        }

        public void onLoad(Run<?, ?> run) {
            if (this.project.equals(currProject.get())) {
                System.err.println("loaded " + this.project + " #" + this.build);
                assert (((AtomicInteger)currCount.get()).incrementAndGet() != 0) : "too many build records loaded from " + this.project;
            }
        }

        public void onAttached(Run r) {
        }
    }
}

