/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.jvnet.hudson.test.TestEnvironment;

public interface HudsonHomeLoader {
    public static final HudsonHomeLoader NEW = new HudsonHomeLoader(){

        @Override
        public File allocate() throws IOException {
            return TestEnvironment.get().temporaryDirectoryAllocator.allocate();
        }
    };

    public File allocate() throws Exception;

    public static final class Local
    implements HudsonHomeLoader {
        private final Method testMethod;
        private static final String[] SUFFIXES = new String[]{"/", ".zip"};

        public Local(Method testMethod) {
            this.testMethod = testMethod;
        }

        @Override
        public File allocate() throws Exception {
            URL res = this.findDataResource();
            if (!res.getProtocol().equals("file")) {
                throw new AssertionError((Object)("Test data is not available in the file system: " + res));
            }
            File home = new File(res.toURI());
            System.err.println("Loading $JENKINS_HOME from " + home);
            return new CopyExisting(home).allocate();
        }

        private URL findDataResource() {
            Class<?> clazz = this.testMethod.getDeclaringClass();
            for (String middle : new String[]{'/' + this.testMethod.getName(), ""}) {
                for (String suffix : SUFFIXES) {
                    URL res = clazz.getResource(clazz.getSimpleName() + middle + suffix);
                    if (res == null) continue;
                    return res;
                }
            }
            throw new AssertionError((Object)("No test resource was found for " + this.testMethod));
        }
    }

    public static final class CopyExisting
    implements HudsonHomeLoader {
        private final URL source;

        public CopyExisting(File source) throws MalformedURLException {
            this(source.toURI().toURL());
        }

        public CopyExisting(URL source) {
            this.source = source;
        }

        @Override
        public File allocate() throws Exception {
            File target = NEW.allocate();
            if (this.source.getProtocol().equals("file")) {
                File src = new File(this.source.toURI());
                if (src.isDirectory()) {
                    new FilePath(src).copyRecursiveTo("**/*", new FilePath(target));
                } else if (src.getName().endsWith(".zip")) {
                    new FilePath(src).unzip(new FilePath(target));
                }
            } else {
                File tmp = File.createTempFile("hudson", "zip");
                try {
                    FileUtils.copyURLToFile((URL)this.source, (File)tmp);
                    new FilePath(tmp).unzip(new FilePath(target));
                }
                finally {
                    tmp.delete();
                }
            }
            return target;
        }
    }
}

