/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.ExtensionFinder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.junit.runner.Description;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.TestExtension;

@Extension
public class TestExtensionLoader
extends ExtensionFinder.GuiceExtensionAnnotation<TestExtension> {
    public TestExtensionLoader() {
        super(TestExtension.class);
    }

    protected boolean isOptional(TestExtension annotation) {
        return false;
    }

    protected double getOrdinal(TestExtension annotation) {
        return 0.0;
    }

    protected boolean isActive(AnnotatedElement e) {
        TestEnvironment env = TestEnvironment.get();
        if (env == null) {
            return false;
        }
        TestExtension a = e.getAnnotation(TestExtension.class);
        if (a == null) {
            return false;
        }
        List<String> testNameList = Arrays.asList(a.value());
        Description description = env.description();
        if (!testNameList.isEmpty() && !testNameList.contains(description.getMethodName())) {
            return false;
        }
        String className = description.getClassName();
        if (e instanceof Class) {
            for (Class<?> outer = (Class<?>)e; outer != null; outer = outer.getEnclosingClass()) {
                if (!outer.getName().equals(className)) continue;
                return true;
            }
            return false;
        }
        if (e instanceof Field) {
            Field f = (Field)e;
            return f.getDeclaringClass().getName().equals(className);
        }
        if (e instanceof Method) {
            Method m = (Method)e;
            return m.getDeclaringClass().getName().equals(className);
        }
        return false;
    }
}

