/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class CreateFileBuilder
extends Builder {
    @Nonnull
    private final String fileName;
    @Nonnull
    private final String fileContent;

    public CreateFileBuilder(@Nonnull String fileName, @Nonnull String fileContent) {
        this.fileName = fileName;
        this.fileContent = fileContent;
    }

    @Nonnull
    public String getFileName() {
        return this.fileName;
    }

    @Nonnull
    public String getFileContent() {
        return this.fileContent;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Creating a file " + this.fileName);
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException("Cannot get the workspace of the build");
        }
        workspace.child(this.fileName).write(this.fileContent, "UTF-8");
        return true;
    }

    public Descriptor<Builder> getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        public Builder newInstance(StaplerRequest req, JSONObject data) {
            throw new UnsupportedOperationException("This is a temporary test class, which should not be configured from UI");
        }

        public String getDisplayName() {
            return "Create a file";
        }
    }
}

