/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.VersionNumber;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.BoundedRangeModel;
import jenkins.model.Jenkins;
import org.junit.Assert;
import org.junit.Assume;
import org.netbeans.insane.impl.LiveEngine;
import org.netbeans.insane.live.Path;
import org.netbeans.insane.scanner.CountingVisitor;
import org.netbeans.insane.scanner.Filter;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;

public class MemoryAssert {
    private MemoryAssert() {
    }

    public static void assertHeapUsage(Object o, int max) throws Exception {
        CountingVisitor v = new CountingVisitor();
        ScannerUtils.scan((Filter)ScannerUtils.skipNonStrongReferencesFilter(), (Visitor)v, Collections.singleton(o), (boolean)false);
        int memoryUsage = v.getTotalSize();
        Assert.assertTrue((String)(o + " consumes " + memoryUsage + " bytes of heap, " + (memoryUsage - max) + " over the limit of " + max), (memoryUsage <= max ? 1 : 0) != 0);
    }

    public static List<HistogramElement> increasedMemory(Callable<Void> callable, Filter ... filters) throws Exception {
        Filter f = ScannerUtils.skipNonStrongReferencesFilter();
        if (filters.length > 0) {
            Filter[] fs = new Filter[filters.length + 1];
            fs[0] = f;
            System.arraycopy(filters, 0, fs, 1, filters.length);
            f = ScannerUtils.compoundFilter((Filter[])fs);
        }
        CountingVisitor v1 = new CountingVisitor();
        ScannerUtils.scan((Filter)f, (Visitor)v1, Collections.singleton(Jenkins.getInstance()), (boolean)false);
        Set old = v1.getClasses();
        callable.call();
        CountingVisitor v2 = new CountingVisitor();
        ScannerUtils.scan((Filter)f, (Visitor)v2, Collections.singleton(Jenkins.getInstance()), (boolean)false);
        ArrayList<HistogramElement> elements = new ArrayList<HistogramElement>();
        for (Class c : v2.getClasses()) {
            int delta = v2.getCountForClass(c) - (old.contains(c) ? v1.getCountForClass(c) : 0);
            if (delta <= 0) continue;
            elements.add(new HistogramElement(c.getName(), delta, v2.getSizeForClass(c) - (old.contains(c) ? v1.getSizeForClass(c) : 0)));
        }
        Collections.sort(elements);
        return elements;
    }

    @Deprecated
    public static void assertGC(WeakReference<?> reference) {
        MemoryAssert.assertGC(reference, true);
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE_OF_NULL"})
    public static void assertGC(WeakReference<?> reference, boolean allowSoft) {
        Object obj;
        Assume.assumeTrue((boolean)new VersionNumber(System.getProperty("java.specification.version")).isOlderThan(new VersionNumber("9")));
        Assert.assertTrue((boolean)true);
        reference.get();
        System.err.println("Trying to collect " + reference.get() + "\u2026");
        HashSet<Object[]> objects = new HashSet<Object[]>();
        int size = 1024;
        String softErr = null;
        while (reference.get() != null) {
            try {
                objects.add(new Object[size]);
                size = (int)((double)size * 1.3);
            }
            catch (OutOfMemoryError ignore) {
                if (softErr == null) break;
                Assert.fail(softErr);
            }
            System.gc();
            System.err.println("GC after allocation of size " + size);
            if (allowSoft || (obj = reference.get()) == null) continue;
            softErr = "Apparent soft references to " + obj + ": " + MemoryAssert.fromRoots(Collections.singleton(obj), null, null, new Filter(){
                final Field referent;
                {
                    try {
                        this.referent = Reference.class.getDeclaredField("referent");
                    }
                    catch (NoSuchFieldException x) {
                        throw new AssertionError((Object)x);
                    }
                }

                public boolean accept(Object obj, Object referredFrom, Field reference) {
                    return !this.referent.equals(reference) || !(referredFrom instanceof WeakReference);
                }
            }) + "; apparent weak references: " + MemoryAssert.fromRoots(Collections.singleton(obj), null, null, ScannerUtils.skipObjectsFilter(Collections.singleton(reference), (boolean)true));
            System.err.println(softErr);
        }
        objects = null;
        System.gc();
        obj = reference.get();
        if (obj == null) {
            System.err.println("Successfully collected.");
        } else {
            System.err.println("Failed to collect " + obj + ", looking for strong references\u2026");
            Map<Object, Path> rootRefs = MemoryAssert.fromRoots(Collections.singleton(obj), null, null, ScannerUtils.skipNonStrongReferencesFilter());
            if (!rootRefs.isEmpty()) {
                Assert.fail((String)rootRefs.toString());
            } else {
                System.err.println("Did not find any strong references to " + obj + ", looking for soft references\u2026");
                rootRefs = MemoryAssert.fromRoots(Collections.singleton(obj), null, null, new Filter(){
                    final Field referent;
                    {
                        try {
                            this.referent = Reference.class.getDeclaredField("referent");
                        }
                        catch (NoSuchFieldException x) {
                            throw new AssertionError((Object)x);
                        }
                    }

                    public boolean accept(Object obj, Object referredFrom, Field reference) {
                        return !this.referent.equals(reference) || !(referredFrom instanceof WeakReference);
                    }
                });
                if (!rootRefs.isEmpty()) {
                    Assert.fail((String)rootRefs.toString());
                } else {
                    System.err.println("Did not find any soft references to " + obj + ", looking for weak references\u2026");
                    rootRefs = MemoryAssert.fromRoots(Collections.singleton(obj), null, null, ScannerUtils.skipObjectsFilter(Collections.singleton(reference), (boolean)true));
                    if (!rootRefs.isEmpty()) {
                        Assert.fail((String)rootRefs.toString());
                    } else {
                        Assert.fail((String)("Did not find any root references to " + obj + " whatsoever. Unclear why it is not being collected."));
                    }
                }
            }
        }
    }

    private static Map<Object, Path> fromRoots(Collection<Object> objs, Set<Object> rootsHint, BoundedRangeModel progress, Filter f) {
        LiveEngine engine = new LiveEngine(progress){
            List<Class> classes = new ArrayList<Class>();

            public void visitClass(Class cls) {
                this.getID(cls);
                super.visitClass(cls);
                ClassLoader loader = cls.getClassLoader();
                if (loader != null) {
                    this.classes.add(cls);
                }
            }

            public void visitObject(ObjectMap map, Object object) {
                super.visitObject(map, object);
                if (object instanceof ClassLoader && this.isKnown(object)) {
                    for (Class c : this.classes) {
                        if (c.getClassLoader() != object) continue;
                        this.visitObjectReference((ObjectMap)this, c, object, null);
                    }
                }
            }
        };
        try {
            Field filter = LiveEngine.class.getDeclaredField("filter");
            filter.setAccessible(true);
            filter.set(engine, f);
        }
        catch (Exception x) {
            throw new AssertionError("could not patch INSANE", x);
        }
        HashSet<Object> rootsHint2 = new HashSet<Object>();
        if (rootsHint != null) {
            rootsHint2.addAll(rootsHint);
        }
        try {
            rootsHint2.add(Class.forName("java.io.ObjectStreamClass$Caches"));
            rootsHint2.add(Class.forName("java.beans.ThreadGroupContext"));
        }
        catch (ClassNotFoundException x) {
            x.printStackTrace();
        }
        return engine.trace(objs, rootsHint2);
    }

    public static final class HistogramElement
    implements Comparable<HistogramElement> {
        public final String className;
        public final int instanceCount;
        public final int byteSize;

        HistogramElement(String className, int instanceCount, int byteSize) {
            this.className = className;
            this.instanceCount = instanceCount;
            this.byteSize = byteSize;
        }

        @Override
        public int compareTo(HistogramElement o) {
            int r = o.byteSize - this.byteSize;
            return r != 0 ? r : this.className.compareTo(o.className);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HistogramElement)) {
                return false;
            }
            HistogramElement o = (HistogramElement)obj;
            return o.className.equals(this.className);
        }

        public int hashCode() {
            return this.className.hashCode();
        }
    }
}

