/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.Collections;
import org.jvnet.hudson.test.FakeLauncher;

public class PretendSlave
extends Slave {
    private transient FakeLauncher faker;
    public int numLaunch;

    public PretendSlave(String name, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, FakeLauncher faker) throws IOException, Descriptor.FormException {
        super(name, "pretending a slave", remoteFS, String.valueOf(numExecutors), mode, labelString, launcher, RetentionStrategy.NOOP, Collections.emptyList());
        this.faker = faker;
    }

    public PretendSlave(String name, String remoteFS, String labelString, ComputerLauncher launcher, FakeLauncher faker) throws IOException, Descriptor.FormException {
        this(name, remoteFS, 1, Node.Mode.NORMAL, labelString, launcher, faker);
    }

    public Launcher createLauncher(TaskListener listener) {
        return new Launcher.LocalLauncher(listener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Proc launch(Launcher.ProcStarter starter) throws IOException {
                PretendSlave pretendSlave = PretendSlave.this;
                synchronized (pretendSlave) {
                    ++PretendSlave.this.numLaunch;
                }
                Proc p = PretendSlave.this.faker.onLaunch(starter);
                if (p != null) {
                    return p;
                }
                return super.launch(starter);
            }
        };
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
    }
}

