/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import groovy.lang.Closure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.net.ServerSocket;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.rules.MethodRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TemporaryDirectoryAllocator;

public class RestartableJenkinsRule
implements MethodRule {
    public JenkinsRule j;
    private Description description;
    private final Map<Statement, Boolean> steps = new LinkedHashMap<Statement, Boolean>();
    private final TemporaryDirectoryAllocator tmp = new TemporaryDirectoryAllocator();
    private Object target;
    public File home;
    private final int port;
    private static final Logger LOGGER = Logger.getLogger(HudsonTestCase.class.getName());

    public RestartableJenkinsRule() {
        this.port = 0;
    }

    private RestartableJenkinsRule(int port) {
        this.port = port;
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        this.description = Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)method.getName(), (Annotation[])method.getAnnotations());
        this.target = target;
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    RestartableJenkinsRule.this.home = RestartableJenkinsRule.this.tmp.allocate();
                    base.evaluate();
                    RestartableJenkinsRule.this.run();
                }
                finally {
                    try {
                        RestartableJenkinsRule.this.tmp.dispose();
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
            }
        };
    }

    public void step(final Closure c) {
        this.addStep(new Statement(){

            public void evaluate() throws Throwable {
                c.call((Object)RestartableJenkinsRule.this.j);
            }
        });
    }

    void simulateAbruptShutdown() throws IOException {
        LOGGER.log(Level.INFO, "Beginning snapshot of JENKINS_HOME so we can simulate abrupt shutdown.  Disk writes MAY be lost if they happen after this.");
        File homeDir = this.home;
        File newHome = this.tmp.allocate();
        Files.walkFileTree(homeDir.toPath(), Collections.EMPTY_SET, 99, new CopyFileVisitor(newHome.toPath()));
        LOGGER.log(Level.INFO, "Finished snapshot of JENKINS_HOME, any disk writes by Jenkins after this are lost as we will simulate suddenly killing the Jenkins process and switch to the snapshot.");
        this.home = newHome;
    }

    public void then(final Step s) {
        this.addStep(new Statement(){

            public void evaluate() throws Throwable {
                s.run(RestartableJenkinsRule.this.j);
            }
        });
    }

    public void thenWithHardShutdown(final Step s) {
        this.addStep(new Statement(){

            public void evaluate() throws Throwable {
                s.run(RestartableJenkinsRule.this.j);
                RestartableJenkinsRule.this.simulateAbruptShutdown();
            }
        });
    }

    public void thenDoesNotStart() {
        this.addStep(new Statement(){

            public void evaluate() throws Throwable {
                throw new IllegalStateException("should have failed before reaching here.");
            }
        }, false);
    }

    public void addStep(Statement step) {
        this.addStep(step, true);
    }

    public void addStep(final Statement step, boolean expectedToStartCorrectly) {
        this.steps.put(new Statement(){

            public void evaluate() throws Throwable {
                RestartableJenkinsRule.this.j.jenkins.getInjector().injectMembers((Object)step);
                RestartableJenkinsRule.this.j.jenkins.getInjector().injectMembers(RestartableJenkinsRule.this.target);
                step.evaluate();
            }
        }, expectedToStartCorrectly);
    }

    public void addStepWithDirtyShutdown(final Statement step) {
        this.steps.put(new Statement(){

            public void evaluate() throws Throwable {
                RestartableJenkinsRule.this.j.jenkins.getInjector().injectMembers((Object)step);
                RestartableJenkinsRule.this.j.jenkins.getInjector().injectMembers(RestartableJenkinsRule.this.target);
                step.evaluate();
                RestartableJenkinsRule.this.simulateAbruptShutdown();
            }
        }, true);
    }

    private void run() throws Throwable {
        HudsonHomeLoader loader = () -> this.home;
        for (Map.Entry<Statement, Boolean> entry : this.steps.entrySet()) {
            Statement step = entry.getKey();
            this.j = this.createJenkinsRule(this.description).with(loader);
            try {
                this.j.apply(step, this.description).evaluate();
                if (entry.getValue().booleanValue()) continue;
                Assert.fail((String)"The current JenkinsRule should have failed to start Jenkins.");
            }
            catch (Exception e) {
                if (!entry.getValue().booleanValue()) continue;
                throw e;
            }
        }
    }

    protected JenkinsRule createJenkinsRule(Description description) {
        JenkinsRule result = new JenkinsRule();
        if (this.port != 0) {
            result.localPort = this.port;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized int getRandomPort() {
        try (ServerSocket s = new ServerSocket(0);){
            int n = s.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to find free port", e);
        }
    }

    public static interface Step {
        public void run(JenkinsRule var1) throws Throwable;
    }

    static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private Path sourcePath = null;

        public CopyFileVisitor(Path targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.sourcePath == null) {
                this.sourcePath = dir;
            } else {
                Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir)), new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            try {
                if (!Files.isSymbolicLink(file)) {
                    Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES);
                } else if (Files.isSymbolicLink(file) && Files.exists(Files.readSymbolicLink(file), new LinkOption[0])) {
                    Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.COPY_ATTRIBUTES);
                }
            }
            catch (NoSuchFileException nsfe) {
                LOGGER.log(Level.FINE, "File disappeared while trying to copy to new home, continuing anyway: " + file.toString());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            if (exc instanceof FileNotFoundException) {
                LOGGER.log(Level.FINE, "File not found while trying to copy to new home, continuing anyway: " + file.toString());
                return FileVisitResult.CONTINUE;
            }
            LOGGER.log(Level.WARNING, "Error copying file", exc);
            return FileVisitResult.TERMINATE;
        }
    }

    public static class Builder {
        private int port = 0;

        public Builder withReusedPort() {
            this.port = RestartableJenkinsRule.getRandomPort();
            return this;
        }

        public RestartableJenkinsRule build() {
            return new RestartableJenkinsRule(this.port);
        }
    }
}

