/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.maven.AbstractMavenBuilder;
import hudson.maven.ExecutedMojo;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuildProxy2;
import hudson.maven.MavenBuilder;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenReportInfo;
import hudson.maven.MavenReporter;
import hudson.maven.ModuleName;
import hudson.maven.MojoInfo;
import hudson.maven.agent.AbortException;
import hudson.model.BuildListener;
import hudson.model.Result;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.BuildFailureException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Maven2Builder
extends MavenBuilder {
    private final Map<ModuleName, List<ExecutedMojo>> executedMojos = new HashMap<ModuleName, List<ExecutedMojo>>();
    private long mojoStartTime;
    private MavenBuildProxy2 lastProxy;
    private static final long serialVersionUID = 1L;

    public Maven2Builder(BuildListener listener, Map<ModuleName, MavenBuild.ProxyImpl2> proxies, Collection<MavenModule> modules, List<String> goals, Map<String, String> systemProps, MavenBuildInformation mavenBuildInformation) {
        super(listener, modules, goals, systemProps);
        this.sourceProxies.putAll(proxies);
        this.proxies = new HashMap();
        for (Map.Entry e : this.sourceProxies.entrySet()) {
            this.proxies.put(e.getKey(), new AbstractMavenBuilder.FilterImpl((MavenBuildProxy2)e.getValue(), mavenBuildInformation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result call() throws IOException {
        try {
            if (MavenModuleSetBuild.debug) {
                this.listener.getLogger().println("Builder extends MavenBuilder in call " + Thread.currentThread().getContextClassLoader());
            }
            Result result = super.call();
            Object var3_2 = null;
            if (this.lastProxy != null) {
                this.lastProxy.appendLastLog();
            }
            return result;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (this.lastProxy == null) break block4;
                this.lastProxy.appendLastLog();
            }
            throw throwable;
        }
    }

    @Override
    void preBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
        List projects = rm.getSortedProjects();
        HashSet<ModuleName> buildingProjects = new HashSet<ModuleName>();
        for (MavenProject mavenProject : projects) {
            buildingProjects.add(new ModuleName(mavenProject));
        }
        for (Map.Entry entry : this.proxies.entrySet()) {
            if (buildingProjects.contains(entry.getKey())) continue;
            MavenBuildProxy2 proxy = (MavenBuildProxy2)entry.getValue();
            proxy.start();
            proxy.setResult(Result.NOT_BUILT);
            proxy.end();
        }
    }

    @Override
    void postBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
    }

    @Override
    void preModule(MavenProject project) throws InterruptedException, IOException, AbortException {
        ModuleName name = new ModuleName(project);
        MavenBuildProxy2 proxy = (MavenBuildProxy2)this.proxies.get(name);
        this.listener.getLogger().flush();
        proxy.start();
        for (MavenReporter r : (List)this.reporters.get(name)) {
            if (r.preBuild(proxy, project, this.listener)) continue;
            throw new AbortException(r + " failed");
        }
    }

    @Override
    void postModule(MavenProject project) throws InterruptedException, IOException, AbortException {
        ModuleName name = new ModuleName(project);
        MavenBuildProxy2 proxy = (MavenBuildProxy2)this.proxies.get(name);
        List rs = (List)this.reporters.get(name);
        if (rs == null) {
            throw new AssertionError((Object)("reporters.get(" + name + ")==null. reporters=" + this.reporters + " proxies=" + this.proxies));
        }
        for (MavenReporter r : rs) {
            if (r.postBuild(proxy, project, this.listener)) continue;
            throw new AbortException(r + " failed");
        }
        proxy.setExecutedMojos(this.executedMojos.get(name));
        this.listener.getLogger().flush();
        proxy.end();
        this.lastProxy = proxy;
    }

    @Override
    void preExecute(MavenProject project, MojoInfo mojoInfo) throws IOException, InterruptedException, AbortException {
        ModuleName name = new ModuleName(project);
        MavenBuildProxy proxy = (MavenBuildProxy)this.proxies.get(name);
        for (MavenReporter r : (List)this.reporters.get(name)) {
            if (r.preExecute(proxy, project, mojoInfo, this.listener)) continue;
            throw new AbortException(r + " failed");
        }
        this.mojoStartTime = System.currentTimeMillis();
    }

    @Override
    void postExecute(MavenProject project, MojoInfo mojoInfo, Exception exception) throws IOException, InterruptedException, AbortException {
        ModuleName name = new ModuleName(project);
        List<ExecutedMojo> mojoList = this.executedMojos.get(name);
        if (mojoList == null) {
            mojoList = new ArrayList<ExecutedMojo>();
            this.executedMojos.put(name, mojoList);
        }
        mojoList.add(new ExecutedMojo(mojoInfo, System.currentTimeMillis() - this.mojoStartTime));
        MavenBuildProxy2 proxy = (MavenBuildProxy2)this.proxies.get(name);
        for (MavenReporter r : (List)this.reporters.get(name)) {
            if (r.postExecute(proxy, project, mojoInfo, this.listener, exception)) continue;
            throw new AbortException(r + " failed");
        }
        if (exception != null) {
            proxy.setResult(Result.FAILURE);
        }
    }

    @Override
    void onReportGenerated(MavenProject project, MavenReportInfo report) throws IOException, InterruptedException, AbortException {
        ModuleName name = new ModuleName(project);
        MavenBuildProxy proxy = (MavenBuildProxy)this.proxies.get(name);
        for (MavenReporter r : (List)this.reporters.get(name)) {
            if (r.reportGenerated(proxy, project, report, this.listener)) continue;
            throw new AbortException(r + " failed");
        }
    }
}

