/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.maven.AbstractMavenBuilder;
import hudson.maven.MavenModule;
import hudson.maven.MavenProcessFactory;
import hudson.maven.MavenReportInfo;
import hudson.maven.Messages;
import hudson.maven.MojoInfo;
import hudson.maven.agent.AbortException;
import hudson.maven.agent.Main;
import hudson.maven.agent.PluginManagerListener;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import hudson.util.IOException2;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.BuildFailureException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutorListener;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MavenBuilder
extends AbstractMavenBuilder
implements DelegatingCallable<Result, IOException> {
    private final boolean profile = MavenProcessFactory.profile;
    private Class<?> pluginManagerInterceptorClazz;
    private Class<?> lifecycleInterceptorClazz;
    public static boolean markAsSuccess;
    private static final long serialVersionUID = 1L;

    protected MavenBuilder(BuildListener listener, Collection<MavenModule> modules, List<String> goals, Map<String, String> systemProps) {
        super(listener, modules, goals, systemProps);
    }

    abstract void preBuild(MavenSession var1, ReactorManager var2, EventDispatcher var3) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException;

    abstract void postBuild(MavenSession var1, ReactorManager var2, EventDispatcher var3) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException;

    abstract void preModule(MavenProject var1) throws InterruptedException, IOException, AbortException;

    abstract void postModule(MavenProject var1) throws InterruptedException, IOException, AbortException;

    abstract void preExecute(MavenProject var1, MojoInfo var2) throws IOException, InterruptedException, AbortException;

    abstract void postExecute(MavenProject var1, MojoInfo var2, Exception var3) throws IOException, InterruptedException, AbortException;

    abstract void onReportGenerated(MavenProject var1, MavenReportInfo var2) throws IOException, InterruptedException, AbortException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result call() throws IOException {
        Result result;
        ClassLoader mavenJailProcessClassLoader;
        block17: {
            block16: {
                block15: {
                    mavenJailProcessClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Result result2;
                        block14: {
                            try {
                                this.initializeAsynchronousExecutions();
                                Adapter a = new Adapter(this);
                                this.callSetListenerWithReflectOnInterceptors(a, mavenJailProcessClassLoader);
                                markAsSuccess = false;
                                this.registerSystemProperties();
                                this.listener.getLogger().println(this.formatArgs(this.goals));
                                int r = Main.launch((String[])this.goals.toArray(new String[this.goals.size()]));
                                long startTime = System.nanoTime();
                                Result waitForAsyncExecutionsResult = this.waitForAsynchronousExecutions();
                                if (waitForAsyncExecutionsResult != null) {
                                    result2 = waitForAsyncExecutionsResult;
                                    Object var11_14 = null;
                                    break block14;
                                }
                                a.overheadTime += System.nanoTime() - startTime;
                                if (this.profile) {
                                    NumberFormat n = NumberFormat.getInstance();
                                    PrintStream logger = this.listener.getLogger();
                                    logger.println("Total overhead was " + this.format(n, a.overheadTime) + "ms");
                                    Channel ch = Channel.current();
                                    logger.println("Class loading " + this.format(n, ch.classLoadingTime.get()) + "ms, " + ch.classLoadingCount + " classes");
                                    logger.println("Resource loading " + this.format(n, ch.resourceLoadingTime.get()) + "ms, " + ch.resourceLoadingCount + " times");
                                }
                                if (r == 0) {
                                    result = Result.SUCCESS;
                                    break block15;
                                }
                                if (markAsSuccess) {
                                    this.listener.getLogger().println(Messages.MavenBuilder_Failed());
                                    result = Result.SUCCESS;
                                    break block16;
                                }
                                result = Result.FAILURE;
                                break block17;
                            }
                            catch (NoSuchMethodException e) {
                                throw new IOException2((Throwable)e);
                            }
                            catch (IllegalAccessException e) {
                                throw new IOException2((Throwable)e);
                            }
                            catch (RuntimeException e) {
                                throw new IOException2((Throwable)e);
                            }
                            catch (InvocationTargetException e) {
                                throw new IOException2((Throwable)e);
                            }
                            catch (ClassNotFoundException e) {
                                throw new IOException2((Throwable)e);
                            }
                            catch (NoSuchRealmException e) {
                                throw new IOException2((Throwable)e);
                            }
                        }
                        this.callSetListenerWithReflectOnInterceptorsQuietly(null, mavenJailProcessClassLoader);
                        return result2;
                    }
                    catch (Throwable throwable) {
                        Object var11_18 = null;
                        this.callSetListenerWithReflectOnInterceptorsQuietly(null, mavenJailProcessClassLoader);
                        throw throwable;
                    }
                }
                Object var11_15 = null;
                this.callSetListenerWithReflectOnInterceptorsQuietly(null, mavenJailProcessClassLoader);
                return result;
            }
            Object var11_16 = null;
            this.callSetListenerWithReflectOnInterceptorsQuietly(null, mavenJailProcessClassLoader);
            return result;
        }
        Object var11_17 = null;
        this.callSetListenerWithReflectOnInterceptorsQuietly(null, mavenJailProcessClassLoader);
        return result;
    }

    private void callSetListenerWithReflectOnInterceptors(PluginManagerListener pluginManagerListener, ClassLoader cl) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.pluginManagerInterceptorClazz == null) {
            this.pluginManagerInterceptorClazz = cl.loadClass("hudson.maven.agent.PluginManagerInterceptor");
        }
        Method setListenerMethod = this.pluginManagerInterceptorClazz.getMethod("setListener", cl.loadClass("hudson.maven.agent.PluginManagerListener"));
        setListenerMethod.invoke(null, pluginManagerListener);
        if (this.lifecycleInterceptorClazz == null) {
            this.lifecycleInterceptorClazz = cl.loadClass("org.apache.maven.lifecycle.LifecycleExecutorInterceptor");
        }
        setListenerMethod = this.lifecycleInterceptorClazz.getMethod("setListener", cl.loadClass("org.apache.maven.lifecycle.LifecycleExecutorListener"));
        setListenerMethod.invoke(null, pluginManagerListener);
    }

    private void callSetListenerWithReflectOnInterceptorsQuietly(PluginManagerListener pluginManagerListener, ClassLoader cl) {
        try {
            this.callSetListenerWithReflectOnInterceptors(pluginManagerListener, cl);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static final class Adapter
    implements PluginManagerListener,
    LifecycleExecutorListener {
        private MavenProject lastModule;
        private final MavenBuilder listener;
        long overheadTime;

        public Adapter(MavenBuilder listener) {
            this.listener = listener;
        }

        public void preBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            long startTime = System.nanoTime();
            this.listener.preBuild(session, rm, dispatcher);
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void postBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            long startTime = System.nanoTime();
            this.fireLeaveModule();
            this.listener.postBuild(session, rm, dispatcher);
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void endModule() throws InterruptedException, IOException {
            long startTime = System.nanoTime();
            this.fireLeaveModule();
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void preExecute(MavenProject project, MojoExecution exec, Mojo mojo, PlexusConfiguration mergedConfig, ExpressionEvaluator eval) throws IOException, InterruptedException {
            long startTime = System.nanoTime();
            if (this.lastModule != project) {
                this.fireLeaveModule();
                this.fireEnterModule(project);
            }
            this.listener.preExecute(project, new MojoInfo(exec, mojo, mergedConfig, eval));
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void postExecute(MavenProject project, MojoExecution exec, Mojo mojo, PlexusConfiguration mergedConfig, ExpressionEvaluator eval, Exception exception) throws IOException, InterruptedException {
            long startTime = System.nanoTime();
            this.listener.postExecute(project, new MojoInfo(exec, mojo, mergedConfig, eval), exception);
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void onReportGenerated(MavenReport report, MojoExecution mojoExecution, PlexusConfiguration mergedConfig, ExpressionEvaluator eval) throws IOException, InterruptedException {
            long startTime = System.nanoTime();
            this.listener.onReportGenerated(this.lastModule, new MavenReportInfo(mojoExecution, report, mergedConfig, eval));
            this.overheadTime += System.nanoTime() - startTime;
        }

        private void fireEnterModule(MavenProject project) throws InterruptedException, IOException {
            this.lastModule = project;
            this.listener.preModule(project);
        }

        private void fireLeaveModule() throws InterruptedException, IOException {
            if (this.lastModule != null) {
                this.listener.postModule(this.lastModule);
                this.lastModule = null;
            }
        }
    }
}

