/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.AbortException;
import hudson.Util;
import hudson.maven.EmbedderLoggerImpl;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenEmbedderRequest;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenRequest;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tasks.Maven;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.logging.LoggerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenUtil {
    public static boolean debugMavenEmbedder = Boolean.getBoolean("debugMavenEmbedder");
    private static final Logger LOGGER = Logger.getLogger(MavenUtil.class.getName());

    public static MavenEmbedder createEmbedder(TaskListener listener, String profiles) throws MavenEmbedderException, IOException {
        return MavenUtil.createEmbedder(listener, (File)null, profiles);
    }

    public static MavenEmbedder createEmbedder(TaskListener listener, AbstractProject<?, ?> project, String profiles) throws MavenEmbedderException, IOException, InterruptedException {
        Maven.MavenInstallation m = null;
        if (project instanceof Maven.ProjectWithMaven) {
            m = ((Maven.ProjectWithMaven)project).inferMavenInstallation().forNode((Node)Jenkins.getInstance(), listener);
        }
        return MavenUtil.createEmbedder(listener, m != null ? m.getHomeDir() : null, profiles);
    }

    public static MavenEmbedder createEmbedder(TaskListener listener, AbstractBuild<?, ?> build) throws MavenEmbedderException, IOException, InterruptedException {
        Maven.MavenInstallation m = null;
        File settingsLoc = null;
        String profiles = null;
        Properties systemProperties = null;
        String privateRepository = null;
        AbstractProject project = build.getProject();
        if (project instanceof Maven.ProjectWithMaven) {
            m = ((Maven.ProjectWithMaven)project).inferMavenInstallation().forNode((Node)Jenkins.getInstance(), listener);
        }
        if (project instanceof MavenModuleSet) {
            String altSet = ((MavenModuleSet)project).getAlternateSettings();
            File file = settingsLoc = altSet == null ? null : new File(build.getWorkspace().child(altSet).getRemote());
            if (((MavenModuleSet)project).usesPrivateRepository()) {
                privateRepository = build.getWorkspace().child(".repository").getRemote();
            }
            profiles = ((MavenModuleSet)project).getProfiles();
            systemProperties = ((MavenModuleSet)project).getMavenProperties();
        }
        return MavenUtil.createEmbedder(new MavenEmbedderRequest(listener, m != null ? m.getHomeDir() : null, profiles, systemProperties, privateRepository, settingsLoc));
    }

    public static MavenEmbedder createEmbedder(TaskListener listener, File mavenHome, String profiles) throws MavenEmbedderException, IOException {
        return MavenUtil.createEmbedder(listener, mavenHome, profiles, new Properties());
    }

    public static MavenEmbedder createEmbedder(TaskListener listener, File mavenHome, String profiles, Properties systemProperties) throws MavenEmbedderException, IOException {
        return MavenUtil.createEmbedder(listener, mavenHome, profiles, systemProperties, null);
    }

    public static MavenEmbedder createEmbedder(TaskListener listener, File mavenHome, String profiles, Properties systemProperties, String privateRepository) throws MavenEmbedderException, IOException {
        return MavenUtil.createEmbedder(new MavenEmbedderRequest(listener, mavenHome, profiles, systemProperties, privateRepository, null));
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public static MavenEmbedder createEmbedder(MavenEmbedderRequest mavenEmbedderRequest) throws MavenEmbedderException, IOException {
        MavenRequest mavenRequest = new MavenRequest();
        File m2Home = new File(MavenEmbedder.userHome, ".m2");
        m2Home.mkdirs();
        if (!m2Home.exists()) {
            throw new AbortException("Failed to create " + m2Home);
        }
        if (mavenEmbedderRequest.getPrivateRepository() != null) {
            mavenRequest.setLocalRepositoryPath(mavenEmbedderRequest.getPrivateRepository());
        }
        if (mavenEmbedderRequest.getProfiles() != null) {
            mavenRequest.setProfiles(Arrays.asList(StringUtils.split((String)mavenEmbedderRequest.getProfiles(), (String)",")));
        }
        if (mavenEmbedderRequest.getAlternateSettings() != null) {
            mavenRequest.setUserSettingsFile(mavenEmbedderRequest.getAlternateSettings().getAbsolutePath());
        } else {
            mavenRequest.setUserSettingsFile(new File(m2Home, "settings.xml").getAbsolutePath());
        }
        if (mavenEmbedderRequest.getGlobalSettings() != null) {
            mavenRequest.setGlobalSettingsFile(mavenEmbedderRequest.getGlobalSettings().getAbsolutePath());
        } else {
            mavenRequest.setGlobalSettingsFile(new File(mavenEmbedderRequest.getMavenHome(), "conf/settings.xml").getAbsolutePath());
        }
        if (mavenEmbedderRequest.getWorkspaceReader() != null) {
            mavenRequest.setWorkspaceReader(mavenEmbedderRequest.getWorkspaceReader());
        }
        mavenRequest.setSystemProperties(mavenEmbedderRequest.getSystemProperties());
        if (mavenEmbedderRequest.getTransferListener() != null) {
            if (debugMavenEmbedder) {
                mavenEmbedderRequest.getListener().getLogger().println("use transfertListener " + mavenEmbedderRequest.getTransferListener().getClass().getName());
            }
            mavenRequest.setTransferListener(mavenEmbedderRequest.getTransferListener());
        }
        EmbedderLoggerImpl logger = new EmbedderLoggerImpl(mavenEmbedderRequest.getListener(), debugMavenEmbedder ? 0 : 1);
        mavenRequest.setMavenLoggerManager((LoggerManager)logger);
        ClassLoader mavenEmbedderClassLoader = mavenEmbedderRequest.getClassLoader() == null ? new MaskingClassLoader(MavenUtil.class.getClassLoader()) : mavenEmbedderRequest.getClassLoader();
        Enumeration<URL> e = mavenEmbedderClassLoader.getResources("META-INF/plexus/components.xml");
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            LOGGER.fine("components.xml from " + url);
        }
        mavenRequest.setProcessPlugins(mavenEmbedderRequest.isProcessPlugins());
        mavenRequest.setResolveDependencies(mavenEmbedderRequest.isResolveDependencies());
        mavenRequest.setValidationLevel(mavenEmbedderRequest.getValidationLevel());
        MavenEmbedder maven = new MavenEmbedder(mavenEmbedderClassLoader, mavenRequest);
        return maven;
    }

    public static void resolveModules(MavenEmbedder embedder, MavenProject project, String rel, Map<MavenProject, String> relativePathInfo, BuildListener listener, boolean nonRecursive) throws ProjectBuildingException, AbortException, MavenEmbedderException {
        File basedir = project.getFile().getParentFile();
        relativePathInfo.put(project, rel);
        ArrayList<MavenProject> modules = new ArrayList<MavenProject>();
        if (!nonRecursive) {
            for (String modulePath : project.getModules()) {
                if (Util.fixEmptyAndTrim((String)modulePath) == null) continue;
                File moduleFile = new File(basedir, modulePath);
                if (moduleFile.exists() && moduleFile.isDirectory()) {
                    moduleFile = new File(basedir, modulePath + "/pom.xml");
                }
                if (!moduleFile.exists()) {
                    throw new AbortException(moduleFile + " is referenced from " + project.getFile() + " but it doesn't exist");
                }
                String relativePath = rel;
                if (relativePath.length() > 0) {
                    relativePath = relativePath + '/';
                }
                relativePath = relativePath + modulePath;
                MavenProject child = embedder.readProject(moduleFile);
                MavenUtil.resolveModules(embedder, child, relativePath, relativePathInfo, listener, nonRecursive);
                modules.add(child);
            }
        }
        project.setCollectedProjects(modules);
    }

    public static boolean maven3orLater(String mavenVersion) {
        if (StringUtils.isBlank((String)mavenVersion)) {
            return false;
        }
        return new ComparableVersion(mavenVersion).compareTo(new ComparableVersion("3.0")) >= 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MaskingClassLoader
    extends ClassLoader {
        public MaskingClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final Enumeration<URL> e = super.getResources(name);
            return new Enumeration<URL>(){
                URL next;

                @Override
                public boolean hasMoreElements() {
                    this.fetch();
                    return this.next != null;
                }

                @Override
                public URL nextElement() {
                    this.fetch();
                    URL r = this.next;
                    this.next = null;
                    return r;
                }

                private void fetch() {
                    while (this.next == null && e.hasMoreElements()) {
                        this.next = (URL)e.nextElement();
                        if (!this.shouldBeIgnored(this.next)) continue;
                        this.next = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private boolean shouldBeIgnored(URL url) {
                    BufferedReader r;
                    block8: {
                        boolean bl;
                        block7: {
                            String s = url.toExternalForm();
                            if (s.contains("maven-plugin-tools-api")) {
                                return true;
                            }
                            if (!s.endsWith("components.xml")) return false;
                            r = null;
                            try {
                                try {
                                    r = new BufferedReader(new InputStreamReader(url.openStream()));
                                    for (int i = 0; i < 2; ++i) {
                                        String l = r.readLine();
                                        if (l == null || !l.contains("MAVEN-INTERCEPTION-TO-BE-MASKED")) continue;
                                        bl = true;
                                        Object var8_8 = null;
                                        break block7;
                                    }
                                    break block8;
                                }
                                catch (IOException _) {
                                    Object var8_10 = null;
                                    IOUtils.closeQuietly(r);
                                    return false;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_11 = null;
                                IOUtils.closeQuietly(r);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((Reader)r);
                        return bl;
                    }
                    Object var8_9 = null;
                    IOUtils.closeQuietly((Reader)r);
                    return false;
                }
            };
        }
    }
}

