/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Functions;
import hudson.maven.ModuleName;
import java.io.Serializable;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;

public final class ModuleDependency
implements Serializable {
    public final String groupId;
    public final String artifactId;
    public final String version;
    public final boolean plugin;
    public static final String UNKNOWN = "*";
    public static final String NONE = "-";
    private static final long serialVersionUID = 1L;

    public ModuleDependency(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, false);
    }

    public ModuleDependency(String groupId, String artifactId, String version, boolean plugin) {
        this.groupId = groupId.intern();
        this.artifactId = artifactId.intern();
        this.version = version == null ? UNKNOWN : version.intern();
        this.plugin = plugin;
    }

    public ModuleDependency(ModuleName name, String version) {
        this(name.groupId, name.artifactId, version, false);
    }

    public ModuleDependency(ModuleName name, String version, boolean plugin) {
        this(name.groupId, name.artifactId, version, plugin);
    }

    public ModuleDependency(Dependency dep) {
        this(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
    }

    public ModuleDependency(MavenProject project) {
        this(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public ModuleDependency(Plugin p) {
        this(p.getGroupId(), p.getArtifactId(), (String)Functions.defaulted((Object)p.getVersion(), (Object)NONE), true);
    }

    public ModuleDependency(ReportPlugin p) {
        this(p.getGroupId(), p.getArtifactId(), p.getVersion(), true);
    }

    public ModuleDependency(Extension ext) {
        this(ext.getGroupId(), ext.getArtifactId(), ext.getVersion());
    }

    private ModuleDependency(String groupId, String artifactId, boolean plugin) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = UNKNOWN;
        this.plugin = plugin;
    }

    public ModuleName getName() {
        return new ModuleName(this.groupId, this.artifactId);
    }

    public ModuleDependency withUnknownVersion() {
        if (UNKNOWN.equals(this.version)) {
            return this;
        }
        return new ModuleDependency(this.groupId, this.artifactId, this.plugin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleDependency that = (ModuleDependency)o;
        return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && this.plugin == that.plugin;
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.plugin ? 1 : 2);
        return result;
    }

    protected Object readResolve() {
        return new ModuleDependency(this.groupId, this.artifactId, this.version, this.plugin);
    }
}

