/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.maven.Maven3Builder;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuilder;
import hudson.maven.MavenModule;
import hudson.maven.MavenProjectActionBuilder;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.maven.reporters.SurefireReport;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurefireArchiver
extends MavenReporter {
    private transient TestResult result;
    private transient ConcurrentMap<File, FileSet> fileSets = new ConcurrentHashMap<File, FileSet>();
    private static final long serialVersionUID = 1L;

    @Override
    public boolean preExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener) throws InterruptedException, IOException {
        XmlPlexusConfiguration c;
        if (this.isSurefireTest(mojo) && !mojo.is("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test") && (c = (XmlPlexusConfiguration)mojo.configuration.getChild("testFailureIgnore")) != null && c.getValue() != null && c.getValue().equals("${maven.test.failure.ignore}") && System.getProperty("maven.test.failure.ignore") == null) {
            if (build.getMavenBuildInformation().isMaven3OrLater()) {
                String fieldName = "testFailureIgnore";
                if (mojo.mojoExecution.getConfiguration().getChild(fieldName) != null) {
                    mojo.mojoExecution.getConfiguration().getChild(fieldName).setValue(Boolean.TRUE.toString());
                } else {
                    Xpp3Dom child = new Xpp3Dom(fieldName);
                    child.setValue(Boolean.TRUE.toString());
                    mojo.mojoExecution.getConfiguration().addChild(child);
                }
            } else {
                c.setValue(Boolean.TRUE.toString());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, final BuildListener listener, Throwable error) throws InterruptedException, IOException {
        File reportsDir;
        if (!this.isSurefireTest(mojo)) {
            return true;
        }
        listener.getLogger().println(Messages.SurefireArchiver_Recording());
        if (mojo.is("org.apache.maven.plugins", "maven-surefire-plugin", "test") || mojo.is("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test")) {
            try {
                reportsDir = mojo.getConfigurationValue("reportsDirectory", File.class);
            }
            catch (ComponentConfigurationException e) {
                e.printStackTrace(listener.fatalError(Messages.SurefireArchiver_NoReportsDir()));
                build.setResult(Result.FAILURE);
                return true;
            }
        } else {
            reportsDir = new File(pom.getBasedir(), "target/surefire-reports");
        }
        if (reportsDir.exists()) {
            MavenBuildProxy mavenBuildProxy = build;
            synchronized (mavenBuildProxy) {
                FileSet fileSet = this.getFileSet(reportsDir);
                DirectoryScanner ds = fileSet.getDirectoryScanner();
                if (ds.getIncludedFilesCount() == 0) {
                    return true;
                }
                String[] reportFiles = ds.getIncludedFiles();
                this.rememberCheckedFiles(reportsDir, reportFiles);
                if (this.result == null) {
                    this.result = new TestResult();
                }
                this.result.parse(System.currentTimeMillis() - build.getMilliSecsSinceBuildStart(), reportsDir, reportFiles);
                final TestResult r = this.result;
                int failCount = build.execute(new MavenBuildProxy.BuildCallable<Integer, IOException>(){
                    private static final long serialVersionUID = -1023888330720922136L;

                    @Override
                    public Integer call(MavenBuild build) throws IOException, InterruptedException {
                        SurefireReport sr = (SurefireReport)build.getAction(SurefireReport.class);
                        if (sr == null) {
                            build.getActions().add(new SurefireReport(build, r, listener));
                        } else {
                            sr.setResult(r, listener);
                        }
                        if (r.getFailCount() > 0) {
                            build.setResult(Result.UNSTABLE);
                        }
                        build.registerAsProjectAction(new FactoryImpl());
                        return r.getFailCount();
                    }
                });
                if (failCount > 0) {
                    this.markBuildAsSuccess(error, build.getMavenBuildInformation());
                }
            }
        }
        return true;
    }

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="It's okay to write to static fields here, as each Maven build is started in its own VM")
    private void markBuildAsSuccess(Throwable mojoError, MavenBuildInformation buildInfo) {
        if (mojoError == null || mojoError instanceof MojoFailureException) {
            MavenBuilder.markAsSuccess = true;
            Maven3Builder.markAsSuccess = true;
        }
    }

    FileSet getFileSet(File baseDir) {
        FileSet previous;
        FileSet fs = (FileSet)this.fileSets.get(baseDir);
        if (fs == null && (previous = this.fileSets.putIfAbsent(baseDir, fs = Util.createFileSet((File)baseDir, (String)"*.xml", (String)"testng-results.xml,testng-failed.xml"))) != null) {
            return previous;
        }
        return fs;
    }

    private void rememberCheckedFiles(File baseDir, String[] reportFiles) {
        FileSet fileSet = this.getFileSet(baseDir);
        for (String file : reportFiles) {
            fileSet.createExclude().setName(file);
        }
    }

    public static void fixUp(List<MavenProjectActionBuilder> builders) {
        if (builders == null) {
            return;
        }
        ListIterator<MavenProjectActionBuilder> itr = builders.listIterator();
        while (itr.hasNext()) {
            MavenProjectActionBuilder b = itr.next();
            if (!(b instanceof SurefireArchiver)) continue;
            itr.set(new FactoryImpl());
        }
    }

    private boolean isSurefireTest(MojoInfo mojo) {
        if (!(mojo.is("com.sun.maven", "maven-junit-plugin", "test") || mojo.is("org.sonatype.flexmojos", "flexmojos-maven-plugin", "test-run") || mojo.is("org.eclipse.tycho", "tycho-surefire-plugin", "test") || mojo.is("org.sonatype.tycho", "maven-osgi-test-plugin", "test") || mojo.is("org.codehaus.mojo", "gwt-maven-plugin", "test") || mojo.is("com.jayway.maven.plugins.android.generation2", "maven-android-plugin", "internal-integration-test") || mojo.is("com.jayway.maven.plugins.android.generation2", "android-maven-plugin", "internal-integration-test") || mojo.is("org.apache.maven.plugins", "maven-surefire-plugin", "test") || mojo.is("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test"))) {
            return false;
        }
        try {
            if (mojo.is("org.apache.maven.plugins", "maven-surefire-plugin", "test")) {
                Boolean skipTests;
                Boolean skipExec;
                Boolean skip = mojo.getConfigurationValue("skip", Boolean.class);
                if (skip != null && skip.booleanValue()) {
                    return false;
                }
                if (mojo.pluginName.version.compareTo("2.3") >= 0 && (skipExec = mojo.getConfigurationValue("skipExec", Boolean.class)) != null && skipExec.booleanValue()) {
                    return false;
                }
                if (mojo.pluginName.version.compareTo("2.4") >= 0 && (skipTests = mojo.getConfigurationValue("skipTests", Boolean.class)) != null && skipTests.booleanValue()) {
                    return false;
                }
            } else if (mojo.is("com.sun.maven", "maven-junit-plugin", "test")) {
                Boolean skipTests = mojo.getConfigurationValue("skipTests", Boolean.class);
                if (skipTests != null && skipTests.booleanValue()) {
                    return false;
                }
            } else if (mojo.is("org.sonatype.flexmojos", "flexmojos-maven-plugin", "test-run")) {
                Boolean skipTests = mojo.getConfigurationValue("skipTest", Boolean.class);
                if (skipTests != null && skipTests.booleanValue()) {
                    return false;
                }
            } else if (mojo.is("org.sonatype.tycho", "maven-osgi-test-plugin", "test")) {
                Boolean skipTests = mojo.getConfigurationValue("skipTest", Boolean.class);
                if (skipTests != null && skipTests.booleanValue()) {
                    return false;
                }
            } else if (mojo.is("org.eclipse.tycho", "tycho-surefire-plugin", "test")) {
                Boolean skipTests = mojo.getConfigurationValue("skipTest", Boolean.class);
                if (skipTests != null && skipTests.booleanValue()) {
                    return false;
                }
            } else if (mojo.is("com.jayway.maven.plugins.android.generation2", "android-maven-plugin", "internal-integration-test")) {
                Boolean skipTests = mojo.getConfigurationValue("skipTests", Boolean.class);
                if (skipTests != null && skipTests.booleanValue()) {
                    return false;
                }
            } else if (mojo.is("com.jayway.maven.plugins.android.generation2", "maven-android-plugin", "internal-integration-test")) {
                if (mojo.pluginName.version.compareTo("3.0.0-alpha-6") < 0) {
                    return false;
                }
                Boolean skipTests = mojo.getConfigurationValue("skipTests", Boolean.class);
                if (skipTests != null && skipTests.booleanValue()) {
                    return false;
                }
            } else if (mojo.is("org.codehaus.mojo", "gwt-maven-plugin", "test") && mojo.pluginName.version.compareTo("1.2") < 0) {
                return false;
            }
        }
        catch (ComponentConfigurationException e) {
            return false;
        }
        return true;
    }

    protected Object readResolve() {
        this.fileSets = new ConcurrentHashMap<File, FileSet>();
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return Messages.SurefireArchiver_DisplayName();
        }

        public SurefireArchiver newAutoInstance(MavenModule module) {
            return new SurefireArchiver();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FactoryImpl
    implements MavenProjectActionBuilder {
        FactoryImpl() {
        }

        @Override
        public Collection<? extends Action> getProjectActions(MavenModule module) {
            return Collections.singleton(new TestResultProjectAction((AbstractProject)module));
        }
    }
}

