/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Util;
import hudson.maven.MavenModule;
import hudson.maven.ModuleName;
import hudson.maven.MojoInfo;
import hudson.remoting.Which;
import hudson.util.ReflectionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.classworlds.ClassRealm;
import org.kohsuke.stapler.Stapler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutedMojo
implements Serializable {
    private static final long serialVersionUID = -3048316415397586490L;
    public final String groupId;
    public final String artifactId;
    public final String version;
    public final String goal;
    public final String executionId;
    public final long duration;
    public final String digest;
    private static final Logger LOGGER = Logger.getLogger(ExecutedMojo.class.getName());

    public ExecutedMojo(MojoInfo mojo, long duration) {
        this.groupId = mojo.pluginName.groupId;
        this.artifactId = mojo.pluginName.artifactId;
        this.version = mojo.pluginName.version;
        this.goal = mojo.getGoal();
        this.executionId = mojo.mojoExecution.getExecutionId();
        this.duration = duration;
        String digest = null;
        MojoDescriptor md = mojo.mojoExecution.getMojoDescriptor();
        PluginDescriptor pd = md.getPluginDescriptor();
        try {
            Class<?> clazz = this.getMojoClass(md, pd);
            if (clazz != null) {
                File jarFile = Which.jarFile(clazz);
                if (jarFile.isFile()) {
                    digest = Util.getDigestOf((InputStream)new FileInputStream(jarFile));
                } else {
                    LOGGER.log(Level.WARNING, "Cannot calculate digest of mojo class, because mojo wasn't loaded from a jar, but from: " + jarFile);
                }
            } else {
                LOGGER.log(Level.WARNING, "Failed to getClass for " + md.getImplementation());
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Failed to locate jar for " + md.getImplementation(), e);
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to calculate digest for " + md.getImplementation(), e);
        }
        this.digest = digest;
    }

    private Class<?> getMojoClass(MojoDescriptor md, PluginDescriptor pd) throws ClassNotFoundException {
        try {
            org.codehaus.plexus.classworlds.realm.ClassRealm classRealm = pd.getClassRealm();
            return classRealm == null ? null : classRealm.loadClass(md.getImplementation());
        }
        catch (NoSuchMethodError e) {
            return this.getMojoClassForMaven2(md, pd);
        }
    }

    private Class<?> getMojoClassForMaven2(MojoDescriptor md, PluginDescriptor pd) throws ClassNotFoundException {
        Method method = ReflectionUtils.getPublicMethodNamed(pd.getClass(), (String)"getClassRealm");
        ClassRealm cl = (ClassRealm)ReflectionUtils.invokeMethod((Method)method, (Object)pd);
        if (cl == null) {
            return null;
        }
        Class clazz = cl.loadClass(md.getImplementation());
        return clazz;
    }

    private ExecutedMojo(String groupId, String artifactId, String version, String goal, String executionId, long duration, String digest) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.goal = goal;
        this.executionId = executionId;
        this.duration = duration;
        this.digest = digest;
    }

    protected Object readResolve() {
        return new ExecutedMojo(Util.intern((String)this.groupId), Util.intern((String)this.artifactId), Util.intern((String)this.version), Util.intern((String)this.goal), Util.intern((String)this.executionId), this.duration, Util.intern((String)this.digest));
    }

    public String getDurationString() {
        return Util.getTimeSpanString((long)this.duration);
    }

    public String getReadableExecutionId() {
        if (this.executionId == null) {
            return "-";
        }
        return this.executionId;
    }

    public String getPluginLink(Cache c) {
        MavenModule m = c.get(this);
        if (m != null) {
            return Stapler.getCurrentRequest().getContextPath() + m.getUrl();
        }
        if (this.groupId.equals("org.apache.maven.plugins")) {
            return "http://maven.apache.org/plugins/" + this.artifactId + '/';
        }
        if (this.groupId.equals("org.codehaus.mojo")) {
            return "http://mojo.codehaus.org/" + this.artifactId + '/';
        }
        return null;
    }

    public String getGoalLink(Cache c) {
        if (this.groupId.equals("org.apache.maven.plugins")) {
            return "http://maven.apache.org/plugins/" + this.artifactId + '/' + this.goal + "-mojo.html";
        }
        if (this.groupId.equals("org.codehaus.mojo")) {
            return "http://mojo.codehaus.org/" + this.artifactId + '/' + this.goal + "-mojo.html";
        }
        return null;
    }

    public static final class Cache {
        public final Map<ModuleName, MavenModule> modules = new HashMap<ModuleName, MavenModule>();

        public Cache() {
            for (MavenModule m : Jenkins.getInstance().getAllItems(MavenModule.class)) {
                this.modules.put(m.getModuleName(), m);
            }
        }

        public MavenModule get(ExecutedMojo mojo) {
            return this.modules.get(new ModuleName(mojo.groupId, mojo.artifactId));
        }
    }
}

