/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.ExecutedMojo;
import hudson.maven.FilteredChangeLogSet;
import hudson.maven.Maven3ProcessFactory;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuildProxy2;
import hudson.maven.MavenBuilder;
import hudson.maven.MavenInformation;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenProcessFactory;
import hudson.maven.MavenProjectActionBuilder;
import hudson.maven.MavenReportInfo;
import hudson.maven.MavenReporter;
import hudson.maven.MavenUtil;
import hudson.maven.MavenVersionCallable;
import hudson.maven.Messages;
import hudson.maven.ModuleName;
import hudson.maven.MojoInfo;
import hudson.maven.ProcessCache;
import hudson.maven.RedeployPublisher;
import hudson.maven.SplittableBuildListener;
import hudson.maven.UnbuiltModuleAction;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.maven.reporters.SurefireArchiver;
import hudson.maven.reporters.TestFailureDetector;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Environment;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.scm.ChangeLogSet;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import hudson.util.DescribableList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import jenkins.mvn.SettingsProvider;
import org.apache.maven.BuildFailureException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenBuild
extends AbstractMavenBuild<MavenModule, MavenBuild> {
    List<MavenProjectActionBuilder> projectActionReporters;
    private List<ExecutedMojo> executedMojos;
    private static final int MAX_PROCESS_CACHE = 5;
    protected static final ProcessCache mavenProcessCache = new ProcessCache(5);
    public static boolean debug = false;
    private static final Logger LOGGER = Logger.getLogger(MavenBuild.class.getName());

    public MavenBuild(MavenModule job) throws IOException {
        super(job);
    }

    public MavenBuild(MavenModule job, Calendar timestamp) {
        super(job, timestamp);
    }

    public MavenBuild(MavenModule project, File buildDir) throws IOException {
        super(project, buildDir);
        SurefireArchiver.fixUp(this.projectActionReporters);
    }

    public String getUpUrl() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof MavenModuleSetBuild)) continue;
                return ((Ancestor)ancs.get(i - 1)).getUrl() + '/';
            }
        }
        return super.getUpUrl();
    }

    public String getDisplayName() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof MavenModuleSetBuild)) continue;
                return this.getParent().getDisplayName();
            }
        }
        return super.getDisplayName();
    }

    public MavenModuleSetBuild getParentBuild() {
        return (MavenModuleSetBuild)this.getParent().getParent().getBuildByNumber(this.getNumber());
    }

    public AbstractBuild<?, ?> getRootBuild() {
        return this.getParentBuild();
    }

    public MavenModuleSetBuild getModuleSetBuild() {
        return (MavenModuleSetBuild)this.getParent().getParent().getNearestOldBuild(this.getNumber());
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return new FilteredChangeLogSet(this);
    }

    public boolean hasChangeSetComputed() {
        return true;
    }

    @Exported
    public MavenArtifactRecord getMavenArtifacts() {
        return (MavenArtifactRecord)this.getAction(MavenArtifactRecord.class);
    }

    @Override
    public EnvVars getEnvironment(TaskListener log) throws IOException, InterruptedException {
        EnvVars envs = super.getEnvironment(log);
        Maven.MavenInstallation mvn = ((MavenModule)this.project).getParent().getMaven();
        if (mvn == null) {
            throw new AbortException(Messages.MavenModuleSetBuild_NoMavenConfigured());
        }
        mvn = mvn.forEnvironment(envs).forNode(Computer.currentComputer().getNode(), log);
        mvn.buildEnvVars(envs);
        return envs;
    }

    public void registerAsProjectAction(MavenReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenProjectActionBuilder>();
        }
        this.projectActionReporters.add(reporter);
    }

    public void registerAsProjectAction(MavenProjectActionBuilder builder) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenProjectActionBuilder>();
        }
        this.projectActionReporters.add(builder);
    }

    public List<MavenProjectActionBuilder> getProjectActionBuilders() {
        if (this.projectActionReporters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.projectActionReporters);
    }

    public List<ExecutedMojo> getExecutedMojos() {
        if (this.executedMojos == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.executedMojos);
    }

    public void run() {
        this.execute((Run.RunExecution)new MavenBuildExecution());
        ((MavenModule)this.getProject()).updateTransientActions();
        MavenModuleSetBuild parentBuild = this.getModuleSetBuild();
        if (parentBuild != null) {
            parentBuild.notifyModuleBuild(this);
        }
    }

    public String getWhyKeepLog() {
        MavenModuleSetBuild pb = this.getParentBuild();
        if (pb != null && pb.getWhyKeepLog() != null) {
            return Messages.MavenBuild_KeptBecauseOfParent((Object)pb);
        }
        return super.getWhyKeepLog();
    }

    public static ExecutedMojo.Cache createExecutedMojoCache() {
        return new ExecutedMojo.Cache();
    }

    protected void setWorkspace(FilePath path) {
        super.setWorkspace(path);
    }

    public MavenModule getParent() {
        return (MavenModule)super.getParent();
    }

    protected void setBuiltOnStr(String builtOn) {
        super.setBuiltOnStr(builtOn);
    }

    @Override
    public String getMavenOpts(TaskListener listener, EnvVars envVars) {
        return envVars.expand(this.expandTokens(listener, ((MavenModule)this.getProject()).getParent().getMavenOpts()));
    }

    private class MavenBuildExecution
    extends AbstractBuild.AbstractBuildExecution {
        private List<MavenReporter> reporters;

        private MavenBuildExecution() {
            super((AbstractBuild)MavenBuild.this);
        }

        public MavenBuild getBuild() {
            return (MavenBuild)super.getBuild();
        }

        public MavenModule getProject() {
            return (MavenModule)super.getProject();
        }

        protected WorkspaceList.Lease decideWorkspace(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            return wsl.allocate(MavenBuild.this.getModuleSetBuild().getModuleRoot().child(this.getProject().getRelativePath()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Result doRun(BuildListener listener) throws Exception {
            Result result;
            block15: {
                ProcessCache.MavenProcess process;
                block14: {
                    String settingsPath;
                    this.reporters = this.getProject().createReporters();
                    MavenModuleSet mms = this.getProject().getParent();
                    if (debug) {
                        listener.getLogger().println("Reporters=" + this.reporters);
                    }
                    for (BuildWrapper w : mms.getBuildWrappersList()) {
                        BuildWrapper.Environment e = w.setUp((AbstractBuild)MavenBuild.this, this.launcher, listener);
                        if (e == null) {
                            return Result.FAILURE;
                        }
                        MavenBuild.this.buildEnvironments.add(e);
                    }
                    EnvVars envVars = MavenBuild.this.getEnvironment((TaskListener)listener);
                    Maven.MavenInstallation mvn = this.getProject().getParent().getMaven();
                    mvn = mvn.forEnvironment(envVars).forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
                    MavenInformation mavenInformation = (MavenInformation)MavenBuild.this.getModuleRoot().act((Callable)new MavenVersionCallable(mvn.getHome()));
                    String mavenVersion = mavenInformation.getVersion();
                    LOGGER.fine(MavenBuild.this.getFullDisplayName() + " is building with mavenVersion " + mavenVersion + " from file " + mavenInformation.getVersionResourcePath());
                    boolean maven3orLater = MavenUtil.maven3orLater(mavenVersion);
                    process = mavenProcessCache.get(this.launcher.getChannel(), listener, (ProcessCache.Factory)((Object)(maven3orLater ? new Maven3ProcessFactory(MavenBuild.this.getParent().getParent(), this.launcher, envVars, MavenBuild.this.getMavenOpts((TaskListener)listener, envVars), null) : new MavenProcessFactory(MavenBuild.this.getParent().getParent(), this.launcher, envVars, MavenBuild.this.getMavenOpts((TaskListener)listener, envVars), null))));
                    ArgumentListBuilder margs = new ArgumentListBuilder(new String[]{"-N", "-B"});
                    FilePath localRepo = mms.getLocalRepository().locate(MavenBuild.this);
                    if (localRepo != null) {
                        margs.add("-Dmaven.repo.local=" + localRepo.getRemote());
                    }
                    if ((settingsPath = SettingsProvider.getSettingsRemotePath((SettingsProvider)mms.getSettings(), (AbstractBuild)MavenBuild.this, (TaskListener)listener)) != null) {
                        margs.add("-s").add(settingsPath);
                    }
                    margs.add(new String[]{"-f", MavenBuild.this.getModuleRoot().child("pom.xml").getRemote()});
                    margs.addTokenized(this.getProject().getGoals());
                    HashMap<String, String> systemProps = new HashMap<String, String>((Map<String, String>)envVars);
                    systemProps.put("hudson.build.number", String.valueOf(MavenBuild.this.getNumber()));
                    if (maven3orLater) {
                        listener.getLogger().println("Building single Maven modules is not implemented for Maven 3, yet!");
                        return Result.ABORTED;
                    }
                    boolean normalExit = false;
                    try {
                        Result r = (Result)process.call(new Builder(listener, new ProxyImpl(), this.getProject(), margs.toList(), systemProps));
                        normalExit = true;
                        result = r;
                        Object var17_16 = null;
                        if (!normalExit) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var17_17 = null;
                        if (normalExit) {
                            process.recycle();
                        } else {
                            process.discard();
                        }
                        boolean failed = false;
                        for (int i = MavenBuild.this.buildEnvironments.size() - 1; i >= 0; --i) {
                            if (((Environment)MavenBuild.this.buildEnvironments.get(i)).tearDown((AbstractBuild)MavenBuild.this, listener)) continue;
                            failed = true;
                        }
                        if (failed) {
                            return Result.FAILURE;
                        }
                        throw throwable;
                    }
                    process.recycle();
                    break block15;
                }
                process.discard();
            }
            boolean failed = false;
            for (int i = MavenBuild.this.buildEnvironments.size() - 1; i >= 0; --i) {
                if (((Environment)MavenBuild.this.buildEnvironments.get(i)).tearDown((AbstractBuild)MavenBuild.this, listener)) continue;
                failed = true;
            }
            if (failed) {
                return Result.FAILURE;
            }
            return result;
        }

        public void post2(BuildListener listener) throws Exception {
            if (this.reporters != null) {
                for (MavenReporter reporter : this.reporters) {
                    reporter.end(MavenBuild.this, this.launcher, listener);
                }
            }
        }
    }

    public class ProxyImpl2
    extends ProxyImpl
    implements MavenBuildProxy2 {
        private static final long serialVersionUID = -3377221864644014218L;
        private final SplittableBuildListener listener;
        long startTime;
        private final OutputStream log;
        private final MavenModuleSetBuild parentBuild;

        ProxyImpl2(MavenModuleSetBuild parentBuild, SplittableBuildListener listener) throws FileNotFoundException {
            this.parentBuild = parentBuild;
            this.listener = listener;
            this.log = new FileOutputStream(MavenBuild.this.getLogFile());
        }

        public void start() {
            MavenBuild.this.onStartBuilding();
            this.startTime = System.currentTimeMillis();
            try {
                this.sync();
                this.listener.setSideOutputStream(this.log);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void end() {
            if (MavenBuild.this.result == null) {
                this.setResult(Result.SUCCESS);
            }
            MavenBuild.this.onEndBuilding();
            MavenBuild.this.duration += System.currentTimeMillis() - this.startTime;
            this.parentBuild.notifyModuleBuild(MavenBuild.this);
            try {
                this.sync();
                this.listener.setSideOutputStream(null);
                MavenBuild.this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void appendLastLog() {
            try {
                this.sync();
                this.listener.setSideOutputStream(this.log);
                this.listener.setSideOutputStream(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void sync() throws IOException {
            try {
                Channel ch = Channel.current();
                if (ch != null) {
                    this.listener.synchronizeOnMark(ch);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        protected void close() {
            try {
                this.sync();
                this.log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (MavenBuild.this.hasntStartedYet()) {
                MavenBuild.this.execute(new Run.RunExecution(){

                    public Result run(BuildListener listener) {
                        listener.getLogger().println(Messages.MavenBuild_FailedEarlier());
                        return Result.NOT_BUILT;
                    }

                    public void post(BuildListener listener) {
                    }

                    public void cleanUp(BuildListener listener) {
                    }
                });
            }
            this.rememberModulesToBuildAgainNextTime();
        }

        private void rememberModulesToBuildAgainNextTime() {
            MavenModuleSetBuild moduleSetBuild = MavenBuild.this.getModuleSetBuild();
            if (moduleSetBuild == null) {
                return;
            }
            if (MavenBuild.this.hasntStartedYet()) {
                if (moduleSetBuild.getParent().isIncrementalBuild() && moduleSetBuild.getResult() != Result.SUCCESS && moduleSetBuild.getResult() != Result.UNSTABLE) {
                    UnbuiltModuleAction action = (UnbuiltModuleAction)moduleSetBuild.getAction(UnbuiltModuleAction.class);
                    if (action == null) {
                        action = new UnbuiltModuleAction();
                        moduleSetBuild.getActions().add(action);
                    }
                    action.addUnbuiltModule(MavenBuild.this.getParent().getModuleName());
                }
            } else {
                UnbuiltModuleAction unbuiltModuleAction;
                MavenModuleSetBuild previousParentBuild = (MavenModuleSetBuild)moduleSetBuild.getPreviousBuild();
                if (previousParentBuild != null && (unbuiltModuleAction = (UnbuiltModuleAction)previousParentBuild.getAction(UnbuiltModuleAction.class)) != null) {
                    unbuiltModuleAction.removeUnbuildModule(MavenBuild.this.getParent().getModuleName());
                    try {
                        previousParentBuild.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (moduleSetBuild.getParent().isIncrementalBuild() && moduleSetBuild.getResult() != Result.SUCCESS) {
                    MavenModuleSet mavenModuleSet = moduleSetBuild.getParent();
                    boolean isDeploying = false;
                    Result deploymentThreshold = Result.SUCCESS;
                    DescribableList<Publisher, Descriptor<Publisher>> publishers = mavenModuleSet.getPublishersList();
                    for (Publisher publisher : publishers) {
                        if (!(publisher instanceof RedeployPublisher)) continue;
                        isDeploying = true;
                        deploymentThreshold = ((RedeployPublisher)publisher).getTreshold();
                        break;
                    }
                    if (isDeploying && moduleSetBuild.getResult().isWorseThan(deploymentThreshold)) {
                        UnbuiltModuleAction action = (UnbuiltModuleAction)moduleSetBuild.getAction(UnbuiltModuleAction.class);
                        if (action == null) {
                            action = new UnbuiltModuleAction();
                            moduleSetBuild.getActions().add(action);
                        }
                        action.addUnbuiltModule(MavenBuild.this.getParent().getModuleName());
                    }
                }
            }
        }

        public MavenBuild owner() {
            return MavenBuild.this;
        }

        private Object writeReplace() {
            return Channel.current().export(MavenBuildProxy2.class, Executor.currentExecutor().newImpersonatingProxy(MavenBuildProxy2.class, (Object)this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProxyImpl
    implements MavenBuildProxy,
    Serializable {
        private static final long serialVersionUID = 8865133776526671879L;

        ProxyImpl() {
        }

        @Override
        public <V, T extends Throwable> V execute(MavenBuildProxy.BuildCallable<V, T> program) throws T, IOException, InterruptedException {
            return program.call(MavenBuild.this);
        }

        @Override
        public final void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
            throw new AssertionError();
        }

        @Override
        public FilePath getRootDir() {
            return new FilePath(MavenBuild.this.getRootDir());
        }

        @Override
        public FilePath getProjectRootDir() {
            return new FilePath(MavenBuild.this.getParent().getRootDir());
        }

        @Override
        public FilePath getModuleSetRootDir() {
            return new FilePath(MavenBuild.this.getParent().getParent().getRootDir());
        }

        @Override
        public FilePath getArtifactsDir() {
            return new FilePath(MavenBuild.this.getArtifactsDir());
        }

        @Override
        public void setResult(Result result) {
            MavenBuild.this.setResult(result);
        }

        @Override
        public Calendar getTimestamp() {
            return MavenBuild.this.getTimestamp();
        }

        @Override
        public long getMilliSecsSinceBuildStart() {
            return System.currentTimeMillis() - this.getTimestamp().getTimeInMillis();
        }

        @Override
        public boolean isArchivingDisabled() {
            return MavenBuild.this.getParent().getParent().isArchivingDisabled();
        }

        @Override
        public void registerAsProjectAction(MavenReporter reporter) {
            MavenBuild.this.registerAsProjectAction(reporter);
        }

        @Override
        public void registerAsProjectAction(MavenProjectActionBuilder builder) {
            MavenBuild.this.registerAsProjectAction(builder);
        }

        @Override
        public void registerAsAggregatedProjectAction(MavenReporter reporter) {
            MavenModuleSetBuild pb = MavenBuild.this.getParentBuild();
            if (pb != null) {
                pb.registerAsProjectAction(reporter);
            }
        }

        @Override
        public void setExecutedMojos(List<ExecutedMojo> executedMojos) {
            MavenBuild.this.executedMojos = executedMojos;
        }

        private Object writeReplace() {
            return Channel.current().export(MavenBuildProxy.class, (Object)this);
        }

        @Override
        public MavenBuildInformation getMavenBuildInformation() {
            return new MavenBuildInformation(MavenBuild.this.getModuleSetBuild().getMavenVersionUsed());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Builder
    extends MavenBuilder {
        private final MavenBuildProxy buildProxy;
        private final AtomicBoolean hasTestFailures = new AtomicBoolean();
        private final List<ExecutedMojo> executedMojos = new ArrayList<ExecutedMojo>();
        private final ModuleName moduleName;
        private long startTime;
        private static final long serialVersionUID = 1L;

        public Builder(BuildListener listener, MavenBuildProxy buildProxy, MavenModule module, List<String> goals, Map<String, String> systemProps) {
            super(listener, Collections.singleton(module), goals, systemProps);
            this.buildProxy = new FilterImpl(buildProxy);
            this.moduleName = module.getModuleName();
        }

        @Override
        void preBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                r.preBuild(this.buildProxy, rm.getTopLevelProject(), this.listener);
            }
        }

        @Override
        void postBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            this.buildProxy.setExecutedMojos(this.executedMojos);
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                r.postBuild(this.buildProxy, rm.getTopLevelProject(), this.listener);
            }
        }

        @Override
        void preExecute(MavenProject project, MojoInfo info) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.preExecute(this.buildProxy, project, info, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
            this.startTime = System.currentTimeMillis();
        }

        @Override
        void postExecute(MavenProject project, MojoInfo info, Exception exception) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            this.executedMojos.add(new ExecutedMojo(info, System.currentTimeMillis() - this.startTime));
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (!r.postExecute(this.buildProxy, project, info, this.listener, exception)) {
                    throw new hudson.maven.agent.AbortException(r + " failed");
                }
                if (!(r instanceof TestFailureDetector) || !((TestFailureDetector)r).hasTestFailures()) continue;
                this.hasTestFailures.compareAndSet(false, true);
            }
        }

        @Override
        void onReportGenerated(MavenProject project, MavenReportInfo report) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.reportGenerated(this.buildProxy, project, report, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
        }

        @Override
        void preModule(MavenProject project) throws InterruptedException, IOException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.enterModule(this.buildProxy, project, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
        }

        @Override
        void postModule(MavenProject project) throws InterruptedException, IOException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.leaveModule(this.buildProxy, project, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
        }

        @Override
        public boolean hasBuildFailures() {
            return this.hasTestFailures.get();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FilterImpl
        extends MavenBuildProxy.Filter<MavenBuildProxy>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            public FilterImpl(MavenBuildProxy buildProxy) {
                super(buildProxy);
            }

            @Override
            public void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
                Builder.this.recordAsynchronousExecution(Channel.current().callAsync((Callable)new MavenBuildProxy.Filter.AsyncInvoker(this.core, program)));
            }
        }
    }
}

