/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.FilePath;
import hudson.maven.ExecutedMojo;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenProjectActionBuilder;
import hudson.maven.MavenReporter;
import hudson.model.Result;
import hudson.remoting.DelegatingCallable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MavenBuildProxy {
    public <V, T extends Throwable> V execute(BuildCallable<V, T> var1) throws T, IOException, InterruptedException;

    public void executeAsync(BuildCallable<?, ?> var1) throws IOException;

    public FilePath getRootDir();

    public FilePath getProjectRootDir();

    public FilePath getModuleSetRootDir();

    public FilePath getArtifactsDir();

    public void setResult(Result var1);

    public Calendar getTimestamp();

    public long getMilliSecsSinceBuildStart();

    public boolean isArchivingDisabled();

    public void registerAsProjectAction(MavenReporter var1);

    public void registerAsProjectAction(MavenProjectActionBuilder var1);

    public void registerAsAggregatedProjectAction(MavenReporter var1);

    public void setExecutedMojos(List<ExecutedMojo> var1);

    public MavenBuildInformation getMavenBuildInformation();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Filter<CORE extends MavenBuildProxy>
    implements MavenBuildProxy,
    Serializable {
        protected final CORE core;
        private static final long serialVersionUID = 1L;

        protected Filter(CORE core) {
            this.core = core;
        }

        @Override
        public <V, T extends Throwable> V execute(BuildCallable<V, T> program) throws T, IOException, InterruptedException {
            return this.core.execute(program);
        }

        @Override
        public void executeAsync(BuildCallable<?, ?> program) throws IOException {
            this.core.executeAsync(program);
        }

        @Override
        public FilePath getRootDir() {
            return this.core.getRootDir();
        }

        @Override
        public FilePath getProjectRootDir() {
            return this.core.getProjectRootDir();
        }

        @Override
        public FilePath getModuleSetRootDir() {
            return this.core.getModuleSetRootDir();
        }

        @Override
        public FilePath getArtifactsDir() {
            return this.core.getArtifactsDir();
        }

        @Override
        public void setResult(Result result) {
            this.core.setResult(result);
        }

        @Override
        public Calendar getTimestamp() {
            return this.core.getTimestamp();
        }

        @Override
        public long getMilliSecsSinceBuildStart() {
            return this.core.getMilliSecsSinceBuildStart();
        }

        @Override
        public boolean isArchivingDisabled() {
            return this.core.isArchivingDisabled();
        }

        @Override
        public void registerAsProjectAction(MavenReporter reporter) {
            this.core.registerAsProjectAction(reporter);
        }

        @Override
        public void registerAsProjectAction(MavenProjectActionBuilder builder) {
            this.core.registerAsProjectAction(builder);
        }

        @Override
        public void registerAsAggregatedProjectAction(MavenReporter reporter) {
            this.core.registerAsAggregatedProjectAction(reporter);
        }

        @Override
        public void setExecutedMojos(List<ExecutedMojo> executedMojos) {
            this.core.setExecutedMojos(executedMojos);
        }

        @Override
        public MavenBuildInformation getMavenBuildInformation() {
            return this.core.getMavenBuildInformation();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static final class AsyncInvoker
        implements DelegatingCallable<Object, Throwable> {
            private final MavenBuildProxy proxy;
            private final BuildCallable<?, ?> program;
            private static final long serialVersionUID = 1L;

            public AsyncInvoker(MavenBuildProxy proxy, BuildCallable<?, ?> program) {
                this.proxy = proxy;
                this.program = program;
            }

            public ClassLoader getClassLoader() {
                return this.program.getClass().getClassLoader();
            }

            public Object call() throws Throwable {
                this.proxy.execute(this.program);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BuildCallable<V, T extends Throwable>
    extends Serializable {
        public V call(MavenBuild var1) throws T, IOException, InterruptedException;
    }
}

