/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Extension;
import hudson.Launcher;
import hudson.maven.MavenModuleSet;
import hudson.maven.reporters.SurefireReport;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResultAction;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenTestDataPublisher
extends Recorder {
    private final DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers;

    public MavenTestDataPublisher(DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers) {
        this.testDataPublishers = testDataPublishers;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SurefireReport report = (SurefireReport)build.getAction(SurefireReport.class);
        if (report == null) {
            return true;
        }
        ArrayList<TestResultAction.Data> data = new ArrayList<TestResultAction.Data>();
        if (this.testDataPublishers != null) {
            for (TestDataPublisher tdp : this.testDataPublishers) {
                TestResultAction.Data d = tdp.getTestData(build, launcher, listener, report.getResult());
                if (d == null) continue;
                data.add(d);
            }
        }
        report.setData(data);
        return true;
    }

    public DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> getTestDataPublishers() {
        return this.testDataPublishers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Additional test report features";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return MavenModuleSet.class.isAssignableFrom(jobType) && !TestDataPublisher.all().isEmpty();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            DescribableList testDataPublishers = new DescribableList(Saveable.NOOP);
            try {
                testDataPublishers.rebuild(req, formData, (List)TestDataPublisher.all());
            }
            catch (IOException e) {
                throw new Descriptor.FormException((Throwable)e, null);
            }
            return new MavenTestDataPublisher((DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>>)testDataPublishers);
        }
    }
}

