/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.console.AnnotatedLargeText;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenUtil;
import hudson.maven.RedeployPublisher;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.maven.reporters.Messages;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Api;
import hudson.model.BallColor;
import hudson.model.BuildBadgeAction;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.Iterators;
import hudson.widgets.HistoryWidget;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MavenAbstractArtifactRecord<T extends AbstractBuild<?, ?>>
extends TaskAction
implements BuildBadgeAction {
    @Exported
    public final CopyOnWriteArrayList<Record> records = new CopyOnWriteArrayList();
    private static final HistoryWidget.Adapter<Record> ADAPTER = new HistoryWidget.Adapter<Record>(){

        public int compare(Record record, String key) {
            return record.getNumber() - Integer.parseInt(key);
        }

        public String getKey(Record record) {
            return String.valueOf(record.getNumber());
        }

        public boolean isBuilding(Record record) {
            return record.isBuilding();
        }

        public String getNextKey(String key) {
            return String.valueOf(Integer.parseInt(key) + 1);
        }
    };
    public static final Permission REDEPLOY = AbstractProject.BUILD;
    public static boolean debug = Boolean.getBoolean(MavenArtifactRecord.class.getName() + ".debug");

    public abstract T getBuild();

    protected ACL getACL() {
        return this.getBuild().getACL();
    }

    public final String getIconFileName() {
        return "redo.gif";
    }

    public final String getDisplayName() {
        return Messages.MavenAbstractArtifactRecord_Displayname();
    }

    public final String getUrlName() {
        return "redeploy";
    }

    protected Permission getPermission() {
        return REDEPLOY;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public boolean hasBadge() {
        if (this.records != null) {
            for (Record record : this.records) {
                if (!Result.SUCCESS.equals(record.result)) continue;
                return true;
            }
        }
        return false;
    }

    public HistoryWidgetImpl getHistoryWidget() {
        return new HistoryWidgetImpl();
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.records.get(Integer.valueOf(token));
    }

    public final HttpResponse doRedeploy(final @QueryParameter(value="_.id") String id, final @QueryParameter(value="_.url") String repositoryUrl, final @QueryParameter(value="_.uniqueVersion") boolean uniqueVersion) throws ServletException, IOException {
        this.getACL().checkPermission(REDEPLOY);
        File logFile = new File(this.getBuild().getRootDir(), "maven-deployment." + this.records.size() + ".log");
        final Record record = new Record(repositoryUrl, logFile.getName());
        this.records.add(record);
        new TaskThread(this, TaskThread.ListenerAndText.forFile((File)logFile, (TaskAction)this)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void perform(TaskListener listener) throws Exception {
                try {
                    MavenEmbedder embedder = MavenUtil.createEmbedder(listener, MavenAbstractArtifactRecord.this.getBuild());
                    ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)embedder.lookup(ArtifactRepositoryLayout.class, "default");
                    ArtifactRepositoryFactory factory = (ArtifactRepositoryFactory)embedder.lookup(ArtifactRepositoryFactory.ROLE);
                    ArtifactRepository repository = factory.createDeploymentArtifactRepository(id, repositoryUrl, layout, uniqueVersion);
                    RedeployPublisher.WrappedArtifactRepository repo = new RedeployPublisher.WrappedArtifactRepository(repository, uniqueVersion);
                    MavenAbstractArtifactRecord.this.deploy(embedder, repo, listener);
                    record.result = Result.SUCCESS;
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (record.result == null) {
                        record.result = Result.FAILURE;
                    }
                    MavenAbstractArtifactRecord.this.getBuild().save();
                    throw throwable;
                }
                if (record.result == null) {
                    record.result = Result.FAILURE;
                }
                MavenAbstractArtifactRecord.this.getBuild().save();
            }
        }.start();
        return HttpRedirect.DOT;
    }

    public abstract void deploy(MavenEmbedder var1, ArtifactRepository var2, TaskListener var3) throws MavenEmbedderException, IOException, ComponentLookupException, ArtifactDeploymentException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HistoryWidgetImpl
    extends HistoryWidget<MavenAbstractArtifactRecord, Record> {
        private HistoryWidgetImpl() {
            super((ModelObject)MavenAbstractArtifactRecord.this, Iterators.reverse(MavenAbstractArtifactRecord.this.records), ADAPTER);
        }

        public String getDisplayName() {
            return Messages.HistoryWidgetImpl_Displayname();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean
    public final class Record {
        @Exported
        public final String url;
        private final String fileName;
        private Result result;
        private final Calendar timeStamp;

        public Record(String url, String fileName) {
            this.url = url;
            this.fileName = fileName;
            this.timeStamp = new GregorianCalendar();
        }

        public AnnotatedLargeText<Record> getLog() {
            return new AnnotatedLargeText(new File(MavenAbstractArtifactRecord.this.getBuild().getRootDir(), this.fileName), Charset.defaultCharset(), true, (Object)this);
        }

        @Exported
        public Result getResult() {
            return this.result;
        }

        @Exported
        public int getNumber() {
            return MavenAbstractArtifactRecord.this.records.indexOf(this);
        }

        @Exported
        public boolean isBuilding() {
            return this.result == null;
        }

        @Exported
        public Calendar getTimestamp() {
            return (Calendar)this.timeStamp.clone();
        }

        @Exported
        public String getBuildStatusUrl() {
            return this.getIconColor().getImage();
        }

        @Exported
        public BallColor getIconColor() {
            if (this.result == null) {
                return BallColor.GREY_ANIME;
            }
            return this.result.color;
        }

        public void doIndex(StaplerResponse rsp) throws IOException {
            rsp.setContentType("text/plain;charset=UTF-8");
            this.getLog().writeLogTo(0L, (Writer)rsp.getWriter());
        }
    }
}

