/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.Extension;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.FingerprintMap;
import hudson.tasks.Fingerprinter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilderConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenFingerprinter
extends MavenReporter {
    private transient Set<File> files;
    private transient Map<String, String> used;
    private transient Map<String, String> produced;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MavenFingerprinter.class.getName());

    @Override
    public boolean preBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) throws InterruptedException, IOException {
        this.files = new HashSet<File>();
        this.used = new HashMap<String, String>();
        this.produced = new HashMap<String, String>();
        return true;
    }

    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        this.record(pom.getArtifacts(), this.used);
        this.record(pom.getArtifact(), this.produced);
        this.record(pom.getAttachedArtifacts(), this.produced);
        this.record(pom.getGroupId() + ":" + pom.getArtifactId(), pom.getFile(), this.produced);
        return true;
    }

    @Override
    public boolean postBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) throws InterruptedException, IOException {
        this.recordParents(build, pom);
        build.executeAsync(new MavenBuildProxy.BuildCallable<Void, IOException>(){
            private static final long serialVersionUID = -1360161848504044869L;
            private final Map<String, String> u;
            private final Map<String, String> p;
            {
                this.u = MavenFingerprinter.this.used;
                this.p = MavenFingerprinter.this.produced;
            }

            @Override
            public Void call(MavenBuild build) throws IOException, InterruptedException {
                FingerprintMap map = Jenkins.getInstance().getFingerprintMap();
                for (Map.Entry<String, String> e : this.p.entrySet()) {
                    map.getOrCreate((AbstractBuild)build, e.getKey(), e.getValue()).add((AbstractBuild)build);
                }
                for (Map.Entry<String, String> e : this.u.entrySet()) {
                    map.getOrCreate(null, e.getKey(), e.getValue()).add((AbstractBuild)build);
                }
                HashMap<String, String> all = new HashMap<String, String>(this.u);
                all.putAll(this.p);
                Fingerprinter.FingerprintAction fa = (Fingerprinter.FingerprintAction)build.getAction(Fingerprinter.FingerprintAction.class);
                if (fa != null) {
                    fa.add(all);
                } else {
                    build.getActions().add(new Fingerprinter.FingerprintAction((AbstractBuild)build, all));
                }
                return null;
            }
        });
        return true;
    }

    private void recordParents(MavenBuildProxy build, MavenProject pom) throws IOException, InterruptedException {
        for (MavenProject parent = pom.getParent(); parent != null; parent = parent.getParent()) {
            Artifact parentArtifact;
            ArtifactRepository localRepository;
            File parentFile = parent.getFile();
            if (parentFile == null && (localRepository = this.getLocalRepository(build.getMavenBuildInformation(), parent, pom)) != null && (parentArtifact = this.getArtifact(parent)) != null) {
                parentFile = new File(localRepository.getBasedir(), localRepository.pathOf(parentArtifact));
            }
            if (parentFile == null) continue;
            this.record(parent.getGroupId() + ":" + parent.getArtifactId(), parentFile, this.used);
        }
    }

    private Artifact getArtifact(MavenProject parent) {
        Artifact art = parent.getArtifact();
        if (art == null) {
            DefaultArtifactHandler artifactHandler = new DefaultArtifactHandler("pom");
            art = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), VersionRange.createFromVersion((String)parent.getVersion()), null, "pom", "", (ArtifactHandler)artifactHandler);
        }
        return art;
    }

    private ArtifactRepository getLocalRepository(MavenBuildInformation mavenBuildInformation, MavenProject parent, MavenProject pom) {
        if (mavenBuildInformation.isMaven3OrLater()) {
            return parent.getProjectBuildingRequest().getLocalRepository();
        }
        if (mavenBuildInformation.isAtLeastMavenVersion("2.2")) {
            return this.getArtifactRepositoryMaven21(pom);
        }
        if (mavenBuildInformation.isAtLeastMavenVersion("2.0")) {
            return null;
        }
        LOGGER.warning("Unknown Maven version: " + mavenBuildInformation.getMavenVersion());
        return null;
    }

    private ArtifactRepository getArtifactRepositoryMaven21(MavenProject pom) {
        try {
            Method method = MavenProject.class.getMethod("getProjectBuilderConfiguration", new Class[0]);
            ProjectBuilderConfiguration projectBuilderConfiguration = (ProjectBuilderConfiguration)method.invoke((Object)pom, new Object[0]);
            return projectBuilderConfiguration.getLocalRepository();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve BuilderConfigration", e);
            return null;
        }
    }

    private void record(Collection<Artifact> artifacts, Map<String, String> record) throws IOException, InterruptedException {
        for (Artifact a : artifacts) {
            this.record(a, record);
        }
    }

    private void record(Artifact a, Map<String, String> record) throws IOException, InterruptedException {
        File f = a.getFile();
        this.record(a.getGroupId(), f, record);
    }

    private void record(String fileNamePrefix, File f, Map<String, String> record) throws IOException, InterruptedException {
        if (f == null || this.files.contains(f) || !f.isFile()) {
            return;
        }
        this.files.add(f);
        String digest = new FilePath(f).digest();
        record.put(fileNamePrefix + ':' + f.getName(), digest);
    }

    public static void aggregate(MavenModuleSetBuild mmsb) throws IOException {
        HashMap records = new HashMap();
        for (List<MavenBuild> builds : mmsb.getModuleBuilds().values()) {
            for (MavenBuild build : builds) {
                Fingerprinter.FingerprintAction fa = (Fingerprinter.FingerprintAction)build.getAction(Fingerprinter.FingerprintAction.class);
                if (fa == null) continue;
                records.putAll(fa.getRecords());
            }
        }
        if (!records.isEmpty()) {
            FingerprintMap map = Jenkins.getInstance().getFingerprintMap();
            for (Map.Entry e : records.entrySet()) {
                map.getOrCreate(null, (String)e.getKey(), (String)e.getValue()).add((AbstractBuild)mmsb);
            }
            mmsb.addAction((Action)new Fingerprinter.FingerprintAction((AbstractBuild)mmsb, records));
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return Messages.MavenFingerprinter_DisplayName();
        }

        public MavenReporter newAutoInstance(MavenModule module) {
            return new MavenFingerprinter();
        }
    }
}

