/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.Maven;
import hudson.triggers.Trigger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;

public abstract class AbstractMavenProject<P extends AbstractProject<P, R>, R extends AbstractBuild<P, R>>
extends AbstractProject<P, R>
implements Maven.ProjectWithMaven {
    protected AbstractMavenProject(ItemGroup parent, String name) {
        super(parent, name);
    }

    protected List<Action> createTransientActions() {
        List r = super.createTransientActions();
        HashSet<Class> added = new HashSet<Class>();
        this.addTransientActionsFromBuild(this.getLastBuild(), r, added);
        this.addTransientActionsFromBuild((AbstractBuild)this.getLastSuccessfulBuild(), r, added);
        for (Trigger trigger : this.triggers()) {
            r.addAll(trigger.getProjectActions());
        }
        return r;
    }

    protected abstract void addTransientActionsFromBuild(R var1, List<Action> var2, Set<Class> var3);

    @Deprecated
    public boolean scheduleBuild() {
        return super.scheduleBuild();
    }

    @Deprecated
    public boolean scheduleBuild(int quietPeriod) {
        return super.scheduleBuild(quietPeriod);
    }

    public boolean scheduleBuild(Cause c) {
        return super.scheduleBuild(c);
    }

    public boolean scheduleBuild(int quietPeriod, Cause c) {
        return super.scheduleBuild(quietPeriod, c);
    }

    protected static class MavenModuleDependency
    extends DependencyGraph.Dependency {
        public MavenModuleDependency(AbstractMavenProject<?, ?> upstream, AbstractProject<?, ?> downstream) {
            super(upstream, downstream);
        }

        public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
            AbstractMavenProject parent;
            if (build.getResult().isWorseThan(Result.SUCCESS)) {
                return false;
            }
            AbstractProject downstreamProject = this.getDownstreamProject();
            boolean ignoreUnsuccessfulUpstreams = this.ignoreUnsuccessfulUpstreams(downstreamProject);
            MavenModuleSetBuild mavenModuleSetBuild = null;
            if (build instanceof MavenModuleSetBuild) {
                mavenModuleSetBuild = (MavenModuleSetBuild)build;
            }
            if (this.areUpstreamsBuilding(downstreamProject, parent = (AbstractMavenProject)this.getUpstreamProject(), listener)) {
                return false;
            }
            if (mavenModuleSetBuild != null && mavenModuleSetBuild.isRelease().booleanValue()) {
                return false;
            }
            if (this.inDownstreamProjects(downstreamProject)) {
                listener.getLogger().println("Not triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamProject) + " because it has dependencies in the downstream project list");
                return false;
            }
            AbstractBuild dlb = downstreamProject.getLastBuild();
            for (AbstractMavenProject up : Util.filter((List)downstreamProject.getUpstreamProjects(), AbstractMavenProject.class)) {
                int n;
                Object ulb = up == parent ? (build.getResult() == null || !build.getResult().isWorseThan(Result.UNSTABLE) ? build : up.getLastSuccessfulBuild()) : up.getLastSuccessfulBuild();
                if (ulb == null) {
                    if (!ignoreUnsuccessfulUpstreams) {
                        listener.getLogger().println("Not triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamProject) + " because another upstream " + ModelHyperlinkNote.encodeTo((Item)up) + " has no successful build");
                        return false;
                    }
                    listener.getLogger().println("Another upstream " + ModelHyperlinkNote.encodeTo((Item)up) + " has no successful build but " + ModelHyperlinkNote.encodeTo((Item)downstreamProject) + " is configured to ignore this.");
                }
                if (dlb != null && (n = dlb.getUpstreamRelationship((AbstractProject)up)) != -1 && !ignoreUnsuccessfulUpstreams) assert (ulb.getNumber() >= n);
            }
            return true;
        }

        private boolean areUpstreamsBuilding(AbstractProject<?, ?> downstreamProject, AbstractProject<?, ?> excludeProject, TaskListener listener) {
            DependencyGraph graph = Jenkins.getInstance().getDependencyGraph();
            Set tups = graph.getTransitiveUpstream(downstreamProject);
            for (AbstractProject tup : tups) {
                if (tup == excludeProject || !tup.isBuilding() && !tup.isInQueue()) continue;
                AbstractProject tupr = tup.getRootProject();
                if (tupr instanceof MavenModuleSet && ((MavenModuleSet)tupr).getBlockTriggerWhenBuilding()) {
                    listener.getLogger().println("Not triggering " + ModelHyperlinkNote.encodeTo(downstreamProject) + " because it has a dependency " + ModelHyperlinkNote.encodeTo((Item)tup) + " already building or in queue");
                    return true;
                }
                listener.getLogger().println("Could be blocking trigger of " + ModelHyperlinkNote.encodeTo(downstreamProject) + " (due to a dependency on " + ModelHyperlinkNote.encodeTo((Item)tup) + ") but the upstream is not configured to block while building.");
                return false;
            }
            return false;
        }

        private boolean ignoreUnsuccessfulUpstreams(AbstractProject<?, ?> downstreamProject) {
            MavenModuleSet mavenModuleSet = null;
            if (downstreamProject instanceof MavenModuleSet) {
                mavenModuleSet = (MavenModuleSet)downstreamProject;
            }
            if (downstreamProject instanceof MavenModule) {
                mavenModuleSet = ((MavenModule)downstreamProject).getParent();
            }
            if (mavenModuleSet != null) {
                return mavenModuleSet.ignoreUnsuccessfulUpstreams();
            }
            return false;
        }

        private boolean inDownstreamProjects(AbstractProject<?, ?> downstreamProject) {
            DependencyGraph graph = Jenkins.getInstance().getDependencyGraph();
            Set tups = graph.getTransitiveUpstream(downstreamProject);
            for (AbstractProject tup : tups) {
                List downstreamProjects = this.getUpstreamProject().getDownstreamProjects();
                for (AbstractProject dp : downstreamProjects) {
                    if (dp == this.getUpstreamProject() || dp == downstreamProject || dp != tup) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

