/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import org.apache.maven.plugin.descriptor.PluginDescriptor;

public final class PluginName {
    public final String groupId;
    public final String artifactId;
    public final String version;

    public PluginName(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public PluginName(PluginDescriptor pd) {
        this(pd.getGroupId(), pd.getArtifactId(), pd.getVersion());
    }

    public String toString() {
        return this.groupId + ':' + this.artifactId + ':' + this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginName that = (PluginName)o;
        return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean matches(String groupId, String artifactId) {
        return this.groupId.equals(groupId) && this.artifactId.equals(artifactId);
    }
}

