/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Platform;
import hudson.Proc;
import hudson.Util;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenProcessFactory;
import hudson.maven.PlexusModuleContributorFactory;
import hudson.maven.ProcessCache;
import hudson.maven.TcpSocketHostLocator;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.Pipe;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import hudson.remoting.Which;
import hudson.slaves.Channels;
import hudson.tasks.Maven;
import hudson.tasks._maven.MavenConsoleAnnotator;
import hudson.util.ArgumentListBuilder;
import hudson.util.StreamCopyThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;

public abstract class AbstractMavenProcessFactory {
    private final MavenModuleSet mms;
    private final AbstractMavenBuild<?, ?> build;
    private final Launcher launcher;
    private final EnvVars envVars;
    private final FilePath workDir;
    private final String mavenOpts;
    public static boolean mavenRemoteUseInet = Boolean.getBoolean("maven.remote.useinet");
    public static final String MAVEN_REMOTE_USEINET_ENV_VAR_NAME = "MAVEN_REMOTE_USEINET";
    public static boolean yjp = Boolean.getBoolean("hudson.maven.yjp");
    public static int debugPort;

    AbstractMavenProcessFactory(MavenModuleSet mms, AbstractMavenBuild<?, ?> build, Launcher launcher, EnvVars envVars, String mavenOpts, FilePath workDir) {
        this.build = build;
        this.mms = mms;
        this.launcher = launcher;
        this.envVars = envVars;
        this.workDir = workDir;
        this.mavenOpts = mavenOpts;
    }

    public ProcessCache.NewProcess newProcess(BuildListener listener, OutputStream out) throws IOException, InterruptedException {
        if (MavenProcessFactory.debug) {
            listener.getLogger().println("Using env variables: " + String.valueOf(this.envVars));
        }
        try {
            Channel ch;
            Proc proc;
            Charset charset;
            try {
                charset = Charset.forName((String)this.launcher.getChannel().call((Callable)new GetCharset()));
            }
            catch (UnsupportedCharsetException e) {
                charset = StandardCharsets.ISO_8859_1;
            }
            MavenConsoleAnnotator mca = new MavenConsoleAnnotator(out, charset);
            JDK jdk = this.getJava((TaskListener)listener);
            JDK originalJdk = null;
            block8: while (true) {
                Connection con;
                TcpSocketHostLocator locator;
                Acceptor acceptor = (Acceptor)this.launcher.getChannel().call((Callable)new SocketHandler());
                String hostName = null;
                Iterator<TcpSocketHostLocator> iterator = TcpSocketHostLocator.all().iterator();
                while (iterator.hasNext() && (hostName = (locator = iterator.next()).getTcpSocketHost()) == null) {
                }
                Object socket = hostName != null ? hostName + ":" + acceptor.getPort() : String.valueOf(acceptor.getPort());
                listener.getLogger().println("Established TCP socket on " + (String)socket);
                ArgumentListBuilder cmdLine = this.buildMavenAgentCmdLine(listener, (String)socket, jdk);
                Object[] cmds = cmdLine.toCommandArray();
                proc = this.launcher.launch().cmds((String[])cmds).envs((Map)this.envVars).stdout((OutputStream)mca).pwd(this.workDir).start();
                try {
                    con = acceptor.accept();
                }
                catch (SocketTimeoutException e) {
                    if (!proc.isAlive()) {
                        throw new AbortException("Failed to launch Maven. Exit code = " + proc.join());
                    }
                    throw e;
                }
                try {
                    ch = Channels.forProcess((String)("Channel to Maven " + Arrays.toString(cmds)), (ExecutorService)Computer.threadPoolForRemoting, (InputStream)new BufferedInputStream(con.in), (OutputStream)new BufferedOutputStream(con.out), (OutputStream)listener.getLogger(), (Proc)proc);
                    ch.call((Callable)new ConfigureOriginalJDK(originalJdk));
                }
                catch (IOException x) {
                    if (originalJdk == null) {
                        for (Throwable t = x; t != null; t = t.getCause()) {
                            if (!(t instanceof UnsupportedClassVersionError) && !(t instanceof SocketException)) continue;
                            listener.error("================================================================================");
                            listener.error("Invalid project setup: " + t.getMessage());
                            listener.error("[JENKINS-18403][JENKINS-28294] JDK '" + jdk.getName() + "' not supported to run Maven projects.");
                            listener.error("Maven projects have to be launched with a Java version greater or equal to the minimum version required by the controller.");
                            listener.error("Use the Maven JDK Toolchains (plugin) to build your maven project with an older JDK.");
                            listener.error("Retrying with agent Java and setting compile/test properties to point to " + jdk.getHome() + ".");
                            listener.error("================================================================================");
                            originalJdk = jdk;
                            jdk = (JDK)this.launcher.getChannel().call((Callable)new FindJavaHome());
                            continue block8;
                        }
                    }
                    throw x;
                }
                break;
            }
            if (!PlexusModuleContributorFactory.all().isEmpty()) {
                this.applyPlexusModuleContributor(ch, this.build);
            }
            return new ProcessCache.NewProcess(ch, proc);
        }
        catch (IOException e) {
            JDK jdk;
            if (Util.fixNull((String)e.getMessage()).contains("java: not found") && (jdk = this.mms.getJDK()) == null) {
                throw new IOException(this.mms.getDisplayName() + " is not configured with a JDK, but your PATH doesn't include Java", e);
            }
            throw e;
        }
    }

    protected abstract void applyPlexusModuleContributor(Channel var1, AbstractMavenBuild<?, ?> var2) throws InterruptedException, IOException;

    protected ArgumentListBuilder buildMavenAgentCmdLine(BuildListener listener, String tcpSocket) throws IOException, InterruptedException {
        return this.buildMavenAgentCmdLine(listener, tcpSocket, this.getJava((TaskListener)listener));
    }

    private ArgumentListBuilder buildMavenAgentCmdLine(BuildListener listener, String tcpSocket, JDK jdk) throws IOException, InterruptedException {
        Maven.MavenInstallation mvn = this.getMavenInstallation((TaskListener)listener);
        if (mvn == null) {
            listener.error("Maven version is not configured for this project. Can't determine which Maven to run");
            throw new Run.RunnerAbortedException();
        }
        if (mvn.getHome() == null) {
            listener.error("Maven '%s' doesn't have its home set", new Object[]{mvn.getName()});
            throw new Run.RunnerAbortedException();
        }
        boolean isMaster = this.getCurrentNode() == Jenkins.get();
        FilePath slaveRoot = null;
        if (!isMaster) {
            slaveRoot = this.getCurrentNode().getRootPath();
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (jdk == null) {
            args.add("java");
        } else {
            args.add(jdk.getHome() + "/bin/java");
        }
        if (debugPort != 0) {
            args.add("-Xrunjdwp:transport=dt_socket,server=y,address=" + debugPort);
        }
        if (yjp) {
            args.add("-agentlib:yjpagent=tracing");
        }
        args.addTokenized(this.getMavenOpts());
        args.add("-cp");
        args.add(this.getMavenAgentClassPath(mvn, slaveRoot, listener));
        args.add(this.getMainClassName());
        args.add(mvn.getHome());
        String remotingJar = (String)this.getLauncher().getChannel().call((Callable)new GetRemotingJar());
        if (remotingJar == null) {
            listener.error("Failed to determine the location of remoting.jar");
            throw new Run.RunnerAbortedException();
        }
        args.add(remotingJar);
        args.add(this.getMavenInterceptorClassPath(mvn, slaveRoot, listener));
        String mavenInterceptorCommonClasspath = this.getMavenInterceptorCommonClassPath(mvn, slaveRoot, listener);
        if (mavenInterceptorCommonClasspath != null) {
            args.add(mavenInterceptorCommonClasspath);
        }
        args.add(tcpSocket);
        String interceptorOverride = this.getMavenInterceptorOverride(mvn, slaveRoot, listener);
        if (interceptorOverride != null) {
            args.add(interceptorOverride);
        }
        return args;
    }

    protected abstract String getMavenAgentClassPath(Maven.MavenInstallation var1, FilePath var2, BuildListener var3) throws IOException, InterruptedException;

    protected abstract String getMavenInterceptorClassPath(Maven.MavenInstallation var1, FilePath var2, BuildListener var3) throws IOException, InterruptedException;

    protected String getMavenInterceptorCommonClassPath(Maven.MavenInstallation mvn, FilePath slaveRoot, BuildListener listener) throws IOException, InterruptedException {
        return null;
    }

    protected abstract String getMavenInterceptorOverride(Maven.MavenInstallation var1, FilePath var2, BuildListener var3) throws IOException, InterruptedException;

    protected abstract String getMainClassName();

    public String getMavenOpts() {
        Node n;
        if (this.mavenOpts != null) {
            return this.addRunHeadLessOption(this.mavenOpts);
        }
        String mavenOpts = this.mms.getMavenOpts();
        if ((mavenOpts == null || mavenOpts.trim().length() == 0) && (n = this.getCurrentNode()) != null) {
            try {
                String localMavenOpts = (String)n.toComputer().getEnvironment().get((Object)"MAVEN_OPTS");
                if (localMavenOpts != null && localMavenOpts.trim().length() > 0) {
                    mavenOpts = localMavenOpts;
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        mavenOpts = this.addRunHeadLessOption(mavenOpts);
        return this.envVars.expand(mavenOpts);
    }

    protected String addRunHeadLessOption(String mavenOpts) {
        if (this.mms.runHeadless()) {
            mavenOpts = mavenOpts == null ? "-Djava.awt.headless=true" : (String)mavenOpts + " -Djava.awt.headless=true";
        } else if (Platform.isDarwin()) {
            // empty if block
        }
        return mavenOpts;
    }

    public Maven.MavenInstallation getMavenInstallation(TaskListener log) throws IOException, InterruptedException {
        Maven.MavenInstallation mi = this.mms.getMaven();
        if (mi != null) {
            mi = mi.forNode(this.getCurrentNode(), log).forEnvironment(this.envVars);
        }
        return mi;
    }

    @CheckForNull
    public JDK getJava(TaskListener log) throws IOException, InterruptedException {
        JDK jdk = this.mms.getJDK();
        if (jdk != null) {
            jdk = jdk.forNode(this.getCurrentNode(), log).forEnvironment(this.envVars);
        }
        return jdk;
    }

    protected final String classPathEntry(FilePath root, Class<?> representative, String seedName, TaskListener listener) throws IOException, InterruptedException {
        if (root == null) {
            return Which.jarFile(representative).getAbsolutePath();
        }
        return AbstractMavenProcessFactory.copyJar(listener.getLogger(), root, representative, seedName).getRemote();
    }

    static FilePath copyJar(PrintStream log, FilePath dst, Class<?> representative, String seedName) throws IOException, InterruptedException {
        File jar = Which.jarFile(representative);
        FilePath copiedJar = dst.child(seedName + ".jar");
        if (jar.isDirectory()) {
            Zip zip = new Zip();
            zip.setBasedir(jar);
            File t = File.createTempFile(seedName, "jar");
            t.delete();
            zip.setDestFile(t);
            zip.setProject(new Project());
            zip.execute();
            jar = t;
        } else if (copiedJar.exists() && copiedJar.digest().equals(Util.getDigestOf((File)jar))) {
            log.println(seedName + ".jar already up to date");
            return copiedJar;
        }
        new FilePath(jar).copyTo(copiedJar);
        log.println("Copied " + seedName + ".jar");
        return copiedJar;
    }

    protected Node getCurrentNode() {
        return Executor.currentExecutor().getOwner().getNode();
    }

    protected MavenModuleSet getMavenModuleSet() {
        return this.mms;
    }

    protected Launcher getLauncher() {
        return this.launcher;
    }

    protected EnvVars getEnvVars() {
        return this.envVars;
    }

    static {
        String port = System.getProperty("hudson.maven.debugPort");
        if (port != null) {
            debugPort = Integer.parseInt(port);
        }
    }

    private static final class GetCharset
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 3459269768733083577L;

        private GetCharset() {
        }

        public String call() throws IOException {
            return System.getProperty("file.encoding");
        }
    }

    private static final class SocketHandler
    extends MasterToSlaveCallable<Acceptor, IOException> {
        private static final long serialVersionUID = 1L;

        private SocketHandler() {
        }

        public Acceptor call() throws IOException {
            return new AcceptorImpl();
        }

        static final class AcceptorImpl
        implements Acceptor,
        Serializable {
            private static final long serialVersionUID = -2226788819948521018L;
            private final transient ServerSocket serverSocket = new ServerSocket();

            AcceptorImpl() throws IOException {
                this.serverSocket.bind(null);
                this.serverSocket.setSoTimeout(MavenProcessFactory.socketTimeOut);
            }

            @Override
            public Connection accept() throws IOException {
                Socket socket = this.serverSocket.accept();
                socket.setKeepAlive(true);
                this.serverSocket.close();
                return new Connection(socket);
            }

            @Override
            public int getPort() {
                return this.serverSocket.getLocalPort();
            }

            private Object writeReplace() {
                return Channel.current().export(Acceptor.class, (Object)this);
            }
        }
    }

    static interface Acceptor {
        public Connection accept() throws IOException;

        public int getPort() throws UnknownHostException;
    }

    static final class Connection
    implements Serializable {
        public InputStream in;
        public OutputStream out;
        private Pipe pipe;
        private transient Socket socket;
        private static final long serialVersionUID = 1L;

        @SuppressFBWarnings(value={"SE_BAD_FIELD_STORE"}, justification="TODO needs triage")
        Connection(Socket socket) throws IOException {
            this.in = new SocketInputStream(socket);
            this.out = new SocketOutputStream(socket);
            this.socket = socket;
        }

        private Connection(Pipe in, OutputStream out) {
            this.pipe = in;
            this.out = out;
        }

        private Object writeReplace() {
            Pipe p = Pipe.createLocalToRemote();
            new StreamCopyThread("Stream reader: maven process at " + String.valueOf(this.socket), this.in, p.getOut(), true).start();
            return new Connection(p, (OutputStream)new RemoteOutputStream(this.out));
        }

        private Object readResolve() {
            assert (this.in == null);
            this.in = this.pipe.getIn();
            assert (this.out != null);
            assert (this.socket == null);
            return this;
        }
    }

    private static final class ConfigureOriginalJDK
    extends MasterToSlaveCallable<Void, Error> {
        private static final long serialVersionUID = 1L;
        private final JDK jdk;

        ConfigureOriginalJDK(JDK jdk) {
            this.jdk = jdk;
        }

        public Void call() throws Error {
            if (this.jdk != null) {
                System.setProperty("maven.compiler.fork", "true");
                System.setProperty("maven.compiler.executable", new File(this.jdk.getBinDir(), File.separatorChar == '\\' ? "javac.exe" : "javac").getAbsolutePath());
                System.setProperty("jvm", new File(this.jdk.getBinDir(), File.separatorChar == '\\' ? "java.exe" : "java").getAbsolutePath());
            }
            return null;
        }
    }

    private static final class FindJavaHome
    extends MasterToSlaveCallable<JDK, Error> {
        private static final long serialVersionUID = 1L;

        private FindJavaHome() {
        }

        public JDK call() throws Error {
            JDK jdk = new JDK("this", System.getProperty("java.home"));
            return jdk.getExists() ? jdk : null;
        }
    }

    protected static final class GetRemotingJar
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 6022357183425911351L;

        protected GetRemotingJar() {
        }

        public String call() throws IOException {
            return Which.jarFile(hudson.remoting.Launcher.class).getPath();
        }
    }

    @Extension(ordinal=0.0)
    public static class UserInetTcpSocketHostLocator
    extends TcpSocketHostLocator {
        @Override
        public String getTcpSocketHost() throws IOException {
            if (mavenRemoteUseInet) {
                InetAddress host = InetAddress.getLocalHost();
                return host.getHostName();
            }
            return null;
        }
    }
}

