/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.ExecutedMojo;
import hudson.maven.FilteredChangeLogSet;
import hudson.maven.Maven3Builder;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuildProxy2;
import hudson.maven.MavenBuilder;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenProjectActionBuilder;
import hudson.maven.MavenReportInfo;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MavenUtil;
import hudson.maven.Messages;
import hudson.maven.ModuleName;
import hudson.maven.MojoInfo;
import hudson.maven.ProcessCache;
import hudson.maven.RedeployPublisher;
import hudson.maven.SplittableBuildListener;
import hudson.maven.UnbuiltModuleAction;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.maven.reporters.SurefireArchiver;
import hudson.maven.reporters.TestFailureDetector;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.MasterToSlaveFileCallable;
import jenkins.maven3.agent.Maven31Main;
import jenkins.maven3.agent.Maven32Main;
import jenkins.maven3.agent.Maven33Main;
import jenkins.maven3.agent.Maven35Main;
import jenkins.model.ArtifactManager;
import org.apache.maven.BuildFailureException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectSorter;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.jvnet.hudson.maven3.agent.Maven3Main;
import org.jvnet.hudson.maven3.launcher.Maven31Launcher;
import org.jvnet.hudson.maven3.launcher.Maven32Launcher;
import org.jvnet.hudson.maven3.launcher.Maven33Launcher;
import org.jvnet.hudson.maven3.launcher.Maven35Launcher;
import org.jvnet.hudson.maven3.launcher.Maven3Launcher;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;

public class MavenBuild
extends AbstractMavenBuild<MavenModule, MavenBuild> {
    List<MavenProjectActionBuilder> projectActionReporters;
    private List<ExecutedMojo> executedMojos;
    private static final int MAX_PROCESS_CACHE = 5;
    protected static final ProcessCache mavenProcessCache = new ProcessCache(5);
    public static boolean debug = false;
    private static final Logger LOGGER = Logger.getLogger(MavenBuild.class.getName());

    public MavenBuild(MavenModule job) throws IOException {
        super(job);
    }

    public MavenBuild(MavenModule job, Calendar timestamp) {
        super(job, timestamp);
    }

    public MavenBuild(MavenModule project, File buildDir) throws IOException {
        super(project, buildDir);
        SurefireArchiver.fixUp(this.projectActionReporters);
    }

    public String getUpUrl() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof MavenModuleSetBuild)) continue;
                return ((Ancestor)ancs.get(i - 1)).getUrl() + "/";
            }
        }
        return super.getUpUrl();
    }

    public String getDisplayName() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof MavenModuleSetBuild)) continue;
                return this.getParent().getDisplayName();
            }
        }
        return super.getDisplayName();
    }

    @CheckForNull
    public MavenModuleSetBuild getParentBuild() {
        return (MavenModuleSetBuild)this.getParent().getParent().getBuildByNumber(this.getNumber());
    }

    public AbstractBuild<?, ?> getRootBuild() {
        MavenModuleSetBuild parent = this.getParentBuild();
        return parent != null ? parent : this;
    }

    @CheckForNull
    public MavenModuleSetBuild getModuleSetBuild() {
        return (MavenModuleSetBuild)this.getParent().getParent().getNearestOldBuild(this.getNumber());
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return new FilteredChangeLogSet(this);
    }

    public boolean hasChangeSetComputed() {
        return true;
    }

    @Exported
    public MavenArtifactRecord getMavenArtifacts() {
        return (MavenArtifactRecord)this.getAction(MavenArtifactRecord.class);
    }

    @Override
    public EnvVars getEnvironment(TaskListener log) throws IOException, InterruptedException {
        EnvVars envs = super.getEnvironment(log);
        Maven.MavenInstallation mvn = ((MavenModule)this.project).getParent().getMaven();
        if (mvn == null) {
            throw new AbortException(Messages.MavenModuleSetBuild_NoMavenConfigured());
        }
        mvn = mvn.forEnvironment(envs).forNode(Computer.currentComputer().getNode(), log);
        mvn.buildEnvVars(envs);
        return envs;
    }

    public void registerAsProjectAction(MavenReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenProjectActionBuilder>();
        }
        this.projectActionReporters.add(reporter);
    }

    public void registerAsProjectAction(MavenProjectActionBuilder builder) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenProjectActionBuilder>();
        }
        this.projectActionReporters.add(builder);
    }

    public List<MavenProjectActionBuilder> getProjectActionBuilders() {
        if (this.projectActionReporters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.projectActionReporters);
    }

    public List<ExecutedMojo> getExecutedMojos() {
        if (this.executedMojos == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.executedMojos);
    }

    public void run() {
        this.execute((Run.RunExecution)new MavenBuildExecution());
        ((MavenModule)this.getProject()).updateTransientActions();
        MavenModuleSetBuild parentBuild = this.getModuleSetBuild();
        if (parentBuild != null) {
            parentBuild.notifyModuleBuild(this);
        }
    }

    public String getWhyKeepLog() {
        MavenModuleSetBuild pb = this.getParentBuild();
        if (pb != null && pb.getWhyKeepLog() != null) {
            return Messages.MavenBuild_KeptBecauseOfParent((Object)pb);
        }
        return super.getWhyKeepLog();
    }

    public static ExecutedMojo.Cache createExecutedMojoCache() {
        return new ExecutedMojo.Cache();
    }

    protected void setWorkspace(FilePath path) {
        super.setWorkspace(path);
    }

    public MavenModule getParent() {
        return (MavenModule)super.getParent();
    }

    protected void setBuiltOnStr(String builtOn) {
        super.setBuiltOnStr(builtOn);
    }

    @Override
    public String getMavenOpts(TaskListener listener, EnvVars envVars) {
        return envVars.expand(this.expandTokens(listener, ((MavenModule)this.getProject()).getParent().getMavenOpts()));
    }

    static /* synthetic */ List access$700(MavenBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ List access$800(MavenBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ List access$900(MavenBuild x0) {
        return x0.buildEnvironments;
    }

    private class MavenBuildExecution
    extends AbstractBuild.AbstractBuildExecution {
        private List<MavenReporter> reporters;

        private MavenBuildExecution() {
            super((AbstractBuild)MavenBuild.this);
        }

        public MavenBuild getBuild() {
            return (MavenBuild)super.getBuild();
        }

        public MavenModule getProject() {
            return (MavenModule)super.getProject();
        }

        protected WorkspaceList.Lease decideWorkspace(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            return wsl.allocate(MavenBuild.this.getModuleSetBuild().getModuleRoot().child(this.getProject().getRelativePath()));
        }

        /*
         * Exception decompiling
         */
        protected Result doRun(BuildListener listener) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Maven3Builder.Maven3BuilderRequest createRequest(ProxyImpl2 buildProxy, MavenModule module, List<String> goals, Map<String, String> systemProps, MavenBuildInformation mavenBuildInformation) {
            String mavenVersion = mavenBuildInformation.getMavenVersion();
            Maven3Builder.Maven3BuilderRequest request = new Maven3Builder.Maven3BuilderRequest();
            request.listener = buildProxy.listener;
            request.modules = Collections.singleton(module);
            request.goals = goals;
            request.systemProps = systemProps;
            request.proxies = new HashMap<ModuleName, ProxyImpl2>();
            request.proxies.put(module.getModuleName(), buildProxy);
            request.mavenBuildInformation = mavenBuildInformation;
            request.supportEventSpy = MavenUtil.supportEventSpy(mavenVersion);
            switch (MavenUtil.getMavenVersion(mavenVersion)) {
                case MAVEN_3_0_X: {
                    request.maven3MainClass = Maven3Main.class;
                    request.maven3LauncherClass = Maven3Launcher.class;
                    break;
                }
                case MAVEN_3_1: {
                    request.maven3MainClass = Maven31Main.class;
                    request.maven3LauncherClass = Maven31Launcher.class;
                    break;
                }
                case MAVEN_3_2: {
                    request.maven3MainClass = Maven32Main.class;
                    request.maven3LauncherClass = Maven32Launcher.class;
                    break;
                }
                case MAVEN_3_3: {
                    request.maven3MainClass = Maven33Main.class;
                    request.maven3LauncherClass = Maven33Launcher.class;
                    break;
                }
                default: {
                    request.maven3MainClass = Maven35Main.class;
                    request.maven3LauncherClass = Maven35Launcher.class;
                }
            }
            return request;
        }

        public void post2(BuildListener listener) throws Exception {
            if (this.reporters != null) {
                for (MavenReporter reporter : this.reporters) {
                    reporter.end(MavenBuild.this, this.launcher, listener);
                }
            }
        }
    }

    public class ProxyImpl2
    extends ProxyImpl
    implements MavenBuildProxy2 {
        private static final long serialVersionUID = -3377221864644014218L;
        private final SplittableBuildListener listener;
        long startTime;
        private OutputStream log;
        private final MavenModuleSetBuild parentBuild;
        private boolean blockBuildEvents;

        ProxyImpl2(MavenModuleSetBuild parentBuild, SplittableBuildListener listener) throws FileNotFoundException, IOException, InterruptedException {
            this.parentBuild = parentBuild;
            this.listener = listener;
            this.log = new FileOutputStream(MavenBuild.this.getLogFile());
            for (BuildWrapper wrapper : ((MavenModule)MavenBuild.this.project).getParent().getBuildWrappersList()) {
                this.log = wrapper.decorateLogger((AbstractBuild)parentBuild, this.log);
            }
        }

        @Override
        public void start() {
            if (!this.blockBuildEvents) {
                MavenBuild.this.onStartBuilding();
            }
            this.startTime = System.currentTimeMillis();
            try {
                this.sync();
                this.listener.setSideOutputStream(this.log);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            RunListener.fireStarted((Run)MavenBuild.this, (TaskListener)this.listener);
        }

        @Override
        public void end() {
            if (MavenBuild.this.result == null) {
                this.setResult(Result.SUCCESS);
            }
            if (!this.blockBuildEvents) {
                MavenBuild.this.onEndBuilding();
            }
            MavenBuild.this.duration += System.currentTimeMillis() - this.startTime;
            this.parentBuild.notifyModuleBuild(MavenBuild.this);
            try {
                this.sync();
                this.listener.setSideOutputStream(null);
                MavenBuild.this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                MavenBuild.this.updateSymlinks((TaskListener)this.listener);
            }
            catch (InterruptedException x) {
                Logger.getLogger(MavenBuild.class.getName()).log(Level.WARNING, null, x);
            }
            RunListener.fireCompleted((Run)MavenBuild.this, (TaskListener)this.listener);
        }

        @Override
        public void appendLastLog() {
            try {
                this.sync();
                this.listener.setSideOutputStream(this.log);
                this.listener.setSideOutputStream(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void sync() throws IOException {
            try {
                Channel ch = Channel.current();
                if (ch != null) {
                    this.listener.synchronizeOnMark(ch);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        protected void close() {
            abstract class Terminate
            extends Run.RunExecution {
                Terminate() {
                    super((Run)MavenBuild.this);
                }

                public void post(BuildListener listener) {
                }

                public void cleanUp(BuildListener listener) {
                }
            }
            try {
                this.sync();
                this.log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (MavenBuild.this.isInProgress()) {
                MavenBuild.this.execute(new Terminate(){
                    {
                    }

                    public Result run(BuildListener listener) {
                        return Result.ABORTED;
                    }
                });
            }
            if (MavenBuild.this.hasntStartedYet()) {
                MavenBuild.this.execute(new Terminate(){
                    {
                    }

                    public Result run(BuildListener listener) {
                        listener.getLogger().println(Messages.MavenBuild_FailedEarlier());
                        return Result.NOT_BUILT;
                    }
                });
            }
            this.rememberModulesToBuildAgainNextTime();
        }

        private void rememberModulesToBuildAgainNextTime() {
            MavenModuleSetBuild moduleSetBuild = MavenBuild.this.getModuleSetBuild();
            if (moduleSetBuild == null) {
                return;
            }
            if (MavenBuild.this.hasntStartedYet()) {
                if (moduleSetBuild.getParent().isIncrementalBuild() && moduleSetBuild.getResult() != Result.SUCCESS && moduleSetBuild.getResult() != Result.UNSTABLE) {
                    UnbuiltModuleAction action = (UnbuiltModuleAction)moduleSetBuild.getAction(UnbuiltModuleAction.class);
                    if (action == null) {
                        action = new UnbuiltModuleAction();
                        moduleSetBuild.getActions().add(action);
                    }
                    action.addUnbuiltModule(MavenBuild.this.getParent().getModuleName());
                }
            } else {
                UnbuiltModuleAction unbuiltModuleAction;
                MavenModuleSetBuild previousParentBuild = (MavenModuleSetBuild)moduleSetBuild.getPreviousBuild();
                if (previousParentBuild != null && (unbuiltModuleAction = (UnbuiltModuleAction)previousParentBuild.getAction(UnbuiltModuleAction.class)) != null) {
                    unbuiltModuleAction.removeUnbuildModule(MavenBuild.this.getParent().getModuleName());
                    try {
                        previousParentBuild.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (moduleSetBuild.getParent().isIncrementalBuild() && moduleSetBuild.getResult() != Result.SUCCESS) {
                    MavenModuleSet mavenModuleSet = moduleSetBuild.getParent();
                    boolean isDeploying = false;
                    Result deploymentThreshold = Result.SUCCESS;
                    DescribableList<Publisher, Descriptor<Publisher>> publishers = mavenModuleSet.getPublishersList();
                    for (Publisher publisher : publishers) {
                        if (!(publisher instanceof RedeployPublisher)) continue;
                        isDeploying = true;
                        deploymentThreshold = ((RedeployPublisher)publisher).getTreshold();
                        break;
                    }
                    if (isDeploying && moduleSetBuild.getResult().isWorseThan(deploymentThreshold)) {
                        UnbuiltModuleAction action = (UnbuiltModuleAction)moduleSetBuild.getAction(UnbuiltModuleAction.class);
                        if (action == null) {
                            action = new UnbuiltModuleAction();
                            moduleSetBuild.getActions().add(action);
                        }
                        action.addUnbuiltModule(MavenBuild.this.getParent().getModuleName());
                    }
                }
            }
        }

        public MavenBuild owner() {
            return MavenBuild.this;
        }

        private Object writeReplace() {
            return Channel.current().export(MavenBuildProxy2.class, (Object)((MavenBuildProxy2)Executor.currentExecutor().newImpersonatingProxy(MavenBuildProxy2.class, (Object)this)));
        }

        protected void setBlockBuildEvents(boolean blockBuildEvents) {
            this.blockBuildEvents = blockBuildEvents;
        }
    }

    private static final class CanonicalPath
    extends MasterToSlaveFileCallable<String> {
        private static final long serialVersionUID = 1L;

        private CanonicalPath() {
        }

        public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return f.getCanonicalPath().replace(File.separatorChar, '/');
        }
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD_INNER_CLASS"}, justification="TODO needs triage")
    class ProxyImpl
    implements MavenBuildProxy,
    Serializable {
        private static final long serialVersionUID = 8865133776526671879L;
        private final Map<String, String> artifacts = new LinkedHashMap<String, String>();

        ProxyImpl() {
        }

        @Override
        public <V, T extends Throwable> V execute(MavenBuildProxy.BuildCallable<V, T> program) throws T, IOException, InterruptedException {
            return program.call(MavenBuild.this);
        }

        @Override
        public final void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
            throw new AssertionError();
        }

        private FilePath transferArea() {
            FilePath ws = MavenBuild.this.getWorkspace();
            Channel mavenChannel = Channel.current();
            if (mavenChannel != null) {
                ws = new FilePath((VirtualChannel)mavenChannel, ws.getRemote());
            }
            return WorkspaceList.tempDir((FilePath)ws).child("maven-reporters");
        }

        private void copyFromTransferArea(FilePath transferAreaSubdir, File target, BuildListener listener, boolean restricted) throws IOException, InterruptedException {
            if (transferAreaSubdir.isDirectory()) {
                listener.getLogger().println("Copying " + String.valueOf(transferAreaSubdir) + " to " + String.valueOf(target));
                if (restricted) {
                    transferAreaSubdir.copyRecursiveTo(ExtensionList.lookup(MavenReporterDescriptor.class).stream().map(MavenReporterDescriptor::reportedFilePattern).filter(Objects::nonNull).collect(Collectors.joining(",")), new FilePath(target));
                } else {
                    transferAreaSubdir.copyRecursiveTo(new FilePath(target));
                }
            }
        }

        @Override
        public FilePath getRootDir() {
            return this.transferArea().child("build");
        }

        @Override
        public FilePath getProjectRootDir() {
            return this.transferArea().child("project");
        }

        @Override
        public FilePath getModuleSetRootDir() {
            return this.transferArea().child("moduleset");
        }

        @Override
        @Deprecated
        public FilePath getArtifactsDir() {
            return this.transferArea().child("artifacts");
        }

        @Override
        public void queueArchiving(String artifactPath, String artifact) {
            this.artifacts.put(artifactPath, artifact);
        }

        void performArchiving(Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
            long startTime = System.currentTimeMillis();
            for (Map.Entry<String, String> e : this.artifacts.entrySet()) {
                listener.getLogger().println("[JENKINS] Archiving " + e.getValue() + " to " + e.getKey());
            }
            ArtifactManager am = MavenBuild.this.pickArtifactManager();
            FilePath ws = MavenBuild.this.getWorkspace();
            LinkedHashMap<String, String> artifactsInsideWorkspace = new LinkedHashMap<String, String>();
            String prefix = (String)ws.act((FilePath.FileCallable)new CanonicalPath()) + "/";
            Iterator<Map.Entry<String, String>> it = this.artifacts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                String p = (String)new FilePath(ws, e.getValue()).act((FilePath.FileCallable)new CanonicalPath());
                if (!p.startsWith(prefix)) {
                    listener.getLogger().println(p + " is not inside " + prefix + "; will archive in a separate pass");
                    continue;
                }
                artifactsInsideWorkspace.put(e.getKey(), p.substring(prefix.length()));
                it.remove();
            }
            if (!artifactsInsideWorkspace.isEmpty()) {
                am.archive(ws, launcher, listener, artifactsInsideWorkspace);
            }
            for (Map.Entry<String, String> e : this.artifacts.entrySet()) {
                FilePath f = new FilePath(ws, e.getValue());
                am.archive(f.getParent(), launcher, listener, Collections.singletonMap(e.getKey(), f.getName()));
            }
            this.copyFromTransferArea(this.getRootDir(), MavenBuild.this.getRootDir(), listener, true);
            this.copyFromTransferArea(this.getProjectRootDir(), MavenBuild.this.getParent().getRootDir(), listener, true);
            this.copyFromTransferArea(this.getModuleSetRootDir(), MavenBuild.this.getParent().getParent().getRootDir(), listener, true);
            this.copyFromTransferArea(this.getArtifactsDir(), MavenBuild.this.getArtifactsDir(), listener, false);
        }

        @Override
        public void setResult(Result result) {
            if (!MavenBuild.this.isBuilding()) {
                LOGGER.log(Level.WARNING, "JENKINS-25406: illegal attempt to change result from {0} to {1} after {2} finished building", new Object[]{MavenBuild.this.getResult(), result, MavenBuild.this});
                return;
            }
            MavenBuild.this.setResult(result);
        }

        @Override
        public Calendar getTimestamp() {
            return MavenBuild.this.getTimestamp();
        }

        @Override
        public long getMilliSecsSinceBuildStart() {
            return System.currentTimeMillis() - this.getTimestamp().getTimeInMillis();
        }

        @Override
        public boolean isArchivingDisabled() {
            return MavenBuild.this.getParent().getParent().isArchivingDisabled();
        }

        @Override
        public boolean isSiteArchivingDisabled() {
            return MavenBuild.this.getParent().getParent().isSiteArchivingDisabled();
        }

        @Override
        public void registerAsProjectAction(MavenReporter reporter) {
            MavenBuild.this.registerAsProjectAction(reporter);
        }

        @Override
        public void registerAsProjectAction(MavenProjectActionBuilder builder) {
            MavenBuild.this.registerAsProjectAction(builder);
        }

        @Override
        public void registerAsAggregatedProjectAction(MavenReporter reporter) {
            MavenModuleSetBuild pb = MavenBuild.this.getParentBuild();
            if (pb != null) {
                pb.registerAsProjectAction(reporter);
            }
        }

        @Override
        public void setExecutedMojos(List<ExecutedMojo> executedMojos) {
            MavenBuild.this.executedMojos = executedMojos;
        }

        private Object writeReplace() {
            return Channel.current().export(MavenBuildProxy.class, (Object)this);
        }

        @Override
        public MavenBuildInformation getMavenBuildInformation() {
            return new MavenBuildInformation(MavenBuild.this.getModuleSetBuild().getMavenVersionUsed());
        }
    }

    private static final class Builder
    extends MavenBuilder {
        private final MavenBuildProxy buildProxy;
        private final AtomicBoolean hasTestFailures = new AtomicBoolean();
        private final List<ExecutedMojo> executedMojos = new ArrayList<ExecutedMojo>();
        private final ModuleName moduleName;
        private long startTime;
        private static final long serialVersionUID = 1L;

        public Builder(BuildListener listener, MavenBuildProxy buildProxy, MavenModule module, List<String> goals, Map<String, String> systemProps) {
            super(listener, Collections.singleton(module), goals, systemProps);
            this.buildProxy = new FilterImpl(buildProxy);
            this.moduleName = module.getModuleName();
        }

        @Deprecated
        @CheckForNull
        private static MavenProject getTopLevelProject(ReactorManager rm) throws BuildFailureException {
            ProjectSorter sorter;
            List sortedProjects = rm.getSortedProjects();
            if (sortedProjects.isEmpty()) {
                return null;
            }
            try {
                sorter = new ProjectSorter((Collection)sortedProjects);
            }
            catch (CycleDetectedException ex) {
                throw new BuildFailureException("Cannot retrieve the top-level project due to the cycle", (Throwable)ex);
            }
            catch (DuplicateProjectException ex) {
                throw new BuildFailureException("Cannot retrieve the duplicate in the project list", (Throwable)ex);
            }
            return sorter.getTopLevelProject();
        }

        @Override
        void preBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                r.preBuild(this.buildProxy, Builder.getTopLevelProject(rm), this.listener);
            }
        }

        @Override
        void postBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            this.buildProxy.setExecutedMojos(this.executedMojos);
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                r.postBuild(this.buildProxy, Builder.getTopLevelProject(rm), this.listener);
            }
        }

        @Override
        void preExecute(MavenProject project, MojoInfo info) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.preExecute(this.buildProxy, project, info, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(String.valueOf(r) + " failed");
            }
            this.startTime = System.currentTimeMillis();
        }

        @Override
        void postExecute(MavenProject project, MojoInfo info, Exception exception) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            this.executedMojos.add(new ExecutedMojo(info, System.currentTimeMillis() - this.startTime));
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (!r.postExecute(this.buildProxy, project, info, this.listener, exception)) {
                    throw new hudson.maven.agent.AbortException(String.valueOf(r) + " failed");
                }
                if (!(r instanceof TestFailureDetector) || !((TestFailureDetector)r).hasTestFailures()) continue;
                this.hasTestFailures.compareAndSet(false, true);
            }
        }

        @Override
        void onReportGenerated(MavenProject project, MavenReportInfo report) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.reportGenerated(this.buildProxy, project, report, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(String.valueOf(r) + " failed");
            }
        }

        @Override
        void preModule(MavenProject project) throws InterruptedException, IOException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.enterModule(this.buildProxy, project, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(String.valueOf(r) + " failed");
            }
        }

        @Override
        void postModule(MavenProject project) throws InterruptedException, IOException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.leaveModule(this.buildProxy, project, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(String.valueOf(r) + " failed");
            }
        }

        @Override
        public boolean hasBuildFailures() {
            return this.hasTestFailures.get();
        }

        private class FilterImpl
        extends MavenBuildProxy.Filter<MavenBuildProxy>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            public FilterImpl(MavenBuildProxy buildProxy) {
                super(buildProxy);
            }

            @Override
            public void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
                Builder.this.recordAsynchronousExecution(Channel.current().callAsync((Callable)new MavenBuildProxy.Filter.AsyncInvoker(this.core, program)));
            }
        }
    }
}

