/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.maven.MavenUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class MavenBuildInformation
implements Serializable {
    private static final long serialVersionUID = -3719709179508200057L;
    private String mavenVersion;
    public final Map<String, String> modelParents = new HashMap<String, String>();

    public MavenBuildInformation(String mavenVersion) {
        this.mavenVersion = mavenVersion;
    }

    public String getMavenVersion() {
        return this.mavenVersion;
    }

    public boolean isMaven3OrLater() {
        return MavenUtil.maven3orLater(this.mavenVersion);
    }

    public boolean isAtLeastMavenVersion(String version) {
        if (StringUtils.isBlank((CharSequence)this.mavenVersion)) {
            return false;
        }
        return new ComparableVersion(this.mavenVersion).compareTo(new ComparableVersion(version)) >= 0;
    }

    public String toString() {
        return this.mavenVersion;
    }
}

