/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;

public class MavenSiteArchiver
extends MavenReporter {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        File destDir;
        if (!mojo.is("org.apache.maven.plugins", "maven-site-plugin", "site")) {
            return true;
        }
        if (build.isSiteArchivingDisabled()) {
            listener.getLogger().println("[JENKINS] Archiving disabled - not archiving site for " + pom.getName());
            return true;
        }
        try {
            destDir = mojo.getConfigurationValue("outputDirectory", File.class);
        }
        catch (ComponentConfigurationException e) {
            e.printStackTrace(listener.fatalError("Unable to find the site output directory"));
            build.setResult(Result.FAILURE);
            return true;
        }
        if (destDir != null && destDir.exists()) {
            FilePath target = this.getModulePath(build, pom);
            try {
                listener.getLogger().printf("[JENKINS] Archiving site from %s to %s%n", destDir, target);
                new FilePath(destDir).copyRecursiveTo(target);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to copy site from %s to %s", new Object[]{destDir, target}));
                build.setResult(Result.FAILURE);
            }
            build.registerAsAggregatedProjectAction(this);
        }
        return true;
    }

    private FilePath getModulePath(MavenBuildProxy build, MavenProject pom) throws IOException, InterruptedException {
        String rootArtifactId = build.execute(new MavenSiteArchiverBuildCallable());
        Object path = "";
        MavenProject currentLevel = pom;
        while (!rootArtifactId.equals(currentLevel.getArtifactId())) {
            path = currentLevel.getArtifactId() + File.separator + (String)path;
            currentLevel = currentLevel.getParent();
        }
        return build.getModuleSetRootDir().child("site").child((String)path);
    }

    @Override
    public Collection<? extends Action> getProjectActions(MavenModule project) {
        return Collections.singleton(new SiteAction((AbstractItem)project));
    }

    @Override
    public Action getAggregatedProjectAction(MavenModuleSet project) {
        return new SiteAction((AbstractItem)project);
    }

    private static File getSiteDir(AbstractItem project) {
        return new File(project.getRootDir(), "site");
    }

    static class MavenSiteArchiverBuildCallable
    implements MavenBuildProxy.BuildCallable<String, IOException> {
        private static final long serialVersionUID = 1L;

        MavenSiteArchiverBuildCallable() {
        }

        @Override
        public String call(MavenBuild mavenBuild) throws IOException, InterruptedException {
            MavenModuleSet moduleSet = mavenBuild.getModuleSetBuild().getParent();
            if (moduleSet == null) {
                throw new IOException("Parent build not found!");
            }
            return moduleSet.getRootModule().getArtifactId();
        }
    }

    public static class SiteAction
    implements ProminentProjectAction {
        private final AbstractItem project;

        public SiteAction(AbstractItem project) {
            this.project = project;
        }

        public String getUrlName() {
            return "site";
        }

        public String getDisplayName() {
            return Messages.MavenSiteArchiver_DisplayName();
        }

        public String getIconFileName() {
            if (MavenSiteArchiver.getSiteDir(this.project).exists()) {
                return "help.svg";
            }
            return null;
        }

        public DirectoryBrowserSupport doDynamic() {
            File siteDir = MavenSiteArchiver.getSiteDir(this.project);
            return new DirectoryBrowserSupport((ModelObject)this.project, new FilePath(siteDir), this.project.getDisplayName() + " site", "help.svg", !new File(siteDir, "index.html").isFile());
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return "Maven site";
        }

        @Override
        public MavenSiteArchiver newAutoInstance(MavenModule module) {
            return new MavenSiteArchiver();
        }

        @Override
        public String reportedFilePattern() {
            return "site/";
        }
    }
}

