/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.maven.reporters.ReportAction;
import hudson.model.BuildListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;

public class ReportCollector
extends MavenReporter {
    private transient ReportAction action;
    private static final long serialVersionUID = 1L;

    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        String projectReportPath;
        if (!(mojo.mojo instanceof MavenReport)) {
            return true;
        }
        MavenReport report = (MavenReport)mojo.mojo;
        String reportPath = report.getReportOutputDirectory().getPath();
        if (!reportPath.startsWith(projectReportPath = pom.getReporting().getOutputDirectory())) {
            listener.getLogger().println(Messages.ReportCollector_OutsideSite(reportPath, projectReportPath));
            return true;
        }
        if (this.action == null) {
            this.action = new ReportAction();
        }
        File top = new File(report.getReportOutputDirectory(), report.getOutputName() + ".html");
        String relPath = top.getPath().substring(projectReportPath.length());
        this.action.add(new ReportAction.Entry(relPath, report.getName(Locale.getDefault())));
        return true;
    }

    @Override
    public boolean leaveModule(MavenBuildProxy build, MavenProject pom, BuildListener listener) throws InterruptedException, IOException {
        if (this.action != null) {
            build.executeAsync(new AddActionTask(this.action));
        }
        this.action = null;
        return super.leaveModule(build, pom, listener);
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    private static final class AddActionTask
    implements MavenBuildProxy.BuildCallable<Void, IOException> {
        private final ReportAction action;
        private static final long serialVersionUID = 1L;

        public AddActionTask(ReportAction action) {
            this.action = action;
        }

        @Override
        public Void call(MavenBuild build) throws IOException, InterruptedException {
            build.addAction(this.action);
            return null;
        }
    }

    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

        public String getDisplayName() {
            return Messages.ReportCollector_DisplayName();
        }

        @Override
        public ReportCollector newAutoInstance(MavenModule module) {
            return new ReportCollector();
        }
    }
}

