/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Capability;
import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.CommandTransport;
import hudson.remoting.ObjectInputStreamEx;
import hudson.remoting.SynchronousCommandTransport;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

final class ClassicCommandTransport
extends SynchronousCommandTransport {
    private final ObjectInputStream ois;
    private final ObjectOutputStream oos;
    private final Capability remoteCapability;
    private final OutputStream underlyingStream;

    private ClassicCommandTransport(ObjectInputStream ois, ObjectOutputStream oos, OutputStream underlyingStream, Capability remoteCapability) {
        this.ois = ois;
        this.oos = oos;
        this.underlyingStream = underlyingStream;
        this.remoteCapability = remoteCapability;
    }

    public Capability getRemoteCapability() throws IOException {
        return this.remoteCapability;
    }

    public final void write(Command cmd, boolean last) throws IOException {
        cmd.writeTo(this.channel, this.oos);
        this.oos.flush();
        if (!last) {
            this.oos.reset();
        }
    }

    public void closeWrite() throws IOException {
        this.oos.close();
    }

    public final Command read() throws IOException, ClassNotFoundException {
        return Command.readFrom(this.channel, this.ois);
    }

    public void closeRead() throws IOException {
        this.ois.close();
    }

    OutputStream getUnderlyingStream() {
        return this.underlyingStream;
    }

    public static CommandTransport create(Channel.Mode mode, InputStream is, OutputStream os, OutputStream header, ClassLoader base, Capability capability) throws IOException {
        if (base == null) {
            base = ClassicCommandTransport.class.getClassLoader();
        }
        capability.writePreamble(os);
        ObjectOutputStream oos = null;
        if (mode != Channel.Mode.NEGOTIATE) {
            os.write(mode.preamble);
            oos = new ObjectOutputStream(mode.wrap(os));
            oos.flush();
        }
        Channel.Mode[] modes = new Channel.Mode[]{Channel.Mode.BINARY, Channel.Mode.TEXT};
        byte[][] preambles = new byte[][]{Channel.Mode.BINARY.preamble, Channel.Mode.TEXT.preamble, Capability.PREAMBLE};
        int[] ptr = new int[3];
        Capability cap = new Capability(0L);
        while (true) {
            int ch;
            if ((ch = is.read()) == -1) {
                throw new EOFException("unexpected stream termination");
            }
            for (int i = 0; i < preambles.length; ++i) {
                byte[] preamble = preambles[i];
                if (preamble[ptr[i]] == ch) {
                    int n = i;
                    ptr[n] = ptr[n] + 1;
                    if (ptr[n] != preamble.length) continue;
                    switch (i) {
                        case 0: 
                        case 1: {
                            if (mode == Channel.Mode.NEGOTIATE) {
                                mode = modes[i];
                                os.write(mode.preamble);
                                oos = new ObjectOutputStream(mode.wrap(os));
                                oos.flush();
                            } else if (modes[i] != mode) {
                                throw new IOException("Protocol negotiation failure");
                            }
                            return new ClassicCommandTransport(new ObjectInputStreamEx(mode.wrap(is), base), oos, os, cap);
                        }
                        case 2: {
                            cap = Capability.read(is);
                        }
                    }
                    ptr[i] = 0;
                    continue;
                }
                ptr[i] = 0;
            }
            if (header == null) continue;
            header.write(ch);
        }
    }
}

